// Generated by rstantools.  Do not edit by hand.

/*
    Test is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Test is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Test.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_sr_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_sr");
    reader.add_event(62, 60, "end", "model_sr");
    return reader;
}
#include <stan_meta_header.hpp>
class model_sr
  : public stan::model::model_base_crtp<model_sr> {
private:
        int SIZE;
        int NX;
        vector_d Y;
        vector_d SIGY;
        matrix_d X;
        double C;
        double DELTA;
        int PRIORSIG;
        double B;
        double MU;
public:
    model_sr(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_sr(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_sr_namespace::model_sr";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 11;
            context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
            SIZE = int(0);
            vals_i__ = context__.vals_i("SIZE");
            pos__ = 0;
            SIZE = vals_i__[pos__++];
            check_greater_or_equal(function__, "SIZE", SIZE, 0);
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "NX", "int", context__.to_vec());
            NX = int(0);
            vals_i__ = context__.vals_i("NX");
            pos__ = 0;
            NX = vals_i__[pos__++];
            check_greater_or_equal(function__, "NX", NX, 0);
            current_statement_begin__ = 13;
            validate_non_negative_index("Y", "SIZE", SIZE);
            context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(SIZE));
            Y = Eigen::Matrix<double, Eigen::Dynamic, 1>(SIZE);
            vals_r__ = context__.vals_r("Y");
            pos__ = 0;
            size_t Y_j_1_max__ = SIZE;
            for (size_t j_1__ = 0; j_1__ < Y_j_1_max__; ++j_1__) {
                Y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 14;
            validate_non_negative_index("SIGY", "SIZE", SIZE);
            context__.validate_dims("data initialization", "SIGY", "vector_d", context__.to_vec(SIZE));
            SIGY = Eigen::Matrix<double, Eigen::Dynamic, 1>(SIZE);
            vals_r__ = context__.vals_r("SIGY");
            pos__ = 0;
            size_t SIGY_j_1_max__ = SIZE;
            for (size_t j_1__ = 0; j_1__ < SIGY_j_1_max__; ++j_1__) {
                SIGY(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 15;
            validate_non_negative_index("X", "SIZE", SIZE);
            validate_non_negative_index("X", "NX", NX);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(SIZE,NX));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(SIZE, NX);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = NX;
            size_t X_j_1_max__ = SIZE;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "C", "double", context__.to_vec());
            C = double(0);
            vals_r__ = context__.vals_r("C");
            pos__ = 0;
            C = vals_r__[pos__++];
            check_greater_or_equal(function__, "C", C, 0);
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "DELTA", "double", context__.to_vec());
            DELTA = double(0);
            vals_r__ = context__.vals_r("DELTA");
            pos__ = 0;
            DELTA = vals_r__[pos__++];
            check_greater_or_equal(function__, "DELTA", DELTA, 0);
            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "PRIORSIG", "int", context__.to_vec());
            PRIORSIG = int(0);
            vals_i__ = context__.vals_i("PRIORSIG");
            pos__ = 0;
            PRIORSIG = vals_i__[pos__++];
            check_greater_or_equal(function__, "PRIORSIG", PRIORSIG, 0);
            check_less_or_equal(function__, "PRIORSIG", PRIORSIG, 1);
            current_statement_begin__ = 21;
            context__.validate_dims("data initialization", "B", "double", context__.to_vec());
            B = double(0);
            vals_r__ = context__.vals_r("B");
            pos__ = 0;
            B = vals_r__[pos__++];
            check_greater_or_equal(function__, "B", B, 0);
            current_statement_begin__ = 22;
            context__.validate_dims("data initialization", "MU", "double", context__.to_vec());
            MU = double(0);
            vals_r__ = context__.vals_r("MU");
            pos__ = 0;
            MU = vals_r__[pos__++];
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 28;
            num_params_r__ += 1;
            current_statement_begin__ = 29;
            validate_non_negative_index("bgamma", "NX", NX);
            num_params_r__ += NX;
            current_statement_begin__ = 30;
            validate_non_negative_index("uvs", "SIZE", SIZE);
            num_params_r__ += SIZE;
            current_statement_begin__ = 31;
            validate_non_negative_index("nvs", "SIZE", SIZE);
            num_params_r__ += SIZE;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_sr() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 28;
        if (!(context__.contains_r("b0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable b0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("b0");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "b0", "double", context__.to_vec());
        double b0(0);
        b0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable b0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 29;
        if (!(context__.contains_r("bgamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable bgamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("bgamma");
        pos__ = 0U;
        validate_non_negative_index("bgamma", "NX", NX);
        context__.validate_dims("parameter initialization", "bgamma", "vector_d", context__.to_vec(NX));
        Eigen::Matrix<double, Eigen::Dynamic, 1> bgamma(NX);
        size_t bgamma_j_1_max__ = NX;
        for (size_t j_1__ = 0; j_1__ < bgamma_j_1_max__; ++j_1__) {
            bgamma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(bgamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable bgamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 30;
        if (!(context__.contains_r("uvs")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable uvs missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        context__.validate_dims("parameter initialization", "uvs", "vector_d", context__.to_vec(SIZE));
        Eigen::Matrix<double, Eigen::Dynamic, 1> uvs(SIZE);
        size_t uvs_j_1_max__ = SIZE;
        for (size_t j_1__ = 0; j_1__ < uvs_j_1_max__; ++j_1__) {
            uvs(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, uvs);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable uvs: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 31;
        if (!(context__.contains_r("nvs")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nvs missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nvs");
        pos__ = 0U;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        context__.validate_dims("parameter initialization", "nvs", "vector_d", context__.to_vec(SIZE));
        Eigen::Matrix<double, Eigen::Dynamic, 1> nvs(SIZE);
        size_t nvs_j_1_max__ = SIZE;
        for (size_t j_1__ = 0; j_1__ < nvs_j_1_max__; ++j_1__) {
            nvs(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(nvs);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nvs: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 28;
            local_scalar_t__ b0;
            (void) b0;  // dummy to suppress unused var warning
            if (jacobian__)
                b0 = in__.scalar_constrain(lp__);
            else
                b0 = in__.scalar_constrain();
            current_statement_begin__ = 29;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> bgamma;
            (void) bgamma;  // dummy to suppress unused var warning
            if (jacobian__)
                bgamma = in__.vector_constrain(NX, lp__);
            else
                bgamma = in__.vector_constrain(NX);
            current_statement_begin__ = 30;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> uvs;
            (void) uvs;  // dummy to suppress unused var warning
            if (jacobian__)
                uvs = in__.vector_lub_constrain(0, 1, SIZE, lp__);
            else
                uvs = in__.vector_lub_constrain(0, 1, SIZE);
            current_statement_begin__ = 31;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> nvs;
            (void) nvs;  // dummy to suppress unused var warning
            if (jacobian__)
                nvs = in__.vector_constrain(SIZE, lp__);
            else
                nvs = in__.vector_constrain(SIZE);
            // transformed parameters
            current_statement_begin__ = 35;
            validate_non_negative_index("vs", "SIZE", SIZE);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> vs(SIZE);
            stan::math::initialize(vs, DUMMY_VAR__);
            stan::math::fill(vs, DUMMY_VAR__);
            current_statement_begin__ = 36;
            validate_non_negative_index("mu", "SIZE", SIZE);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(SIZE);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 38;
            if (as_bool(logical_eq(0, PRIORSIG))) {
                current_statement_begin__ = 39;
                stan::math::assign(vs, stan::math::exp(add(stan::math::log(SIGY), multiply(subtract(multiply(uvs, 2), 1), DELTA))));
            } else {
                current_statement_begin__ = 41;
                stan::math::assign(vs, stan::math::exp(add(stan::math::log(SIGY), multiply(nvs, stan::math::sqrt(DELTA)))));
            }
            current_statement_begin__ = 44;
            stan::math::assign(mu, add(b0, multiply(X, bgamma)));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 35;
            size_t vs_j_1_max__ = SIZE;
            for (size_t j_1__ = 0; j_1__ < vs_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(vs(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: vs" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable vs: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "vs", vs, 0);
            current_statement_begin__ = 36;
            size_t mu_j_1_max__ = SIZE;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 48;
            lp_accum__.add(normal_log<propto__>(b0, MU, stan::math::sqrt(B)));
            current_statement_begin__ = 49;
            lp_accum__.add(normal_log<propto__>(bgamma, 0, stan::math::sqrt(C)));
            current_statement_begin__ = 50;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 51;
            lp_accum__.add(normal_log<propto__>(nvs, 0, 1));
            current_statement_begin__ = 52;
            lp_accum__.add(normal_log<propto__>(Y, mu, vs));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("b0");
        names__.push_back("bgamma");
        names__.push_back("uvs");
        names__.push_back("nvs");
        names__.push_back("vs");
        names__.push_back("mu");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_sr_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double b0 = in__.scalar_constrain();
        vars__.push_back(b0);
        Eigen::Matrix<double, Eigen::Dynamic, 1> bgamma = in__.vector_constrain(NX);
        size_t bgamma_j_1_max__ = NX;
        for (size_t j_1__ = 0; j_1__ < bgamma_j_1_max__; ++j_1__) {
            vars__.push_back(bgamma(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> uvs = in__.vector_lub_constrain(0, 1, SIZE);
        size_t uvs_j_1_max__ = SIZE;
        for (size_t j_1__ = 0; j_1__ < uvs_j_1_max__; ++j_1__) {
            vars__.push_back(uvs(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> nvs = in__.vector_constrain(SIZE);
        size_t nvs_j_1_max__ = SIZE;
        for (size_t j_1__ = 0; j_1__ < nvs_j_1_max__; ++j_1__) {
            vars__.push_back(nvs(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 35;
            validate_non_negative_index("vs", "SIZE", SIZE);
            Eigen::Matrix<double, Eigen::Dynamic, 1> vs(SIZE);
            stan::math::initialize(vs, DUMMY_VAR__);
            stan::math::fill(vs, DUMMY_VAR__);
            current_statement_begin__ = 36;
            validate_non_negative_index("mu", "SIZE", SIZE);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu(SIZE);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 38;
            if (as_bool(logical_eq(0, PRIORSIG))) {
                current_statement_begin__ = 39;
                stan::math::assign(vs, stan::math::exp(add(stan::math::log(SIGY), multiply(subtract(multiply(uvs, 2), 1), DELTA))));
            } else {
                current_statement_begin__ = 41;
                stan::math::assign(vs, stan::math::exp(add(stan::math::log(SIGY), multiply(nvs, stan::math::sqrt(DELTA)))));
            }
            current_statement_begin__ = 44;
            stan::math::assign(mu, add(b0, multiply(X, bgamma)));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 35;
            check_greater_or_equal(function__, "vs", vs, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t vs_j_1_max__ = SIZE;
                for (size_t j_1__ = 0; j_1__ < vs_j_1_max__; ++j_1__) {
                    vars__.push_back(vs(j_1__));
                }
                size_t mu_j_1_max__ = SIZE;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    vars__.push_back(mu(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 56;
            validate_non_negative_index("log_lik", "SIZE", SIZE);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(SIZE);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 57;
            for (int i = 1; i <= SIZE; ++i) {
                current_statement_begin__ = 58;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            normal_log(get_base1(Y, i, "Y", 1), get_base1(mu, i, "mu", 1), get_base1(vs, i, "vs", 1)), 
                            "assigning variable log_lik");
            }
            // validate, write generated quantities
            current_statement_begin__ = 56;
            size_t log_lik_j_1_max__ = SIZE;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_sr";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        size_t bgamma_j_1_max__ = NX;
        for (size_t j_1__ = 0; j_1__ < bgamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bgamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t uvs_j_1_max__ = SIZE;
        for (size_t j_1__ = 0; j_1__ < uvs_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nvs_j_1_max__ = SIZE;
        for (size_t j_1__ = 0; j_1__ < nvs_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t vs_j_1_max__ = SIZE;
            for (size_t j_1__ = 0; j_1__ < vs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "vs" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_j_1_max__ = SIZE;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = SIZE;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        size_t bgamma_j_1_max__ = NX;
        for (size_t j_1__ = 0; j_1__ < bgamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bgamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t uvs_j_1_max__ = SIZE;
        for (size_t j_1__ = 0; j_1__ < uvs_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nvs_j_1_max__ = SIZE;
        for (size_t j_1__ = 0; j_1__ < nvs_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t vs_j_1_max__ = SIZE;
            for (size_t j_1__ = 0; j_1__ < vs_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "vs" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_j_1_max__ = SIZE;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = SIZE;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_sr_namespace::model_sr stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
