# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Block Gibbs sampler function.
#'
#' A Bayesian adaptive graphical ridge-type data-augmented block Gibbs sampler for simulating the posterior distribution of the concentration matrix specifying a Gaussian graphical model.
#'
#' @param X Numeric data matrix, data is assumed to be Gaussian distributed.
#' @param burnIn An integer specifying the number of burn-in iterations.
#' @param iterations An integer specifying the length of the Markov chain after the burn-in iterations.
#' @param s A double specifying the value of the prior inverse gamma's shape parameter.
#' @param t A double specifying the value of the prior inverse gamma's scale parameter.
#' @param verbose A logical determining whether the progress of the MCMC sampler should be displayed.
#' @return blockBAGR: List of precision matrices from the Markov chains.
#' @examples
#' # Generate true covariance matrix:
#' p <- 10
#' n <- 50
#' SigTrue <- pracma::Toeplitz(c(0.7^rep(1:p - 1)))
#' CTrue <- pracma::inv(SigTrue)
#' # Generate expected value vector:
#' mu <- rep(0, p)
#' # Generate multivariate normal distribution:
#' set.seed(123)
#' X <- MASS::mvrnorm(n, mu = mu, Sigma = SigTrue)
#' posterior <- blockBAGR(X, iterations = 1000, burnIn = 500)
#' @export
blockBAGR <- function(X, burnIn, iterations, s = 1, t = 1, verbose = TRUE) {
  .Call(`_baygel_blockBAGR`, X, burnIn, iterations, s, t, verbose)
}

#' Block Gibbs sampler function.
#'
#' A Bayesian standard graphical ridge-type data-augmented block Gibbs sampler for simulating the posterior distribution of the concentration matrix specifying a Gaussian graphical model.
#'
#' @param X Numeric data matrix, data is assumed to be Gaussian distributed.
#' @param burnIn An integer specifying the number of burn-in iterations.
#' @param iterations An integer specifying the length of the Markov chain after the burn-in iterations.
#' @param tau A double specifying the value of the variance parameter of both the Gaussian and truncated Gaussian distribution in Bayesian graphical ridge prior.
#' @param mu A double specifying the value of the mean parameter of both the Gaussian and truncated Gaussian distribution in Bayesian graphical ridge prior.
#' @param verbose A logical determining whether the progress of the MCMC sampler should be displayed.
#' @return blockBSGR: List of precision matrices from the Markov chains.
#' @examples
#' # Generate true covariance matrix:
#' p <- 10
#' n <- 50
#' SigTrue <- pracma::Toeplitz(c(0.7^rep(1:p - 1)))
#' CTrue <- pracma::inv(SigTrue)
#' # Generate expected value vector:
#' mu <- rep(0, p)
#' # Generate multivariate normal distribution:
#' set.seed(123)
#' X <- MASS::mvrnorm(n, mu = mu, Sigma = SigTrue)
#' posterior <- blockBSGR(X, iterations = 1000, burnIn = 500)
#' @export
blockBSGR <- function(X, burnIn, iterations, tau = 1, mu = 0, verbose = TRUE) {
  .Call(`_baygel_blockBSGR`, X, burnIn, iterations, tau, mu, verbose)
}

mvrnormArma <- function(n, mu, sigma) {
  .Call(`_baygel_mvrnormArma`, n, mu, sigma)
}
