% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\name{mcmc_plots}
\alias{mcmc_plots}
\alias{mcmc_intervals}
\alias{mcmc_intervals,bayesGAMfit-method}
\alias{mcmc_areas}
\alias{mcmc_areas,bayesGAMfit-method}
\alias{mcmc_hist}
\alias{mcmc_hist,bayesGAMfit-method}
\alias{mcmc_hist_by_chain}
\alias{mcmc_hist_by_chain,bayesGAMfit-method}
\alias{mcmc_dens}
\alias{mcmc_dens,bayesGAMfit-method}
\alias{mcmc_scatter}
\alias{mcmc_scatter,bayesGAMfit-method}
\alias{mcmc_hex}
\alias{mcmc_hex,bayesGAMfit-method}
\alias{mcmc_pairs}
\alias{mcmc_pairs,bayesGAMfit-method}
\alias{mcmc_acf}
\alias{mcmc_acf,bayesGAMfit-method}
\alias{mcmc_acf_bar}
\alias{mcmc_acf_bar,bayesGAMfit-method}
\alias{mcmc_trace}
\alias{mcmc_trace,bayesGAMfit-method}
\alias{mcmc_rhat}
\alias{mcmc_rhat,bayesGAMfit-method}
\alias{mcmc_rhat_hist}
\alias{mcmc_rhat_hist,bayesGAMfit-method}
\alias{mcmc_rhat_data}
\alias{mcmc_rhat_data,bayesGAMfit-method}
\alias{mcmc_neff}
\alias{mcmc_neff,bayesGAMfit-method}
\alias{mcmc_neff_hist}
\alias{mcmc_neff_hist,bayesGAMfit-method}
\alias{mcmc_neff_data}
\alias{mcmc_neff_data,bayesGAMfit-method}
\alias{mcmc_violin}
\alias{mcmc_violin,bayesGAMfit-method}
\title{Plotting for MCMC visualization and diagnostics provided by \code{bayesplot} package}
\usage{
mcmc_intervals(object, ...)

\S4method{mcmc_intervals}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_areas(object, ...)

\S4method{mcmc_areas}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_hist(object, ...)

\S4method{mcmc_hist}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_hist_by_chain(object, ...)

\S4method{mcmc_hist_by_chain}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_dens(object, ...)

\S4method{mcmc_dens}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_scatter(object, ...)

\S4method{mcmc_scatter}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_hex(object, ...)

\S4method{mcmc_hex}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_pairs(object, ...)

\S4method{mcmc_pairs}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_acf(object, ...)

\S4method{mcmc_acf}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_acf_bar(object, ...)

\S4method{mcmc_acf_bar}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_trace(object, ...)

\S4method{mcmc_trace}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_rhat(object, ...)

\S4method{mcmc_rhat}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_rhat_hist(object, ...)

\S4method{mcmc_rhat_hist}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_rhat_data(object, ...)

\S4method{mcmc_rhat_data}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_neff(object, ...)

\S4method{mcmc_neff}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_neff_hist(object, ...)

\S4method{mcmc_neff_hist}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_neff_data(object, ...)

\S4method{mcmc_neff_data}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)

mcmc_violin(object, ...)

\S4method{mcmc_violin}{bayesGAMfit}(
  object,
  regex_pars = c("^beta", "^lambda", "^eps", "^a", "^sigma_u_correlation"),
  ...
)
}
\arguments{
\item{object}{an object of class \code{bayesGAMfit}}

\item{...}{optional additional arguments to pass to the \code{bayesplot} functions}

\item{regex_pars}{character vector of regular expressions of variable names to plot}
}
\value{
These functions call various plotting functions from the \code{bayesplot} package, which returns a list including \code{ggplot2} objects.
}
\description{
Plots of Rhat statistics, ratios of effective sample size to total sample
size, and autocorrelation of MCMC draws.
}
\section{Plot Descriptions from the \code{bayesplot} package documentation}{

\itemize{
\item{\code{mcmc_hist(object, ...)}}{
Default plot called by \code{plot} function.  Histograms of posterior draws with all chains merged.
}
\item{\code{mcmc_dens(object, ...)}}{
Kernel density plots of posterior draws with all chains merged.
}
\item{\code{mcmc_hist_by_chain(object, ...)}}{
Histograms of posterior draws with chains separated via faceting.
}
\item{\code{mcmc_dens_overlay(object, ...)}}{
Kernel density plots of posterior draws with chains separated but
overlaid on a single plot.
}
\item{\code{mcmc_violin(object, ...)}}{
The density estimate of each chain is plotted as a violin with
horizontal lines at notable quantiles.
}
\item{\code{mcmc_dens_chains(object, ...)}}{
Ridgeline kernel density plots of posterior draws with chains separated
but overlaid on a single plot. In \code{mcmc_dens_overlay()} parameters
appear in separate facets; in \code{mcmc_dens_chains()} they appear in the
same panel and can overlap vertically.
}
\item{\code{mcmc_intervals(object, ...)}}{
Plots of uncertainty intervals computed from posterior draws with all
chains merged.
}
\item{\code{mcmc_areas(object, ...)}}{
Density plots computed from posterior draws with all chains merged,
with uncertainty intervals shown as shaded areas under the curves.
}
\item{\code{mcmc_scatter(object, ...)}}{
Bivariate scatterplot of posterior draws. If using a very large number of
posterior draws then \code{mcmc_hex()} may be preferable to avoid
overplotting.
}
\item{\code{mcmc_hex(object, ...)}}{
Hexagonal heatmap of 2-D bin counts. This plot is useful in cases where
the posterior sample size is large enough that \code{mcmc_scatter()} suffers
from overplotting.
}
\item{\code{mcmc_pairs(object, ...)}}{
A square plot matrix with univariate marginal distributions along the
diagonal (as histograms or kernel density plots) and bivariate
distributions off the diagonal (as scatterplots or hex heatmaps).

For the off-diagonal plots, the default is to split the chains so that
(roughly) half are displayed above the diagonal and half are below (all
chains are always merged together for the plots along the diagonal). Other
possibilities are available by setting the \code{condition} argument.
}
\item{\code{mcmc_rhat(object, ...)}, \code{mcmc_rhat_hist(object, ...)}}{
Rhat values as either points or a histogram. Values are colored using
different shades (lighter is better). The chosen thresholds are somewhat
arbitrary, but can be useful guidelines in practice.
\itemize{
\item \emph{light}: below 1.05 (good)
\item \emph{mid}: between 1.05 and 1.1 (ok)
\item \emph{dark}: above 1.1 (too high)
}
\item{\code{mcmc_neff(object, ...)}, \code{mcmc_neff_hist(object, ...)}}{
Ratios of effective sample size to total sample size as either points or a
histogram. Values are colored using different shades (lighter is better).
The chosen thresholds are somewhat arbitrary, but can be useful guidelines
in practice.
\item \emph{light}: between 0.5 and 1 (high)
\item \emph{mid}: between 0.1 and 0.5 (good)
\item \emph{dark}: below 0.1 (low)
}
\item{\code{mcmc_acf(object, ...)}, \code{mcmc_acf_bar(object, ...)}}{
Grid of autocorrelation plots by chain and parameter. The \code{lags} argument
gives the maximum number of lags at which to calculate the autocorrelation
function. \code{mcmc_acf()} is a line plot whereas \code{mcmc_acf_bar()} is a
barplot.
}
}
}
}

\examples{
f <- bayesGAM(weight ~ np(height), data = women, 
              family = gaussian, iter=1000, chains = 1)
mcmc_trace(f)
}
\references{
Gabry, Jonah and Mahr, Tristan (2019).  \emph{bayesplot:  Plotting for Bayesian Models}.  \url{https://mc-stan.org/bayesplot/}

Gabry, J., Simpson, D., Vehtari, A., Betancourt, M., and Gelman, A (2019).  \emph{Visualization in Bayesian Workflow}.  Journal of the Royal Statistical Society: Series A. Vol 182.  Issue 2.  p.389-402.

Gelman, A. and Rubin, D. (1992) \emph{Inference from Iterative Simulation Using Multiple Sequences}.  Statistical Science 7(4) 457-472.

Gelman, A., et. al. (2013) \emph{Bayesian Data Analysis}.  Chapman and Hall/CRC.
}
