% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{c.bayesTest}
\alias{c.bayesTest}
\title{Concatenate bayesTest objects}
\usage{
\method{c}{bayesTest}(..., errorCheck = TRUE)
}
\arguments{
\item{...}{\code{bayesTest} objects}

\item{errorCheck}{check that objects can be concatenated? Setting this to \code{FALSE} can have unintended
effects if the \code{bayesTest} objects have different params but can have some speedups
if you are sure the objects are of the same type.}
}
\value{
A \code{bayesTest} object with concatenated posteriors.
}
\description{
Concatenate method for objects of class "bayesTest".
}
\examples{
A_pois <- rpois(100, 5)
B_pois <- rpois(100, 4.7)

AB1 <- bayesTest(A_pois, B_pois, priors = c('shape' = 25, 'rate' = 5), distribution = 'poisson')
AB2 <- bayesTest(A_pois, B_pois, priors = c('shape' = 25, 'rate' = 5), distribution = 'poisson')
c(AB1, AB2)

}
