% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummy_classifier.R
\name{dummy_classifier}
\alias{dummy_classifier}
\title{dummy classifier for a categorical variable.}
\usage{
dummy_classifier(
  y,
  strategy = "proportional",
  constant = NULL,
  random_state = NULL
)
}
\arguments{
\item{y}{a categorical vector, containing the outcomes of interest}

\item{strategy}{a strategy from "constant", "most_frequent", "proportional", "uniform", or "stratified".}

\item{constant}{a constant value for the constant strategy.}

\item{random_state}{a random seed.}
}
\value{
a list
}
\description{
dummy classifier for a categorical variable.
}
\examples{
# Split the data into training and testing sets
set.seed(2023)
index <- sample(1:nrow(iris), nrow(iris) * 0.8)
train_data <- iris[index,]
test_data <- iris[-index,]
dummy_model <- dummy_classifier(train_data$Species, strategy = "proportional", random_state = 2024)
dummy_model
}
