% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anocva.R
\name{checkNClust}
\alias{checkNClust}
\title{If the number of clusters has not been set, estimates it by using Slope criterion in the range {2, 20}.}
\usage{
checkNClust(dataDist, r = NULL, p = 1, maxClust = 20, clusteringFunction,
  criterion = c("slope", "silhouette"))
}
\arguments{
\item{dataDist}{A matrix with n subjects. Each subject has the size of NxN and represents the distances between the elements of the sample.}

\item{r}{The number of clusters. NULL if it's unknown.}

\item{p}{Slope adjust parameter.}

\item{maxClust}{The maximum number of clusters to be tried if estimating optimal number of clusters. The default value is 20.}

\item{clusteringFunction}{The clustering function that Slope should use.}

\item{criterion}{The criterion that will be used for estimating the number of clusters. The options are "slope" or "silhouette". If not defined, "slope" will be used.}
}
\description{
If the number of clusters has not been set, estimates it by using Slope criterion in the range {2, 20}.
}
\keyword{internal}
