// Generated by rstantools.  Do not edit by hand.

/*
    YPPE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    YPPE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with YPPE.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.19.1
#include <stan/model/model_header.hpp>
namespace model_yppe2_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_yppe2");
    reader.add_event(2, 2, "include", "/chunks/loglikspe.stan");
    reader.add_event(2, 0, "start", "/chunks/loglikspe.stan");
    reader.add_event(88, 86, "end", "/chunks/loglikspe.stan");
    reader.add_event(88, 3, "restart", "model_yppe2");
    reader.add_event(137, 50, "end", "model_yppe2");
    return reader;
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T5__, typename T6__, typename T7__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T5__, T6__, T7__>::type>::type, Eigen::Dynamic, 1>
loglik1_pe(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& status,
               const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& Z,
               const T2__& tau,
               const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& ttt,
               const std::vector<int>& idt,
               const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& lambda,
               const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& psi,
               const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& phi, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T5__, T6__, T7__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 9;
        int q(0);
        (void) q;  // dummy to suppress unused var warning
        stan::math::fill(q, std::numeric_limits<int>::min());
        stan::math::assign(q,cols(Z));
        current_statement_begin__ = 10;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(Z));
        current_statement_begin__ = 11;
        validate_non_negative_index("lht0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lht0(n);
        stan::math::initialize(lht0, DUMMY_VAR__);
        stan::math::fill(lht0, DUMMY_VAR__);
        current_statement_begin__ = 12;
        validate_non_negative_index("Ft0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> Ft0(n);
        stan::math::initialize(Ft0, DUMMY_VAR__);
        stan::math::fill(Ft0, DUMMY_VAR__);
        current_statement_begin__ = 13;
        validate_non_negative_index("Ht0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> Ht0(n);
        stan::math::initialize(Ht0, DUMMY_VAR__);
        stan::math::fill(Ht0, DUMMY_VAR__);
        current_statement_begin__ = 14;
        validate_non_negative_index("lp_short", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lp_short(n);
        stan::math::initialize(lp_short, DUMMY_VAR__);
        stan::math::fill(lp_short, DUMMY_VAR__);
        current_statement_begin__ = 15;
        validate_non_negative_index("lp_long", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lp_long(n);
        stan::math::initialize(lp_long, DUMMY_VAR__);
        stan::math::fill(lp_long, DUMMY_VAR__);
        current_statement_begin__ = 16;
        validate_non_negative_index("log_ht", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_ht(n);
        stan::math::initialize(log_ht, DUMMY_VAR__);
        stan::math::fill(log_ht, DUMMY_VAR__);
        current_statement_begin__ = 17;
        validate_non_negative_index("log_St", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_St(n);
        stan::math::initialize(log_St, DUMMY_VAR__);
        stan::math::fill(log_St, DUMMY_VAR__);
        current_statement_begin__ = 18;
        validate_non_negative_index("loglik", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> loglik(n);
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        current_statement_begin__ = 19;
        validate_non_negative_index("theta", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta(n);
        stan::math::initialize(theta, DUMMY_VAR__);
        stan::math::fill(theta, DUMMY_VAR__);
        current_statement_begin__ = 20;
        validate_non_negative_index("logmix", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> logmix(n);
        stan::math::initialize(logmix, DUMMY_VAR__);
        stan::math::fill(logmix, DUMMY_VAR__);
        current_statement_begin__ = 21;
        validate_non_negative_index("aux", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> aux(n);
        stan::math::initialize(aux, DUMMY_VAR__);
        stan::math::fill(aux, DUMMY_VAR__);
        current_statement_begin__ = 24;
        stan::math::assign(lht0, stan::math::log(stan::model::rvalue(lambda, stan::model::cons_list(stan::model::index_multi(idt), stan::model::nil_index_list()), "lambda")));
        current_statement_begin__ = 25;
        stan::math::assign(Ht0, multiply(ttt, lambda));
        current_statement_begin__ = 26;
        stan::math::assign(Ft0, minus(stan::math::expm1(minus(Ht0))));
        current_statement_begin__ = 27;
        stan::math::assign(lp_short, multiply(Z, psi));
        current_statement_begin__ = 28;
        stan::math::assign(lp_long, multiply(Z, phi));
        current_statement_begin__ = 29;
        stan::math::assign(theta, stan::math::exp(lp_long));
        current_statement_begin__ = 30;
        stan::math::assign(aux, subtract(lp_long, Ht0));
        current_statement_begin__ = 32;
        for (int i = 1; i <= n; ++i) {
            current_statement_begin__ = 34;
            stan::model::assign(logmix, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        log_mix(get_base1(Ft0, i, "Ft0", 1), get_base1(lp_short, i, "lp_short", 1), get_base1(lp_long, i, "lp_long", 1)), 
                        "assigning variable logmix");
            current_statement_begin__ = 35;
            stan::model::assign(log_ht, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        (((get_base1(lp_short, i, "lp_short", 1) + get_base1(lp_long, i, "lp_long", 1)) - get_base1(logmix, i, "logmix", 1)) + get_base1(lht0, i, "lht0", 1)), 
                        "assigning variable log_ht");
            current_statement_begin__ = 36;
            stan::model::assign(log_St, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        (-(get_base1(theta, i, "theta", 1)) * (get_base1(logmix, i, "logmix", 1) - get_base1(aux, i, "aux", 1))), 
                        "assigning variable log_St");
            current_statement_begin__ = 37;
            stan::model::assign(loglik, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        ((get_base1(status, i, "status", 1) * get_base1(log_ht, i, "log_ht", 1)) + get_base1(log_St, i, "log_St", 1)), 
                        "assigning variable loglik");
        }
        current_statement_begin__ = 39;
        return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct loglik1_pe_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T5__, typename T6__, typename T7__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T5__, T6__, T7__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& status,
               const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& Z,
               const T2__& tau,
               const Eigen::Matrix<T3__, Eigen::Dynamic, Eigen::Dynamic>& ttt,
               const std::vector<int>& idt,
               const Eigen::Matrix<T5__, Eigen::Dynamic, 1>& lambda,
               const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& psi,
               const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& phi, std::ostream* pstream__) const {
        return loglik1_pe(status, Z, tau, ttt, idt, lambda, psi, phi, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T6__, typename T7__, typename T8__, typename T9__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T6__, T7__, T8__, typename boost::math::tools::promote_args<T9__>::type>::type>::type, Eigen::Dynamic, 1>
loglik2_pe(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& status,
               const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& Z,
               const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& X,
               const T3__& tau,
               const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& ttt,
               const std::vector<int>& idt,
               const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& lambda,
               const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& psi,
               const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& phi,
               const Eigen::Matrix<T9__, Eigen::Dynamic, 1>& beta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T6__, T7__, T8__, typename boost::math::tools::promote_args<T9__>::type>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 49;
        int q(0);
        (void) q;  // dummy to suppress unused var warning
        stan::math::fill(q, std::numeric_limits<int>::min());
        stan::math::assign(q,cols(Z));
        current_statement_begin__ = 50;
        int p(0);
        (void) p;  // dummy to suppress unused var warning
        stan::math::fill(p, std::numeric_limits<int>::min());
        stan::math::assign(p,cols(X));
        current_statement_begin__ = 51;
        int n(0);
        (void) n;  // dummy to suppress unused var warning
        stan::math::fill(n, std::numeric_limits<int>::min());
        stan::math::assign(n,rows(Z));
        current_statement_begin__ = 53;
        validate_non_negative_index("lht0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lht0(n);
        stan::math::initialize(lht0, DUMMY_VAR__);
        stan::math::fill(lht0, DUMMY_VAR__);
        current_statement_begin__ = 54;
        validate_non_negative_index("Ft0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> Ft0(n);
        stan::math::initialize(Ft0, DUMMY_VAR__);
        stan::math::fill(Ft0, DUMMY_VAR__);
        current_statement_begin__ = 55;
        validate_non_negative_index("Ht0", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> Ht0(n);
        stan::math::initialize(Ht0, DUMMY_VAR__);
        stan::math::fill(Ht0, DUMMY_VAR__);
        current_statement_begin__ = 56;
        validate_non_negative_index("lp_short", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lp_short(n);
        stan::math::initialize(lp_short, DUMMY_VAR__);
        stan::math::fill(lp_short, DUMMY_VAR__);
        current_statement_begin__ = 57;
        validate_non_negative_index("lp_long", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lp_long(n);
        stan::math::initialize(lp_long, DUMMY_VAR__);
        stan::math::fill(lp_long, DUMMY_VAR__);
        current_statement_begin__ = 58;
        validate_non_negative_index("lp_const", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lp_const(n);
        stan::math::initialize(lp_const, DUMMY_VAR__);
        stan::math::fill(lp_const, DUMMY_VAR__);
        current_statement_begin__ = 59;
        validate_non_negative_index("log_ht", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_ht(n);
        stan::math::initialize(log_ht, DUMMY_VAR__);
        stan::math::fill(log_ht, DUMMY_VAR__);
        current_statement_begin__ = 60;
        validate_non_negative_index("log_St", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_St(n);
        stan::math::initialize(log_St, DUMMY_VAR__);
        stan::math::fill(log_St, DUMMY_VAR__);
        current_statement_begin__ = 61;
        validate_non_negative_index("ratio", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ratio(n);
        stan::math::initialize(ratio, DUMMY_VAR__);
        stan::math::fill(ratio, DUMMY_VAR__);
        current_statement_begin__ = 62;
        validate_non_negative_index("loglik", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> loglik(n);
        stan::math::initialize(loglik, DUMMY_VAR__);
        stan::math::fill(loglik, DUMMY_VAR__);
        current_statement_begin__ = 63;
        validate_non_negative_index("theta", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta(n);
        stan::math::initialize(theta, DUMMY_VAR__);
        stan::math::fill(theta, DUMMY_VAR__);
        current_statement_begin__ = 64;
        validate_non_negative_index("logmix", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> logmix(n);
        stan::math::initialize(logmix, DUMMY_VAR__);
        stan::math::fill(logmix, DUMMY_VAR__);
        current_statement_begin__ = 65;
        validate_non_negative_index("aux", "n", n);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> aux(n);
        stan::math::initialize(aux, DUMMY_VAR__);
        stan::math::fill(aux, DUMMY_VAR__);
        current_statement_begin__ = 67;
        stan::math::assign(lht0, stan::math::log(stan::model::rvalue(lambda, stan::model::cons_list(stan::model::index_multi(idt), stan::model::nil_index_list()), "lambda")));
        current_statement_begin__ = 68;
        stan::math::assign(Ht0, multiply(ttt, lambda));
        current_statement_begin__ = 69;
        stan::math::assign(Ft0, minus(stan::math::expm1(minus(Ht0))));
        current_statement_begin__ = 70;
        stan::math::assign(lp_short, multiply(Z, psi));
        current_statement_begin__ = 71;
        stan::math::assign(lp_long, multiply(Z, phi));
        current_statement_begin__ = 72;
        stan::math::assign(lp_const, multiply(X, beta));
        current_statement_begin__ = 73;
        stan::math::assign(theta, stan::math::exp(lp_long));
        current_statement_begin__ = 74;
        stan::math::assign(aux, subtract(lp_long, Ht0));
        current_statement_begin__ = 76;
        for (int i = 1; i <= n; ++i) {
            current_statement_begin__ = 77;
            stan::model::assign(logmix, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        log_mix(get_base1(Ft0, i, "Ft0", 1), get_base1(lp_short, i, "lp_short", 1), get_base1(lp_long, i, "lp_long", 1)), 
                        "assigning variable logmix");
            current_statement_begin__ = 78;
            stan::model::assign(log_ht, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        ((((get_base1(lp_short, i, "lp_short", 1) + get_base1(lp_long, i, "lp_long", 1)) + get_base1(lp_const, i, "lp_const", 1)) - get_base1(logmix, i, "logmix", 1)) + get_base1(lht0, i, "lht0", 1)), 
                        "assigning variable log_ht");
            current_statement_begin__ = 79;
            stan::model::assign(log_St, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        ((-(get_base1(theta, i, "theta", 1)) * stan::math::exp(get_base1(lp_const, i, "lp_const", 1))) * (get_base1(logmix, i, "logmix", 1) - get_base1(aux, i, "aux", 1))), 
                        "assigning variable log_St");
            current_statement_begin__ = 80;
            stan::model::assign(loglik, 
                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                        ((get_base1(status, i, "status", 1) * get_base1(log_ht, i, "log_ht", 1)) + get_base1(log_St, i, "log_St", 1)), 
                        "assigning variable loglik");
        }
        current_statement_begin__ = 83;
        return stan::math::promote_scalar<fun_return_scalar_t__>(loglik);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct loglik2_pe_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T6__, typename T7__, typename T8__, typename T9__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T6__, T7__, T8__, typename boost::math::tools::promote_args<T9__>::type>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& status,
               const Eigen::Matrix<T1__, Eigen::Dynamic, Eigen::Dynamic>& Z,
               const Eigen::Matrix<T2__, Eigen::Dynamic, Eigen::Dynamic>& X,
               const T3__& tau,
               const Eigen::Matrix<T4__, Eigen::Dynamic, Eigen::Dynamic>& ttt,
               const std::vector<int>& idt,
               const Eigen::Matrix<T6__, Eigen::Dynamic, 1>& lambda,
               const Eigen::Matrix<T7__, Eigen::Dynamic, 1>& psi,
               const Eigen::Matrix<T8__, Eigen::Dynamic, 1>& phi,
               const Eigen::Matrix<T9__, Eigen::Dynamic, 1>& beta, std::ostream* pstream__) const {
        return loglik2_pe(status, Z, X, tau, ttt, idt, lambda, psi, phi, beta, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_yppe2 : public prob_grad {
private:
        int n;
        int m;
        int q;
        int p;
        vector_d status;
        std::vector<int> idt;
        matrix_d Z;
        matrix_d X;
        double tau;
        matrix_d ttt;
        double h1_gamma;
        double h2_gamma;
        double mu_psi;
        double mu_phi;
        double mu_beta;
        double sigma_psi;
        double sigma_phi;
        double sigma_beta;
        int approach;
public:
    model_yppe2(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_yppe2(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_yppe2_namespace::model_yppe2";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 91;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 1);
            current_statement_begin__ = 92;
            context__.validate_dims("data initialization", "m", "int", context__.to_vec());
            m = int(0);
            vals_i__ = context__.vals_i("m");
            pos__ = 0;
            m = vals_i__[pos__++];
            check_greater_or_equal(function__, "m", m, 1);
            current_statement_begin__ = 93;
            context__.validate_dims("data initialization", "q", "int", context__.to_vec());
            q = int(0);
            vals_i__ = context__.vals_i("q");
            pos__ = 0;
            q = vals_i__[pos__++];
            check_greater_or_equal(function__, "q", q, 1);
            current_statement_begin__ = 94;
            context__.validate_dims("data initialization", "p", "int", context__.to_vec());
            p = int(0);
            vals_i__ = context__.vals_i("p");
            pos__ = 0;
            p = vals_i__[pos__++];
            check_greater_or_equal(function__, "p", p, 1);
            current_statement_begin__ = 95;
            validate_non_negative_index("status", "n", n);
            context__.validate_dims("data initialization", "status", "vector_d", context__.to_vec(n));
            status = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("status");
            pos__ = 0;
            size_t status_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < status_j_1_max__; ++j_1__) {
                status(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 96;
            validate_non_negative_index("idt", "n", n);
            context__.validate_dims("data initialization", "idt", "int", context__.to_vec(n));
            idt = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("idt");
            pos__ = 0;
            size_t idt_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < idt_k_0_max__; ++k_0__) {
                idt[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 97;
            validate_non_negative_index("Z", "n", n);
            validate_non_negative_index("Z", "q", q);
            context__.validate_dims("data initialization", "Z", "matrix_d", context__.to_vec(n,q));
            Z = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, q);
            vals_r__ = context__.vals_r("Z");
            pos__ = 0;
            size_t Z_j_2_max__ = q;
            size_t Z_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < Z_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Z_j_1_max__; ++j_1__) {
                    Z(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 98;
            validate_non_negative_index("X", "n", n);
            validate_non_negative_index("X", "p", p);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(n,p));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, p);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = p;
            size_t X_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 99;
            context__.validate_dims("data initialization", "tau", "double", context__.to_vec());
            tau = double(0);
            vals_r__ = context__.vals_r("tau");
            pos__ = 0;
            tau = vals_r__[pos__++];
            check_greater_or_equal(function__, "tau", tau, 0);
            current_statement_begin__ = 100;
            validate_non_negative_index("ttt", "n", n);
            validate_non_negative_index("ttt", "m", m);
            context__.validate_dims("data initialization", "ttt", "matrix_d", context__.to_vec(n,m));
            ttt = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n, m);
            vals_r__ = context__.vals_r("ttt");
            pos__ = 0;
            size_t ttt_j_2_max__ = m;
            size_t ttt_j_1_max__ = n;
            for (size_t j_2__ = 0; j_2__ < ttt_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < ttt_j_1_max__; ++j_1__) {
                    ttt(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 101;
            context__.validate_dims("data initialization", "h1_gamma", "double", context__.to_vec());
            h1_gamma = double(0);
            vals_r__ = context__.vals_r("h1_gamma");
            pos__ = 0;
            h1_gamma = vals_r__[pos__++];
            current_statement_begin__ = 102;
            context__.validate_dims("data initialization", "h2_gamma", "double", context__.to_vec());
            h2_gamma = double(0);
            vals_r__ = context__.vals_r("h2_gamma");
            pos__ = 0;
            h2_gamma = vals_r__[pos__++];
            current_statement_begin__ = 103;
            context__.validate_dims("data initialization", "mu_psi", "double", context__.to_vec());
            mu_psi = double(0);
            vals_r__ = context__.vals_r("mu_psi");
            pos__ = 0;
            mu_psi = vals_r__[pos__++];
            current_statement_begin__ = 104;
            context__.validate_dims("data initialization", "mu_phi", "double", context__.to_vec());
            mu_phi = double(0);
            vals_r__ = context__.vals_r("mu_phi");
            pos__ = 0;
            mu_phi = vals_r__[pos__++];
            current_statement_begin__ = 105;
            context__.validate_dims("data initialization", "mu_beta", "double", context__.to_vec());
            mu_beta = double(0);
            vals_r__ = context__.vals_r("mu_beta");
            pos__ = 0;
            mu_beta = vals_r__[pos__++];
            current_statement_begin__ = 106;
            context__.validate_dims("data initialization", "sigma_psi", "double", context__.to_vec());
            sigma_psi = double(0);
            vals_r__ = context__.vals_r("sigma_psi");
            pos__ = 0;
            sigma_psi = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_psi", sigma_psi, 0);
            current_statement_begin__ = 107;
            context__.validate_dims("data initialization", "sigma_phi", "double", context__.to_vec());
            sigma_phi = double(0);
            vals_r__ = context__.vals_r("sigma_phi");
            pos__ = 0;
            sigma_phi = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_phi", sigma_phi, 0);
            current_statement_begin__ = 108;
            context__.validate_dims("data initialization", "sigma_beta", "double", context__.to_vec());
            sigma_beta = double(0);
            vals_r__ = context__.vals_r("sigma_beta");
            pos__ = 0;
            sigma_beta = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_beta", sigma_beta, 0);
            current_statement_begin__ = 109;
            context__.validate_dims("data initialization", "approach", "int", context__.to_vec());
            approach = int(0);
            vals_i__ = context__.vals_i("approach");
            pos__ = 0;
            approach = vals_i__[pos__++];
            check_greater_or_equal(function__, "approach", approach, 0);
            check_less_or_equal(function__, "approach", approach, 1);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 114;
            validate_non_negative_index("psi", "q", q);
            num_params_r__ += q;
            current_statement_begin__ = 115;
            validate_non_negative_index("phi", "q", q);
            num_params_r__ += q;
            current_statement_begin__ = 116;
            validate_non_negative_index("beta", "p", p);
            num_params_r__ += p;
            current_statement_begin__ = 117;
            validate_non_negative_index("gamma", "m", m);
            num_params_r__ += m;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_yppe2() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 114;
        if (!(context__.contains_r("psi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable psi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("psi");
        pos__ = 0U;
        validate_non_negative_index("psi", "q", q);
        context__.validate_dims("parameter initialization", "psi", "vector_d", context__.to_vec(q));
        Eigen::Matrix<double, Eigen::Dynamic, 1> psi(q);
        size_t psi_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            psi(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(psi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable psi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 115;
        if (!(context__.contains_r("phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        validate_non_negative_index("phi", "q", q);
        context__.validate_dims("parameter initialization", "phi", "vector_d", context__.to_vec(q));
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi(q);
        size_t phi_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
            phi(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(phi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 116;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "p", p);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(p));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(p);
        size_t beta_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 117;
        if (!(context__.contains_r("gamma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        validate_non_negative_index("gamma", "m", m);
        context__.validate_dims("parameter initialization", "gamma", "vector_d", context__.to_vec(m));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma(m);
        size_t gamma_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            gamma(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, gamma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 114;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> psi;
            (void) psi;  // dummy to suppress unused var warning
            if (jacobian__)
                psi = in__.vector_constrain(q, lp__);
            else
                psi = in__.vector_constrain(q);
            current_statement_begin__ = 115;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi;
            (void) phi;  // dummy to suppress unused var warning
            if (jacobian__)
                phi = in__.vector_constrain(q, lp__);
            else
                phi = in__.vector_constrain(q);
            current_statement_begin__ = 116;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(p, lp__);
            else
                beta = in__.vector_constrain(p);
            current_statement_begin__ = 117;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma;
            (void) gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma = in__.vector_lb_constrain(0, m, lp__);
            else
                gamma = in__.vector_lb_constrain(0, m);
            // transformed parameters
            current_statement_begin__ = 122;
            validate_non_negative_index("loglik", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> loglik(n);
            stan::math::initialize(loglik, DUMMY_VAR__);
            stan::math::fill(loglik, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 123;
            stan::math::assign(loglik, loglik2_pe(status, Z, X, tau, ttt, idt, gamma, psi, phi, beta, pstream__));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 122;
            size_t loglik_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < loglik_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(loglik(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: loglik" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable loglik: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 128;
            lp_accum__.add(loglik);
            current_statement_begin__ = 129;
            if (as_bool(logical_eq(approach, 1))) {
                current_statement_begin__ = 130;
                lp_accum__.add(lognormal_log<propto__>(gamma, h1_gamma, h2_gamma));
                current_statement_begin__ = 131;
                lp_accum__.add(normal_log<propto__>(psi, mu_psi, sigma_psi));
                current_statement_begin__ = 132;
                lp_accum__.add(normal_log<propto__>(phi, mu_phi, sigma_phi));
                current_statement_begin__ = 133;
                lp_accum__.add(normal_log<propto__>(beta, mu_beta, sigma_beta));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("psi");
        names__.push_back("phi");
        names__.push_back("beta");
        names__.push_back("gamma");
        names__.push_back("loglik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(p);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(m);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_yppe2_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> psi = in__.vector_constrain(q);
        size_t psi_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            vars__.push_back(psi(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi = in__.vector_constrain(q);
        size_t phi_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
            vars__.push_back(phi(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(p);
        size_t beta_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma = in__.vector_lb_constrain(0, m);
        size_t gamma_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            vars__.push_back(gamma(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 122;
            validate_non_negative_index("loglik", "n", n);
            Eigen::Matrix<double, Eigen::Dynamic, 1> loglik(n);
            stan::math::initialize(loglik, DUMMY_VAR__);
            stan::math::fill(loglik, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 123;
            stan::math::assign(loglik, loglik2_pe(status, Z, X, tau, ttt, idt, gamma, psi, phi, beta, pstream__));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t loglik_j_1_max__ = n;
                for (size_t j_1__ = 0; j_1__ < loglik_j_1_max__; ++j_1__) {
                    vars__.push_back(loglik(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    static std::string model_name() {
        return "model_yppe2";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t psi_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t loglik_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < loglik_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "loglik" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t psi_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < psi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "psi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_j_1_max__ = m;
        for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t loglik_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < loglik_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "loglik" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_yppe2_namespace::model_yppe2 stan_model;
#endif
