% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VLtransferEntropy.R
\name{VLTransferEntropy}
\alias{VLTransferEntropy}
\title{VLTransferEntropy}
\usage{
VLTransferEntropy(
  Y,
  X,
  maxLag,
  nboot = 0,
  lx = 1,
  ly = 1,
  VLflag = TRUE,
  autoLagflag = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{Y}{is a numerical time series of effect}

\item{X}{is a numerical time series of cause}

\item{maxLag}{is a maximum possible time delay. The default is 0.2*length(Y).}

\item{nboot}{is a number of times of bootstrapping for RTransferEntropy::transfer_entropy() function.}

\item{lx, ly}{are lag parameters of RTransferEntropy::transfer_entropy().}

\item{VLflag}{is a flag of Transfer Entropy choice: either \code{VLflag=TRUE} for VL-Transfer Entropy or \code{VLflag=FALSE} for Transfer Entropy.}

\item{autoLagflag}{is a flag for enabling the automatic lag inference function. The default is true.
If it is set to be true, then maxLag is set automatically using cross-correlation.
Otherwise, if it is set to be false, then the function takes the maxLag value to infer Granger causality.}

\item{alpha}{is a significant-level threshold for TE bootstrapping by Dimpfl and Peter (2013).}
}
\value{
This function returns of  whether \code{X} (VL-)Transfer-Entropy-causes \code{Y}.


\item{TEratio}{ is a Transfer Entropy ratio. If it is greater than one , then \code{X} causes \code{Y}. }
\item{res}{ is an object of output from RTransferEntropy::transfer_entropy() }
\item{follOut}{ is a list of variables from function \code{followingRelation}. }
\item{XgCsY_trns}{The flag is true if \code{X} (VL-)Transfer-Entropy-causes \code{Y} using Transfer Entropy ratio ratio where \code{TEratio >1}
if \code{X} causes \code{Y}. Additionally, if \code{nboot>1}, the flag is true only when \code{pval<=alpha}. }
\item{pval}{ It is a p-value for TE bootstrapping by Dimpfl and Peter (2013).}
}
\description{
VLTransferEntropy is a Variable-lag Transfer Entropy function. It tests whether \code{X} VL-Transfer-Entropy-causes \code{Y}.
}
\examples{
# Generate simulation data
TS <- SimpleSimulationVLtimeseries()
# Run the function
out<-VLTransferEntropy(Y=TS$Y,X=TS$X)


}
