% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routines.R
\name{BICandbootstrapsim}
\alias{BICandbootstrapsim}
\title{Comparison of BIC approach and BCa approach}
\usage{
BICandbootstrapsim(zdat, nsims = 100, nboot = 100, pthresh = 0.02,
  iseed = 1234, alpha = c(0.025, 0.05, 0.1, 0.16, 0.5, 0.84, 0.9, 0.95,
  0.975), noninformativelist = F, verbose = F, ...)
}
\arguments{
\item{zdat}{Data matrix with \eqn{t+1} columns. The first \eqn{t} columns, each corresponding to a particular list,
are 0s and 1s defining the capture histories
observed. The last column is the count of cases with that particular capture history.
List names A, B, ... are constructed if not supplied. Where a capture history is not explicitly listed,
it is assumed that it has zero count.}

\item{nsims}{Number of simulations to be carried out.}

\item{nboot}{Number of bootstrap replications for each simulation}

\item{pthresh}{p-value threshold used in \code{\link{estimatepopulation.0}}.}

\item{iseed}{seed for initialization.}

\item{alpha}{bootstrap quantiles of interests.}

\item{noninformativelist}{if \code{noninformativelist=TRUE} then each generated data set in the simulation study (including all bootstrap replications)
will be passed to \code{\link{removenoninformativelists}}.}

\item{verbose}{If \code{verbose=FALSE}, then the progress of the simulation will not show.
If \code{verbose=TRUE}, then the progress of the simulation will be shown.}

\item{...}{other arguments.}
}
\value{
A list with components as below

\code{popest} Total population point estimate from the original data using
\code{estimatepopulation.0} with default threshold.

\code{BICmodels} The best model chosen by the BIC at each simulation.

\code{BICvals} Point estimates of the total population and standard error of the best model chosen by the BIC at each simulation.

\code{simreps} Counts associated to each capture history at each simulation.

\code{modelmat} A full capture history matrix excluding the row corresponding to the dark figure.

\code{popestsim} Total population estimate given by the BCa method in each simulation.

\code{BCaquantiles} bootstrap confidence intervals given by the BCa method.

\code{BICconf} confidence interval given by the BIC method.
}
\description{
This routine carries out the simulation study as detailed in Section 3.4 of Chan, Silverman and Vincent (2019).
 If the original data set has low counts, so that there is a possibility of a simulated data set containing empty lists, then it
 may be advisable to use the option \code{noninformativelist=TRUE}.
}
\references{
Chan, L., Silverman, B. W., and Vincent, K. (2019).
 Multiple Systems Estimation for Sparse Capture Data: Inferential Challenges when there are Non-Overlapping Lists.
  Available from \url{https://arxiv.org/abs/1902.05156}.

DiCiccio, T. J. and Efron, B. (1996). Bootstrap Confidence Intervals. \emph{Statistical Science}, \strong{40(3)}, 189-228.

Rivest, L-P. and Baillargeon, S. (2014) Rcapture. CRAN package. Available from Available from \url{https://CRAN.R-project.org/package=Rcapture}.
}
