% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLDataFrame-methods.R
\name{SQLDataFrame-methods}
\alias{SQLDataFrame-methods}
\alias{head}
\alias{head,SQLDataFrame-method}
\alias{tail,SQLDataFrame-method}
\alias{tail}
\alias{nrow,SQLDataFrame-method}
\alias{nrow}
\alias{dim}
\alias{dim,SQLDataFrame-method}
\alias{names,SQLDataFrame-method}
\alias{names}
\alias{names<-,SQLDataFrame-method}
\alias{names<-}
\alias{names<-,SQLDataFrame}
\alias{colnames,SQLDataFrame-method}
\alias{colnames}
\alias{colnames<-,SQLDataFrame-method}
\alias{colnames<-}
\alias{rownames,SQLDataFrame-method}
\alias{rownames}
\alias{rownames<-,SQLDataFrame-method}
\alias{rownames<-}
\alias{length,SQLDataFrame-method}
\alias{length}
\alias{dimnames,SQLDataFrame-method}
\alias{dimnames}
\alias{dimnames<-,SQLDataFrame,ANY-method}
\alias{dimnames<-}
\alias{dimnames<-,SQLDataFrame-method}
\alias{[,SQLDataFrame,ANY,ANY,ANY-method}
\alias{[,SQLDataFrame,ANY-method}
\alias{[,SQLDataFrame,SQLDataFrame,ANY,ANY-method}
\alias{[,SQLDataFrame,SQLDataFrame-method}
\alias{[,SQLDataFrame,list,ANY,ANY-method}
\alias{[,SQLDataFrame,list-method}
\alias{[[,SQLDataFrame-method}
\alias{$,SQLDataFrame-method}
\alias{select.SQLDataFrame}
\alias{select}
\alias{select,SQLDataFrame-methods}
\alias{filter.SQLDataFrame}
\alias{filter}
\alias{filter,SQLDataFrame-method}
\alias{mutate.SQLDataFrame}
\alias{mutate}
\alias{mutate,SQLDataFrame-methods}
\alias{dbcon}
\title{SQLDataFrame methods}
\usage{
\S4method{head}{SQLDataFrame}(x, n = 6L)

\S4method{tail}{SQLDataFrame}(x, n = 6L)

\S4method{nrow}{SQLDataFrame}(x)

\S4method{names}{SQLDataFrame}(x)

\S4method{names}{SQLDataFrame}(x) <- value

\S4method{colnames}{SQLDataFrame}(x, do.NULL = TRUE, prefix = "col")

\S4method{colnames}{SQLDataFrame}(x) <- value

\S4method{rownames}{SQLDataFrame}(x, do.NULL = TRUE, prefix = "row")

\S4method{rownames}{SQLDataFrame}(x) <- value

\S4method{length}{SQLDataFrame}(x)

\S4method{dimnames}{SQLDataFrame}(x)

\S4method{dimnames}{SQLDataFrame,ANY}(x) <- value

\S4method{[}{SQLDataFrame,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{SQLDataFrame,SQLDataFrame,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{SQLDataFrame,list,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[[}{SQLDataFrame}(x, i, j, ...)

\S4method{$}{SQLDataFrame}(x, name)

\method{select}{SQLDataFrame}(.data, ...)

\method{filter}{SQLDataFrame}(.data, ...)

\method{mutate}{SQLDataFrame}(.data, ...)

dbcon(x)
}
\arguments{
\item{x}{An \code{SQLDataFrame} object.}

\item{n}{Number of rows.}

\item{value}{a valid value for component of \code{rownames},
\code{colnames}, \code{dimnames}. NOTE, it doesn't make any
change when applied to these replacement methods for
\code{SQLDataFrame}.}

\item{do.NULL}{logical. If ‘FALSE’ and names are ‘NULL’, names are
created. See \code{base::colnames} for details.}

\item{prefix}{for created names when \code{do.NULL} is FALSE.}

\item{i}{Row subscript. Could be numeric / character / logical
values, a named list of key values, and \code{SQLDataFrame},
\code{data.frame}, \code{tibble} objects.}

\item{j}{Column subscript.}

\item{...}{additional arguments to be passed.
\itemize{
\item \code{select()}: One or more unquoted expressions separated
    by commas. You can treat variable names like they are
    positions, so you can use expressions like ‘x:y’ to select
    ranges of variables. Positive values select variables; negative
    values drop variables. See \code{?dplyr::select} for more
    details.
\item \code{filter()}: Logical predicates defined in terms of the
    variables in ‘.data’. Multiple conditions are combined with
    ‘&’. Only rows where the condition evaluates to ‘TRUE’ are
    kept. See \code{?dplyr::filter} for more details.
\item \code{mutate()}: Name-value pairs of expressions, each with
    length 1 or the same length as the number of rows in the group
    (if using ‘group_by()’) or in the entire input (if not using
    groups). The name of each argument will be the name of a new
    variable, and the value will be its corresponding value.
     New variables
    overwrite existing variables of the same name. NOTE that the new
    value could only be of length 1 or the operation of existing columns.
    If a new vector of values are given, error will return. This is due
    to the internal method of 'mutate.tbl_lazy' not being able to take
    new arbitrary values. 
}}

\item{drop}{Whether to drop with reduced dimension. Default is
TRUE.}

\item{name}{column name to be extracted by \code{$}.}

\item{.data}{A \code{SQLDataFrame} object.}
}
\value{
\code{head, tail}: An \code{SQLDataFrame} object with
    certain rows.

\code{dim}: interger vector showing number of rows and cols.

\code{nrow}: An integer showing number of rows.

\code{names}: A character vector.

\code{names<-}: No change.

\code{colnames}: A character vector.

\code{colnames<-}: No change.

\code{rownames}: NULL or vector if "do.NULL = FALSE".

\code{rownames<-}: No change.

\code{length}: An integer same as \code{ncol}.

\code{dimnames}: A list.

\code{dimnames<-}: No change.

\code{[i, j]}: A \code{SQLDataFrame} object or vector with
    realized column values (with single column subsetting and
    default \code{drop=TRUE}. )

\code{select}: always returns a SQLDataFrame object no
    matter how may columns are selected. If only key column(s)
    is(are) selected, it will return a \code{SQLDataFrame} object
    with 0 col (only key columns are shown).

\code{filter}: A \code{SQLDataFrame} object with subset
    rows of the input SQLDataFrame object matching conditions.

\code{mutate}: A SQLDataFrame object.
}
\description{
\code{head, tail}: Retrieve the first / last n rows of
    the \code{SQLDataFrame} object. See \code{?S4Vectors::head} for
    more details.

\code{dim, nrow, ncol, length, dimnames, rownames,
    colnames, names}: Retrieve the dimension and dimension names of
    SQLDataFrame object.

\code{[i, j]} supports subsetting by \code{i} (for
    row) and \code{j} (for column) and respects ‘drop=FALSE’.

Use \code{select()} function to select certain
    columns.

Use \code{filter()} to choose rows/cases where
    conditions are true.

\code{mutate()} adds new columns and preserves
    existing ones; It also preserves the number of rows of the
    input. New variables overwrite existing variables of the same
    name.

\code{dbcon} returns the connection of a
    SQLDataFrame object.
}
\examples{

##################
## basic methods
##################

test.db <- system.file("extdata/test.db", package = "SQLDataFrame")
conn <- DBI::dbConnect(DBI::dbDriver("SQLite"), dbname = test.db)
obj <- SQLDataFrame(conn = conn, dbtable = "state", dbkey = "state")
dim(obj)
nrow(obj)
ncol(obj)
dimnames(obj)
rownames(obj)
names(obj)
colnames(obj)
length(obj)

obj1 <- SQLDataFrame(conn = conn, dbtable = "state",
                     dbkey = c("region", "population"))
###############
## subsetting
###############

obj[1]
obj["region"]
obj$region
obj[]
obj[,]
obj[NULL, ]
obj[, NULL]

## by numeric / logical / character vectors
obj[1:5, 2:3]
obj[c(TRUE, FALSE), c(TRUE, FALSE)]
obj[c("Alabama", "South Dakota"), ]
obj1[c("South:3615.0", "West:3559.0"), ]
### Remeber to add `.0` trailing for numeric values. If not sure,
### check `ROWNAMES()`.

## by SQLDataFrame
obj_sub <- obj[sample(10), ]
obj[obj_sub, ]

## by a named list of key column values (or equivalently data.frame /
## tibble)
obj[data.frame(state = c("Colorado", "Arizona")), ]
obj[tibble::tibble(state = c("Colorado", "Arizona")), ]
obj[list(state = c("Colorado", "Arizona")), ]
obj1[list(region = c("South", "West"),
          population = c("3615.0", "365.0")), ]
### remember to add the '.0' trailing for numeric values. If not sure,
### check `ROWNAMES()`.

## Subsetting with key columns

obj["state"] ## list style subsetting, return a SQLDataFrame object with col = 0.
obj[c("state", "division")]  ## list style subsetting, return a SQLDataFrame object with col = 1.
obj[, "state"] ## realize specific key column value.
obj[, c("state", "division")] ## col = 1, but do not realize.


###################
## select, filter, mutate
###################
library(dplyr)
obj \%>\% select(division)  ## equivalent to obj["division"], or obj[, "division", drop = FALSE]
obj \%>\% select(region:size)

obj \%>\% filter(region == "West" & size == "medium")
obj1 \%>\% filter(region == "West" & population > 10000)

obj \%>\% mutate(p1 = population / 10)
obj \%>\% mutate(s1 = size)

obj \%>\% select(region, size, population) \%>\% 
    filter(population > 10000) \%>\% 
    mutate(pK = population/1000)
obj1 \%>\% select(region, size, population) \%>\% 
    filter(population > 10000) \%>\% 
    mutate(pK = population/1000)  

###################
## connection info
###################

dbcon(obj)
}
