logitCrossVal <-
function(data, index, nfold = 10, nlam = 20, lambdas = lambdas, thresh = 0.0001, maxit = 10000, alpha = 0.95, min.frac = 0.05, gamma = 0.8, verbose = TRUE, step = 1, reset = 10, foldid = NA){
  
  X <- data$x
  y <- data$y
  n <- nrow(X)
  p <- ncol(X)

   ## Setting up group lasso stuff ##
  
  ord <- order(index)
  index <- index[ord]
  X <- X[,ord]
  unOrd <- match(1:length(ord),ord)

  ## Coming up with other C++ info ##

  groups <- unique(index)
  num.groups <- length(groups)
  range.group.ind <- rep(0,(num.groups+1))
  for(i in 1:num.groups){
    range.group.ind[i] <- min(which(index == groups[i])) - 1
  }
  range.group.ind[num.groups+1] <- ncol(X)

  group.length <- diff(range.group.ind)
  beta.naught <- rep(0,ncol(X))
  beta <- beta.naught

  ## Done with group stuff ##

  ## finding the path

  MainSol <- oneDimLogit(data, index, thresh = thresh, inner.iter = maxit, outer.iter = maxit, outer.thresh = thresh, min.frac = min.frac, nlam = nlam, lambdas = lambdas, gamma = gamma, step = step, reset = reset, alpha = alpha)


  lambdas <- MainSol$lambdas

  lldiff <- rep(0, nlam)
  lldiffFold <- matrix(0, nrow = nlam, ncol = nfold)
  prevals <- matrix(0, nrow = nrow(data$x), ncol = nlam)
  
  for(i in 1:nfold){
    ind.out <- which(foldid == i)
    ind.in <- which(foldid != i)
    new.data <- list(x = data$x[ind.in,], y = data$y[ind.in])

    new.sol <- oneDimLogit(new.data, index, thresh = thresh, inner.iter = maxit, lambdas = lambdas, outer.iter = maxit, outer.thresh = thresh, min.frac = min.frac, nlam = nlam, gamma = gamma, step = step, reset = reset, alpha = alpha)

    for(k in 1:nlam){

	    our.eta <- X[ind.out,] %*% new.sol$beta[ord,k] + new.sol$intercepts[k]
	    prob <- exp(our.eta)/(1+exp(our.eta))
      
	    lldiffFold[k,i] <- - sum(y[ind.out] * log(prob) + (1 - y[ind.out]) * log(1 - prob))
      
      prevals[ind.out,k] <- prob
    }
    if(verbose == TRUE){
      write(paste("*** NFOLD ", i, "***"),"")
    }
  }
  lldiff = rowSums(lldiffFold)
  lldiffSD <- apply(lldiffFold,1,sd) * sqrt(nfold)
  obj <- list(lambdas = lambdas, lldiff = lldiff,llSD = lldiffSD, fit = MainSol, prevals = prevals)
  class(obj)="cv.SGL"
return(obj)
}
