// Generated by rstantools.  Do not edit by hand.

/*
    rstanarm is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanarm is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanarm.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_ets_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'ets', line 20, column 2 to column 21)",
                                                      " (in 'ets', line 20, column 22 to column 37)",
                                                      " (in 'ets', line 21, column 1 to column 36)",
                                                      " (in 'ets', line 22, column 1 to column 21)",
                                                      " (in 'ets', line 23, column 1 to column 29)",
                                                      " (in 'ets', line 24, column 1 to column 28)",
                                                      " (in 'ets', line 25, column 1 to column 29)",
                                                      " (in 'ets', line 26, column 1 to column 12)",
                                                      " (in 'ets', line 27, column 1 to column 37)",
                                                      " (in 'ets', line 28, column 1 to column 16)",
                                                      " (in 'ets', line 29, column 1 to column 36)",
                                                      " (in 'ets', line 30, column 1 to column 38)",
                                                      " (in 'ets', line 31, column 1 to column 31)",
                                                      " (in 'ets', line 32, column 1 to column 30)",
                                                      " (in 'ets', line 35, column 1 to column 56)",
                                                      " (in 'ets', line 36, column 1 to column 22)",
                                                      " (in 'ets', line 37, column 1 to column 13)",
                                                      " (in 'ets', line 38, column 1 to column 13)",
                                                      " (in 'ets', line 39, column 1 to column 27)",
                                                      " (in 'ets', line 40, column 1 to column 38)",
                                                      " (in 'ets', line 45, column 2 to column 23)",
                                                      " (in 'ets', line 43, column 2 to column 33)",
                                                      " (in 'ets', line 42, column 1 to line 45, column 23)",
                                                      " (in 'ets', line 50, column 3 to column 28)",
                                                      " (in 'ets', line 48, column 3 to column 40)",
                                                      " (in 'ets', line 47, column 1 to line 50, column 28)",
                                                      " (in 'ets', line 52, column 1 to column 20)",
                                                      " (in 'ets', line 53, column 1 to column 14)",
                                                      " (in 'ets', line 54, column 1 to column 69)",
                                                      " (in 'ets', line 55, column 1 to column 18)",
                                                      " (in 'ets', line 58, column 2 to column 51)",
                                                      " (in 'ets', line 59, column 2 to column 47)",
                                                      " (in 'ets', line 60, column 2 to column 59)",
                                                      " (in 'ets', line 64, column 3 to column 26)",
                                                      " (in 'ets', line 62, column 3 to column 97)",
                                                      " (in 'ets', line 61, column 2 to line 64, column 26)",
                                                      " (in 'ets', line 57, column 16 to line 65, column 2)",
                                                      " (in 'ets', line 57, column 1 to line 65, column 2)",
                                                      " (in 'ets', line 68, column 31 to column 32)",
                                                      " (in 'ets', line 68, column 1 to column 35)",
                                                      " (in 'ets', line 69, column 45 to column 54)",
                                                      " (in 'ets', line 69, column 1 to column 57)",
                                                      " (in 'ets', line 70, column 1 to column 33)",
                                                      " (in 'ets', line 71, column 1 to column 54)",
                                                      " (in 'ets', line 76, column 34 to column 35)",
                                                      " (in 'ets', line 76, column 4 to column 38)",
                                                      " (in 'ets', line 73, column 1 to line 76, column 38)",
                                                      " (in 'ets', line 74, column 46 to column 47)",
                                                      " (in 'ets', line 74, column 2 to column 50)",
                                                      " (in 'ets', line 82, column 2 to column 25)",
                                                      " (in 'ets', line 83, column 2 to column 27)",
                                                      " (in 'ets', line 81, column 8 to line 84, column 2)",
                                                      " (in 'ets', line 79, column 2 to column 37)",
                                                      " (in 'ets', line 80, column 2 to column 38)",
                                                      " (in 'ets', line 78, column 21 to line 81, column 2)",
                                                      " (in 'ets', line 78, column 1 to line 84, column 2)",
                                                      " (in 'ets', line 85, column 2 to column 30)",
                                                      " (in 'ets', line 91, column 4 to column 42)",
                                                      " (in 'ets', line 89, column 4 to column 42)",
                                                      " (in 'ets', line 88, column 3 to line 91, column 42)",
                                                      " (in 'ets', line 87, column 16 to line 92, column 2)",
                                                      " (in 'ets', line 87, column 1 to line 92, column 2)",
                                                      " (in 'ets', line 3, column 1 to column 25)",
                                                      " (in 'ets', line 4, column 1 to column 20)",
                                                      " (in 'ets', line 4, column 22 to column 41)",
                                                      " (in 'ets', line 5, column 1 to column 25)",
                                                      " (in 'ets', line 6, column 1 to column 22)",
                                                      " (in 'ets', line 6, column 23 to column 44)",
                                                      " (in 'ets', line 7, column 1 to column 16)",
                                                      " (in 'ets', line 8, column 17 to column 18)",
                                                      " (in 'ets', line 8, column 1 to column 22)",
                                                      " (in 'ets', line 9, column 1 to column 31)",
                                                      " (in 'ets', line 9, column 32 to column 61)",
                                                      " (in 'ets', line 10, column 1 to column 37)",
                                                      " (in 'ets', line 11, column 1 to column 41)",
                                                      " (in 'ets', line 12, column 1 to column 16)",
                                                      " (in 'ets', line 13, column 8 to column 9)",
                                                      " (in 'ets', line 13, column 11 to column 12)",
                                                      " (in 'ets', line 13, column 1 to column 19)",
                                                      " (in 'ets', line 14, column 17 to column 18)",
                                                      " (in 'ets', line 14, column 1 to column 34)",
                                                      " (in 'ets', line 17, column 1 to column 51)",
                                                      " (in 'ets', line 20, column 9 to column 10)",
                                                      " (in 'ets', line 36, column 17 to column 18)",
                                                      " (in 'ets', line 37, column 8 to column 9)",
                                                      " (in 'ets', line 38, column 8 to column 9)",
                                                      " (in 'ets', line 39, column 17 to column 18)",
                                                      " (in 'ets', line 40, column 17 to column 18)"};
#include <stan_meta_header.hpp>
class model_ets final : public model_base_crtp<model_ets> {
private:
  double CAUCHY_SD;
  double MIN_POW_TREND;
  double MAX_POW_TREND;
  double MIN_SIGMA;
  double MIN_NU;
  double MAX_NU;
  int N;
  Eigen::Matrix<double, -1, 1> y;
  double POW_TREND_ALPHA;
  double POW_TREND_BETA;
  int USE_REGRESSION;
  int USE_SMOOTHED_ERROR;
  int J;
  Eigen::Matrix<double, -1, -1> xreg;
  Eigen::Matrix<double, -1, 1> REG_CAUCHY_SD;
  double reg0CauchySd;
 
public:
  ~model_ets() { }
  
  inline std::string model_name() const final { return "model_ets"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_ets(stan::io::var_context& context__, unsigned int random_seed__ = 0,
            std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_ets_namespace::model_ets";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 63;
      context__.validate_dims("data initialization","CAUCHY_SD","double",
          context__.to_vec());
      CAUCHY_SD = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 63;
      CAUCHY_SD = context__.vals_r("CAUCHY_SD")[(1 - 1)];
      current_statement__ = 63;
      current_statement__ = 63;
      check_greater_or_equal(function__, "CAUCHY_SD", CAUCHY_SD, 0);
      current_statement__ = 64;
      context__.validate_dims("data initialization","MIN_POW_TREND","double",
          context__.to_vec());
      MIN_POW_TREND = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 64;
      MIN_POW_TREND = context__.vals_r("MIN_POW_TREND")[(1 - 1)];
      current_statement__ = 65;
      context__.validate_dims("data initialization","MAX_POW_TREND","double",
          context__.to_vec());
      MAX_POW_TREND = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 65;
      MAX_POW_TREND = context__.vals_r("MAX_POW_TREND")[(1 - 1)];
      current_statement__ = 66;
      context__.validate_dims("data initialization","MIN_SIGMA","double",
          context__.to_vec());
      MIN_SIGMA = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 66;
      MIN_SIGMA = context__.vals_r("MIN_SIGMA")[(1 - 1)];
      current_statement__ = 66;
      current_statement__ = 66;
      check_greater_or_equal(function__, "MIN_SIGMA", MIN_SIGMA, 0);
      current_statement__ = 67;
      context__.validate_dims("data initialization","MIN_NU","double",
          context__.to_vec());
      MIN_NU = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 67;
      MIN_NU = context__.vals_r("MIN_NU")[(1 - 1)];
      current_statement__ = 67;
      current_statement__ = 67;
      check_greater_or_equal(function__, "MIN_NU", MIN_NU, 1);
      current_statement__ = 68;
      context__.validate_dims("data initialization","MAX_NU","double",
          context__.to_vec());
      MAX_NU = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 68;
      MAX_NU = context__.vals_r("MAX_NU")[(1 - 1)];
      current_statement__ = 68;
      current_statement__ = 68;
      check_greater_or_equal(function__, "MAX_NU", MAX_NU, 1);
      current_statement__ = 69;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 69;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 69;
      current_statement__ = 69;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 70;
      validate_non_negative_index("y", "N", N);
      current_statement__ = 71;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(N));
      y = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 71;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 71;
        pos__ = 1;
        current_statement__ = 71;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 71;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 71;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 71;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 71;
        current_statement__ = 71;
        check_greater_or_equal(function__, "y[sym1__]", y[(sym1__ - 1)], 0);}
      current_statement__ = 72;
      context__.validate_dims("data initialization","POW_TREND_ALPHA",
          "double",context__.to_vec());
      POW_TREND_ALPHA = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 72;
      POW_TREND_ALPHA = context__.vals_r("POW_TREND_ALPHA")[(1 - 1)];
      current_statement__ = 72;
      current_statement__ = 72;
      check_greater_or_equal(function__, "POW_TREND_ALPHA", POW_TREND_ALPHA,
                             0);
      current_statement__ = 73;
      context__.validate_dims("data initialization","POW_TREND_BETA",
          "double",context__.to_vec());
      POW_TREND_BETA = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 73;
      POW_TREND_BETA = context__.vals_r("POW_TREND_BETA")[(1 - 1)];
      current_statement__ = 73;
      current_statement__ = 73;
      check_greater_or_equal(function__, "POW_TREND_BETA", POW_TREND_BETA, 0);
      current_statement__ = 74;
      context__.validate_dims("data initialization","USE_REGRESSION","int",
          context__.to_vec());
      USE_REGRESSION = std::numeric_limits<int>::min();
      
      current_statement__ = 74;
      USE_REGRESSION = context__.vals_i("USE_REGRESSION")[(1 - 1)];
      current_statement__ = 74;
      current_statement__ = 74;
      check_greater_or_equal(function__, "USE_REGRESSION", USE_REGRESSION, 0);
      current_statement__ = 74;
      current_statement__ = 74;
      check_less_or_equal(function__, "USE_REGRESSION", USE_REGRESSION, 1);
      current_statement__ = 75;
      context__.validate_dims("data initialization","USE_SMOOTHED_ERROR",
          "int",context__.to_vec());
      USE_SMOOTHED_ERROR = std::numeric_limits<int>::min();
      
      current_statement__ = 75;
      USE_SMOOTHED_ERROR = context__.vals_i("USE_SMOOTHED_ERROR")[(1 - 1)];
      current_statement__ = 75;
      current_statement__ = 75;
      check_greater_or_equal(function__, "USE_SMOOTHED_ERROR",
                             USE_SMOOTHED_ERROR, 0);
      current_statement__ = 75;
      current_statement__ = 75;
      check_less_or_equal(function__, "USE_SMOOTHED_ERROR",
                          USE_SMOOTHED_ERROR, 1);
      current_statement__ = 76;
      context__.validate_dims("data initialization","J","int",
          context__.to_vec());
      J = std::numeric_limits<int>::min();
      
      current_statement__ = 76;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 76;
      current_statement__ = 76;
      check_greater_or_equal(function__, "J", J, 1);
      current_statement__ = 77;
      validate_non_negative_index("xreg", "N", N);
      current_statement__ = 78;
      validate_non_negative_index("xreg", "J", J);
      current_statement__ = 79;
      context__.validate_dims("data initialization","xreg","double",
          context__.to_vec(N, J));
      xreg = Eigen::Matrix<double, -1, -1>(N, J);
      stan::math::fill(xreg, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xreg_flat__;
        current_statement__ = 79;
        assign(xreg_flat__, nil_index_list(), context__.vals_r("xreg"),
          "assigning variable xreg_flat__");
        current_statement__ = 79;
        pos__ = 1;
        current_statement__ = 79;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 79;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 79;
            assign(xreg,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xreg_flat__[(pos__ - 1)], "assigning variable xreg");
            current_statement__ = 79;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 80;
      validate_non_negative_index("REG_CAUCHY_SD", "J", J);
      current_statement__ = 81;
      context__.validate_dims("data initialization","REG_CAUCHY_SD","double",
          context__.to_vec(J));
      REG_CAUCHY_SD = Eigen::Matrix<double, -1, 1>(J);
      stan::math::fill(REG_CAUCHY_SD, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> REG_CAUCHY_SD_flat__;
        current_statement__ = 81;
        assign(REG_CAUCHY_SD_flat__, nil_index_list(),
          context__.vals_r("REG_CAUCHY_SD"),
          "assigning variable REG_CAUCHY_SD_flat__");
        current_statement__ = 81;
        pos__ = 1;
        current_statement__ = 81;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 81;
          assign(REG_CAUCHY_SD,
            cons_list(index_uni(sym1__), nil_index_list()),
            REG_CAUCHY_SD_flat__[(pos__ - 1)],
            "assigning variable REG_CAUCHY_SD");
          current_statement__ = 81;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 81;
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        current_statement__ = 81;
        current_statement__ = 81;
        check_greater_or_equal(function__, "REG_CAUCHY_SD[sym1__]",
                               REG_CAUCHY_SD[(sym1__ - 1)], 0);}
      current_statement__ = 82;
      reg0CauchySd = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 82;
      reg0CauchySd = (mean(REG_CAUCHY_SD) * 10);
      current_statement__ = 82;
      current_statement__ = 82;
      check_greater_or_equal(function__, "reg0CauchySd", reg0CauchySd, 0);
      current_statement__ = 83;
      validate_non_negative_index("regCoef", "J", J);
      current_statement__ = 84;
      validate_non_negative_index("l", "N", N);
      current_statement__ = 85;
      validate_non_negative_index("b", "N", N);
      current_statement__ = 86;
      validate_non_negative_index("r", "N", N);
      current_statement__ = 87;
      validate_non_negative_index("expVal", "N", N);
      current_statement__ = 88;
      validate_non_negative_index("smoothedInnovSize", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += J;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_ets_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> regCoef;
      regCoef = Eigen::Matrix<local_scalar_t__, -1, 1>(J);
      stan::math::fill(regCoef, DUMMY_VAR__);
      
      current_statement__ = 1;
      regCoef = in__.vector(J);
      local_scalar_t__ regOffset;
      regOffset = DUMMY_VAR__;
      
      current_statement__ = 2;
      regOffset = in__.scalar();
      local_scalar_t__ nu;
      nu = DUMMY_VAR__;
      
      current_statement__ = 3;
      nu = in__.scalar();
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        nu = stan::math::lub_constrain(nu, MIN_NU, MAX_NU, lp__);
      } else {
        current_statement__ = 3;
        nu = stan::math::lub_constrain(nu, MIN_NU, MAX_NU);
      }
      local_scalar_t__ sigma;
      sigma = DUMMY_VAR__;
      
      current_statement__ = 4;
      sigma = in__.scalar();
      current_statement__ = 4;
      if (jacobian__) {
        current_statement__ = 4;
        sigma = stan::math::lb_constrain(sigma, 0, lp__);
      } else {
        current_statement__ = 4;
        sigma = stan::math::lb_constrain(sigma, 0);
      }
      local_scalar_t__ levSm;
      levSm = DUMMY_VAR__;
      
      current_statement__ = 5;
      levSm = in__.scalar();
      current_statement__ = 5;
      if (jacobian__) {
        current_statement__ = 5;
        levSm = stan::math::lub_constrain(levSm, 0, 1, lp__);
      } else {
        current_statement__ = 5;
        levSm = stan::math::lub_constrain(levSm, 0, 1);
      }
      local_scalar_t__ bSm;
      bSm = DUMMY_VAR__;
      
      current_statement__ = 6;
      bSm = in__.scalar();
      current_statement__ = 6;
      if (jacobian__) {
        current_statement__ = 6;
        bSm = stan::math::lub_constrain(bSm, 0, 1, lp__);
      } else {
        current_statement__ = 6;
        bSm = stan::math::lub_constrain(bSm, 0, 1);
      }
      local_scalar_t__ powx;
      powx = DUMMY_VAR__;
      
      current_statement__ = 7;
      powx = in__.scalar();
      current_statement__ = 7;
      if (jacobian__) {
        current_statement__ = 7;
        powx = stan::math::lub_constrain(powx, 0, 1, lp__);
      } else {
        current_statement__ = 7;
        powx = stan::math::lub_constrain(powx, 0, 1);
      }
      local_scalar_t__ bInit;
      bInit = DUMMY_VAR__;
      
      current_statement__ = 8;
      bInit = in__.scalar();
      local_scalar_t__ powTrendBeta;
      powTrendBeta = DUMMY_VAR__;
      
      current_statement__ = 9;
      powTrendBeta = in__.scalar();
      current_statement__ = 9;
      if (jacobian__) {
        current_statement__ = 9;
        powTrendBeta = stan::math::lub_constrain(powTrendBeta, 0, 1, lp__);
      } else {
        current_statement__ = 9;
        powTrendBeta = stan::math::lub_constrain(powTrendBeta, 0, 1);
      }
      local_scalar_t__ coefTrend;
      coefTrend = DUMMY_VAR__;
      
      current_statement__ = 10;
      coefTrend = in__.scalar();
      local_scalar_t__ offsetSigma;
      offsetSigma = DUMMY_VAR__;
      
      current_statement__ = 11;
      offsetSigma = in__.scalar();
      current_statement__ = 11;
      if (jacobian__) {
        current_statement__ = 11;
        offsetSigma = stan::math::lb_constrain(offsetSigma, MIN_SIGMA, lp__);
      } else {
        current_statement__ = 11;
        offsetSigma = stan::math::lb_constrain(offsetSigma, MIN_SIGMA);
      }
      local_scalar_t__ locTrendFract;
      locTrendFract = DUMMY_VAR__;
      
      current_statement__ = 12;
      locTrendFract = in__.scalar();
      current_statement__ = 12;
      if (jacobian__) {
        current_statement__ = 12;
        locTrendFract = stan::math::lub_constrain(locTrendFract, 0, 1, lp__);
      } else {
        current_statement__ = 12;
        locTrendFract = stan::math::lub_constrain(locTrendFract, 0, 1);
      }
      local_scalar_t__ innovSm;
      innovSm = DUMMY_VAR__;
      
      current_statement__ = 13;
      innovSm = in__.scalar();
      current_statement__ = 13;
      if (jacobian__) {
        current_statement__ = 13;
        innovSm = stan::math::lub_constrain(innovSm, 0, 1, lp__);
      } else {
        current_statement__ = 13;
        innovSm = stan::math::lub_constrain(innovSm, 0, 1);
      }
      local_scalar_t__ innovSizeInit;
      innovSizeInit = DUMMY_VAR__;
      
      current_statement__ = 14;
      innovSizeInit = in__.scalar();
      current_statement__ = 14;
      if (jacobian__) {
        current_statement__ = 14;
        innovSizeInit = stan::math::lb_constrain(innovSizeInit, 0, lp__);
      } else {
        current_statement__ = 14;
        innovSizeInit = stan::math::lb_constrain(innovSizeInit, 0);
      }
      local_scalar_t__ powTrend;
      powTrend = DUMMY_VAR__;
      
      Eigen::Matrix<local_scalar_t__, -1, 1> l;
      l = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(l, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> b;
      b = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(b, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> r;
      r = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(r, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> expVal;
      expVal = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(expVal, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> smoothedInnovSize;
      smoothedInnovSize = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(smoothedInnovSize, DUMMY_VAR__);
      
      current_statement__ = 23;
      if (USE_REGRESSION) {
        current_statement__ = 22;
        assign(r, nil_index_list(), add(multiply(xreg, regCoef), regOffset),
          "assigning variable r");
      } else {
        current_statement__ = 21;
        assign(r, nil_index_list(), rep_vector(0, N), "assigning variable r");
      }
      current_statement__ = 26;
      if (USE_SMOOTHED_ERROR) {
        current_statement__ = 25;
        assign(smoothedInnovSize, cons_list(index_uni(1), nil_index_list()),
          innovSizeInit, "assigning variable smoothedInnovSize");
      } else {
        current_statement__ = 24;
        assign(smoothedInnovSize, cons_list(index_uni(1), nil_index_list()),
          1, "assigning variable smoothedInnovSize");
      }
      current_statement__ = 27;
      assign(l, cons_list(index_uni(1), nil_index_list()),
        (y[(1 - 1)] - r[(1 - 1)]), "assigning variable l");
      current_statement__ = 28;
      assign(b, cons_list(index_uni(1), nil_index_list()), bInit,
        "assigning variable b");
      current_statement__ = 29;
      powTrend = (((MAX_POW_TREND - MIN_POW_TREND) * powTrendBeta) +
                   MIN_POW_TREND);
      current_statement__ = 30;
      assign(expVal, cons_list(index_uni(1), nil_index_list()), y[(1 - 1)],
        "assigning variable expVal");
      current_statement__ = 38;
      for (int t = 2; t <= N; ++t) {
        current_statement__ = 31;
        assign(expVal, cons_list(index_uni(t), nil_index_list()),
          ((l[((t - 1) - 1)] + (locTrendFract * b[((t - 1) - 1)])) +
            r[(t - 1)]), "assigning variable expVal");
        current_statement__ = 32;
        assign(l, cons_list(index_uni(t), nil_index_list()),
          ((levSm * (y[(t - 1)] - r[(t - 1)])) +
            ((1 - levSm) * l[((t - 1) - 1)])), "assigning variable l");
        current_statement__ = 33;
        assign(b, cons_list(index_uni(t), nil_index_list()),
          ((bSm * (l[(t - 1)] - l[((t - 1) - 1)])) +
            (((1 - bSm) * locTrendFract) * b[((t - 1) - 1)])),
          "assigning variable b");
        current_statement__ = 36;
        if (USE_SMOOTHED_ERROR) {
          current_statement__ = 35;
          assign(smoothedInnovSize,
            cons_list(index_uni(t), nil_index_list()),
            ((innovSm * stan::math::abs((y[(t - 1)] - expVal[(t - 1)]))) +
              ((1 - innovSm) * smoothedInnovSize[((t - 1) - 1)])),
            "assigning variable smoothedInnovSize");
        } else {
          current_statement__ = 34;
          assign(smoothedInnovSize,
            cons_list(index_uni(t), nil_index_list()), 1,
            "assigning variable smoothedInnovSize");
        }}
      current_statement__ = 15;
      current_statement__ = 15;
      check_greater_or_equal(function__, "powTrend", powTrend, MIN_POW_TREND);
      current_statement__ = 15;
      current_statement__ = 15;
      check_less_or_equal(function__, "powTrend", powTrend, MAX_POW_TREND);
      current_statement__ = 16;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 16;
        current_statement__ = 16;
        check_greater_or_equal(function__, "l[sym1__]", l[(sym1__ - 1)], 0);}
      current_statement__ = 19;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 19;
        current_statement__ = 19;
        check_greater_or_equal(function__, "expVal[sym1__]",
                               expVal[(sym1__ - 1)], 0);}
      current_statement__ = 20;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 20;
        current_statement__ = 20;
        check_greater_or_equal(function__, "smoothedInnovSize[sym1__]",
                               smoothedInnovSize[(sym1__ - 1)], 0);}
      {
        current_statement__ = 39;
        if (logical_lt(sigma, 0)) {
          current_statement__ = 39;
          lp_accum__.add(stan::math::negative_infinity());
        } else {
          current_statement__ = 39;
          lp_accum__.add(-cauchy_ccdf_log(0, 0, CAUCHY_SD));
        }
        current_statement__ = 40;
        lp_accum__.add(cauchy_lpdf<propto__>(sigma, 0, CAUCHY_SD));
        current_statement__ = 41;
        if (logical_lt(offsetSigma, MIN_SIGMA)) {
          current_statement__ = 41;
          lp_accum__.add(stan::math::negative_infinity());
        } else {
          current_statement__ = 41;
          lp_accum__.add(-cauchy_ccdf_log(MIN_SIGMA, MIN_SIGMA, CAUCHY_SD));
        }
        current_statement__ = 42;
        lp_accum__.add(
          cauchy_lpdf<propto__>(offsetSigma, MIN_SIGMA, CAUCHY_SD));
        current_statement__ = 43;
        lp_accum__.add(cauchy_lpdf<propto__>(coefTrend, 0, CAUCHY_SD));
        current_statement__ = 44;
        lp_accum__.add(
          beta_lpdf<propto__>(powTrendBeta, POW_TREND_ALPHA, POW_TREND_BETA));
        current_statement__ = 47;
        if (USE_SMOOTHED_ERROR) {
          current_statement__ = 48;
          if (logical_lt(innovSizeInit, 0)) {
            current_statement__ = 48;
            lp_accum__.add(stan::math::negative_infinity());
          } else {
            current_statement__ = 48;
            lp_accum__.add(-cauchy_ccdf_log(0, (y[(1 - 1)] / 100), CAUCHY_SD));
          }
          current_statement__ = 49;
          lp_accum__.add(
            cauchy_lpdf<propto__>(innovSizeInit, (y[(1 - 1)] / 100),
              CAUCHY_SD));
        } else {
          current_statement__ = 45;
          if (logical_lt(innovSizeInit, 0)) {
            current_statement__ = 45;
            lp_accum__.add(stan::math::negative_infinity());
          } else {
            current_statement__ = 45;
            lp_accum__.add(-normal_ccdf_log(0, 0, 1));
          }
          current_statement__ = 46;
          lp_accum__.add(normal_lpdf<propto__>(innovSizeInit, 0, 1));
        }
        current_statement__ = 56;
        if (USE_REGRESSION) {
          current_statement__ = 53;
          lp_accum__.add(cauchy_lpdf<propto__>(regCoef, 0, REG_CAUCHY_SD));
          current_statement__ = 54;
          lp_accum__.add(cauchy_lpdf<propto__>(regOffset, 0, reg0CauchySd));
        } else {
          current_statement__ = 50;
          lp_accum__.add(normal_lpdf<propto__>(regCoef, 0, 1));
          current_statement__ = 51;
          lp_accum__.add(normal_lpdf<propto__>(regOffset, 0, 1));
        }
        current_statement__ = 57;
        lp_accum__.add(cauchy_lpdf<propto__>(bInit, 0, CAUCHY_SD));
        current_statement__ = 62;
        for (int t = 2; t <= N; ++t) {
          current_statement__ = 60;
          if (logical_eq(USE_SMOOTHED_ERROR, 0)) {
            current_statement__ = 59;
            lp_accum__.add(
              normal_lpdf<propto__>(y[(t - 1)], expVal[(t - 1)], offsetSigma));
          } else {
            current_statement__ = 58;
            lp_accum__.add(
              normal_lpdf<propto__>(y[(t - 1)], expVal[(t - 1)], offsetSigma));
          }}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_ets_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> regCoef;
      regCoef = Eigen::Matrix<double, -1, 1>(J);
      stan::math::fill(regCoef, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      regCoef = in__.vector(J);
      double regOffset;
      regOffset = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      regOffset = in__.scalar();
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      nu = in__.scalar();
      current_statement__ = 3;
      nu = stan::math::lub_constrain(nu, MIN_NU, MAX_NU);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma = in__.scalar();
      current_statement__ = 4;
      sigma = stan::math::lb_constrain(sigma, 0);
      double levSm;
      levSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      levSm = in__.scalar();
      current_statement__ = 5;
      levSm = stan::math::lub_constrain(levSm, 0, 1);
      double bSm;
      bSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      bSm = in__.scalar();
      current_statement__ = 6;
      bSm = stan::math::lub_constrain(bSm, 0, 1);
      double powx;
      powx = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      powx = in__.scalar();
      current_statement__ = 7;
      powx = stan::math::lub_constrain(powx, 0, 1);
      double bInit;
      bInit = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      bInit = in__.scalar();
      double powTrendBeta;
      powTrendBeta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      powTrendBeta = in__.scalar();
      current_statement__ = 9;
      powTrendBeta = stan::math::lub_constrain(powTrendBeta, 0, 1);
      double coefTrend;
      coefTrend = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      coefTrend = in__.scalar();
      double offsetSigma;
      offsetSigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 11;
      offsetSigma = in__.scalar();
      current_statement__ = 11;
      offsetSigma = stan::math::lb_constrain(offsetSigma, MIN_SIGMA);
      double locTrendFract;
      locTrendFract = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      locTrendFract = in__.scalar();
      current_statement__ = 12;
      locTrendFract = stan::math::lub_constrain(locTrendFract, 0, 1);
      double innovSm;
      innovSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 13;
      innovSm = in__.scalar();
      current_statement__ = 13;
      innovSm = stan::math::lub_constrain(innovSm, 0, 1);
      double innovSizeInit;
      innovSizeInit = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 14;
      innovSizeInit = in__.scalar();
      current_statement__ = 14;
      innovSizeInit = stan::math::lb_constrain(innovSizeInit, 0);
      double powTrend;
      powTrend = std::numeric_limits<double>::quiet_NaN();
      
      Eigen::Matrix<double, -1, 1> l;
      l = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(l, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> b;
      b = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(b, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> r;
      r = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(r, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> expVal;
      expVal = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(expVal, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> smoothedInnovSize;
      smoothedInnovSize = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(smoothedInnovSize, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        vars__.emplace_back(regCoef[(sym1__ - 1)]);}
      vars__.emplace_back(regOffset);
      vars__.emplace_back(nu);
      vars__.emplace_back(sigma);
      vars__.emplace_back(levSm);
      vars__.emplace_back(bSm);
      vars__.emplace_back(powx);
      vars__.emplace_back(bInit);
      vars__.emplace_back(powTrendBeta);
      vars__.emplace_back(coefTrend);
      vars__.emplace_back(offsetSigma);
      vars__.emplace_back(locTrendFract);
      vars__.emplace_back(innovSm);
      vars__.emplace_back(innovSizeInit);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 23;
      if (USE_REGRESSION) {
        current_statement__ = 22;
        assign(r, nil_index_list(), add(multiply(xreg, regCoef), regOffset),
          "assigning variable r");
      } else {
        current_statement__ = 21;
        assign(r, nil_index_list(), rep_vector(0, N), "assigning variable r");
      }
      current_statement__ = 26;
      if (USE_SMOOTHED_ERROR) {
        current_statement__ = 25;
        assign(smoothedInnovSize, cons_list(index_uni(1), nil_index_list()),
          innovSizeInit, "assigning variable smoothedInnovSize");
      } else {
        current_statement__ = 24;
        assign(smoothedInnovSize, cons_list(index_uni(1), nil_index_list()),
          1, "assigning variable smoothedInnovSize");
      }
      current_statement__ = 27;
      assign(l, cons_list(index_uni(1), nil_index_list()),
        (y[(1 - 1)] - r[(1 - 1)]), "assigning variable l");
      current_statement__ = 28;
      assign(b, cons_list(index_uni(1), nil_index_list()), bInit,
        "assigning variable b");
      current_statement__ = 29;
      powTrend = (((MAX_POW_TREND - MIN_POW_TREND) * powTrendBeta) +
                   MIN_POW_TREND);
      current_statement__ = 30;
      assign(expVal, cons_list(index_uni(1), nil_index_list()), y[(1 - 1)],
        "assigning variable expVal");
      current_statement__ = 38;
      for (int t = 2; t <= N; ++t) {
        current_statement__ = 31;
        assign(expVal, cons_list(index_uni(t), nil_index_list()),
          ((l[((t - 1) - 1)] + (locTrendFract * b[((t - 1) - 1)])) +
            r[(t - 1)]), "assigning variable expVal");
        current_statement__ = 32;
        assign(l, cons_list(index_uni(t), nil_index_list()),
          ((levSm * (y[(t - 1)] - r[(t - 1)])) +
            ((1 - levSm) * l[((t - 1) - 1)])), "assigning variable l");
        current_statement__ = 33;
        assign(b, cons_list(index_uni(t), nil_index_list()),
          ((bSm * (l[(t - 1)] - l[((t - 1) - 1)])) +
            (((1 - bSm) * locTrendFract) * b[((t - 1) - 1)])),
          "assigning variable b");
        current_statement__ = 36;
        if (USE_SMOOTHED_ERROR) {
          current_statement__ = 35;
          assign(smoothedInnovSize,
            cons_list(index_uni(t), nil_index_list()),
            ((innovSm * stan::math::abs((y[(t - 1)] - expVal[(t - 1)]))) +
              ((1 - innovSm) * smoothedInnovSize[((t - 1) - 1)])),
            "assigning variable smoothedInnovSize");
        } else {
          current_statement__ = 34;
          assign(smoothedInnovSize,
            cons_list(index_uni(t), nil_index_list()), 1,
            "assigning variable smoothedInnovSize");
        }}
      current_statement__ = 15;
      current_statement__ = 15;
      check_greater_or_equal(function__, "powTrend", powTrend, MIN_POW_TREND);
      current_statement__ = 15;
      current_statement__ = 15;
      check_less_or_equal(function__, "powTrend", powTrend, MAX_POW_TREND);
      current_statement__ = 16;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 16;
        current_statement__ = 16;
        check_greater_or_equal(function__, "l[sym1__]", l[(sym1__ - 1)], 0);}
      current_statement__ = 19;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 19;
        current_statement__ = 19;
        check_greater_or_equal(function__, "expVal[sym1__]",
                               expVal[(sym1__ - 1)], 0);}
      current_statement__ = 20;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 20;
        current_statement__ = 20;
        check_greater_or_equal(function__, "smoothedInnovSize[sym1__]",
                               smoothedInnovSize[(sym1__ - 1)], 0);}
      if (emit_transformed_parameters__) {
        vars__.emplace_back(powTrend);
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(l[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(b[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(r[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(expVal[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(smoothedInnovSize[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> regCoef;
      regCoef = Eigen::Matrix<double, -1, 1>(J);
      stan::math::fill(regCoef, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> regCoef_flat__;
        current_statement__ = 1;
        assign(regCoef_flat__, nil_index_list(), context__.vals_r("regCoef"),
          "assigning variable regCoef_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 1;
          assign(regCoef, cons_list(index_uni(sym1__), nil_index_list()),
            regCoef_flat__[(pos__ - 1)], "assigning variable regCoef");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      double regOffset;
      regOffset = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      regOffset = context__.vals_r("regOffset")[(1 - 1)];
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      nu = context__.vals_r("nu")[(1 - 1)];
      double nu_free__;
      nu_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      nu_free__ = stan::math::lub_free(nu, MIN_NU, MAX_NU);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      double sigma_free__;
      sigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      sigma_free__ = stan::math::lb_free(sigma, 0);
      double levSm;
      levSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      levSm = context__.vals_r("levSm")[(1 - 1)];
      double levSm_free__;
      levSm_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      levSm_free__ = stan::math::lub_free(levSm, 0, 1);
      double bSm;
      bSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      bSm = context__.vals_r("bSm")[(1 - 1)];
      double bSm_free__;
      bSm_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      bSm_free__ = stan::math::lub_free(bSm, 0, 1);
      double powx;
      powx = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      powx = context__.vals_r("powx")[(1 - 1)];
      double powx_free__;
      powx_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      powx_free__ = stan::math::lub_free(powx, 0, 1);
      double bInit;
      bInit = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      bInit = context__.vals_r("bInit")[(1 - 1)];
      double powTrendBeta;
      powTrendBeta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      powTrendBeta = context__.vals_r("powTrendBeta")[(1 - 1)];
      double powTrendBeta_free__;
      powTrendBeta_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      powTrendBeta_free__ = stan::math::lub_free(powTrendBeta, 0, 1);
      double coefTrend;
      coefTrend = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 10;
      coefTrend = context__.vals_r("coefTrend")[(1 - 1)];
      double offsetSigma;
      offsetSigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 11;
      offsetSigma = context__.vals_r("offsetSigma")[(1 - 1)];
      double offsetSigma_free__;
      offsetSigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 11;
      offsetSigma_free__ = stan::math::lb_free(offsetSigma, MIN_SIGMA);
      double locTrendFract;
      locTrendFract = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      locTrendFract = context__.vals_r("locTrendFract")[(1 - 1)];
      double locTrendFract_free__;
      locTrendFract_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      locTrendFract_free__ = stan::math::lub_free(locTrendFract, 0, 1);
      double innovSm;
      innovSm = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 13;
      innovSm = context__.vals_r("innovSm")[(1 - 1)];
      double innovSm_free__;
      innovSm_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 13;
      innovSm_free__ = stan::math::lub_free(innovSm, 0, 1);
      double innovSizeInit;
      innovSizeInit = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 14;
      innovSizeInit = context__.vals_r("innovSizeInit")[(1 - 1)];
      double innovSizeInit_free__;
      innovSizeInit_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 14;
      innovSizeInit_free__ = stan::math::lb_free(innovSizeInit, 0);
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        vars__.emplace_back(regCoef[(sym1__ - 1)]);}
      vars__.emplace_back(regOffset);
      vars__.emplace_back(nu_free__);
      vars__.emplace_back(sigma_free__);
      vars__.emplace_back(levSm_free__);
      vars__.emplace_back(bSm_free__);
      vars__.emplace_back(powx_free__);
      vars__.emplace_back(bInit);
      vars__.emplace_back(powTrendBeta_free__);
      vars__.emplace_back(coefTrend);
      vars__.emplace_back(offsetSigma_free__);
      vars__.emplace_back(locTrendFract_free__);
      vars__.emplace_back(innovSm_free__);
      vars__.emplace_back(innovSizeInit_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("regCoef");
    names__.emplace_back("regOffset");
    names__.emplace_back("nu");
    names__.emplace_back("sigma");
    names__.emplace_back("levSm");
    names__.emplace_back("bSm");
    names__.emplace_back("powx");
    names__.emplace_back("bInit");
    names__.emplace_back("powTrendBeta");
    names__.emplace_back("coefTrend");
    names__.emplace_back("offsetSigma");
    names__.emplace_back("locTrendFract");
    names__.emplace_back("innovSm");
    names__.emplace_back("innovSizeInit");
    names__.emplace_back("powTrend");
    names__.emplace_back("l");
    names__.emplace_back("b");
    names__.emplace_back("r");
    names__.emplace_back("expVal");
    names__.emplace_back("smoothedInnovSize");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(J)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "regCoef" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "regOffset");
    param_names__.emplace_back(std::string() + "nu");
    param_names__.emplace_back(std::string() + "sigma");
    param_names__.emplace_back(std::string() + "levSm");
    param_names__.emplace_back(std::string() + "bSm");
    param_names__.emplace_back(std::string() + "powx");
    param_names__.emplace_back(std::string() + "bInit");
    param_names__.emplace_back(std::string() + "powTrendBeta");
    param_names__.emplace_back(std::string() + "coefTrend");
    param_names__.emplace_back(std::string() + "offsetSigma");
    param_names__.emplace_back(std::string() + "locTrendFract");
    param_names__.emplace_back(std::string() + "innovSm");
    param_names__.emplace_back(std::string() + "innovSizeInit");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "powTrend");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "l" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "b" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "r" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "expVal" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "smoothedInnovSize" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "regCoef" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "regOffset");
    param_names__.emplace_back(std::string() + "nu");
    param_names__.emplace_back(std::string() + "sigma");
    param_names__.emplace_back(std::string() + "levSm");
    param_names__.emplace_back(std::string() + "bSm");
    param_names__.emplace_back(std::string() + "powx");
    param_names__.emplace_back(std::string() + "bInit");
    param_names__.emplace_back(std::string() + "powTrendBeta");
    param_names__.emplace_back(std::string() + "coefTrend");
    param_names__.emplace_back(std::string() + "offsetSigma");
    param_names__.emplace_back(std::string() + "locTrendFract");
    param_names__.emplace_back(std::string() + "innovSm");
    param_names__.emplace_back(std::string() + "innovSizeInit");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "powTrend");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "l" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "b" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "r" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "expVal" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "smoothedInnovSize" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"regCoef\",\"type\":{\"name\":\"vector\",\"length\":" << J << "},\"block\":\"parameters\"},{\"name\":\"regOffset\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"levSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"bSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powx\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"bInit\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrendBeta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"coefTrend\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"offsetSigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"locTrendFract\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSizeInit\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrend\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"l\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"r\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"expVal\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"smoothedInnovSize\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"regCoef\",\"type\":{\"name\":\"vector\",\"length\":" << J << "},\"block\":\"parameters\"},{\"name\":\"regOffset\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"levSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"bSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powx\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"bInit\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrendBeta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"coefTrend\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"offsetSigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"locTrendFract\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSm\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"innovSizeInit\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"powTrend\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"l\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"r\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"expVal\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"smoothedInnovSize\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_ets_namespace::model_ets;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_ets_namespace::profiles__;
}
#endif
#endif
