% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HTTPError.R
\docType{data}
\name{HTTPError}
\alias{HTTPError}
\alias{HTTPErrorFactory}
\title{Helps to generate HTTP error responses}
\format{
An object of class \code{HTTPError} (inherits from \code{R6}) of length 39.
}
\usage{
HTTPError
}
\description{
\strong{Global Object} which holds functions to raise common http error responses.
Most of the time this class is used jointly with \link{raise}. \cr
For example calling
\code{raise(HTTPError$bad_request(body = "request is invalid"))} from any place in the user code will
interrupt request processing and return response with status code = 404 and body = "request is invalid".

Class to generate HTTP error responses.
}
\section{Functions}{
\itemize{
\item \code{HTTPErrorFactory}: 

}}
\examples{
check_list = function(x) {
  if (!is.list(x)) raise(HTTPError$bad_request())
  invisible(TRUE)
}
check_list(list())
try(check_list(1), silent = TRUE)

}
\seealso{
\link{raise} \link{Application}
}
\keyword{datasets}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{content_type}}{Type of the error response.}

\item{\code{encode}}{Function to encode response body.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HTTPError-new}{\code{HTTPErrorFactory$new()}}
\item \href{#method-HTTPError-set_content_type}{\code{HTTPErrorFactory$set_content_type()}}
\item \href{#method-HTTPError-set_encode}{\code{HTTPErrorFactory$set_encode()}}
\item \href{#method-HTTPError-reset}{\code{HTTPErrorFactory$reset()}}
\item \href{#method-HTTPError-error}{\code{HTTPErrorFactory$error()}}
\item \href{#method-HTTPError-bad_request}{\code{HTTPErrorFactory$bad_request()}}
\item \href{#method-HTTPError-unauthorized}{\code{HTTPErrorFactory$unauthorized()}}
\item \href{#method-HTTPError-forbidden}{\code{HTTPErrorFactory$forbidden()}}
\item \href{#method-HTTPError-not_found}{\code{HTTPErrorFactory$not_found()}}
\item \href{#method-HTTPError-method_not_allowed}{\code{HTTPErrorFactory$method_not_allowed()}}
\item \href{#method-HTTPError-not_acceptable}{\code{HTTPErrorFactory$not_acceptable()}}
\item \href{#method-HTTPError-conflict}{\code{HTTPErrorFactory$conflict()}}
\item \href{#method-HTTPError-gone}{\code{HTTPErrorFactory$gone()}}
\item \href{#method-HTTPError-length_required}{\code{HTTPErrorFactory$length_required()}}
\item \href{#method-HTTPError-precondition_failed}{\code{HTTPErrorFactory$precondition_failed()}}
\item \href{#method-HTTPError-payload_too_large}{\code{HTTPErrorFactory$payload_too_large()}}
\item \href{#method-HTTPError-uri_too_long}{\code{HTTPErrorFactory$uri_too_long()}}
\item \href{#method-HTTPError-unsupported_media_type}{\code{HTTPErrorFactory$unsupported_media_type()}}
\item \href{#method-HTTPError-range_not_satisfiable}{\code{HTTPErrorFactory$range_not_satisfiable()}}
\item \href{#method-HTTPError-unprocessable_entity}{\code{HTTPErrorFactory$unprocessable_entity()}}
\item \href{#method-HTTPError-locked}{\code{HTTPErrorFactory$locked()}}
\item \href{#method-HTTPError-failed_dependency}{\code{HTTPErrorFactory$failed_dependency()}}
\item \href{#method-HTTPError-precondition_required}{\code{HTTPErrorFactory$precondition_required()}}
\item \href{#method-HTTPError-too_many_requests}{\code{HTTPErrorFactory$too_many_requests()}}
\item \href{#method-HTTPError-request_header_fields_too_large}{\code{HTTPErrorFactory$request_header_fields_too_large()}}
\item \href{#method-HTTPError-unavailable_for_legal_reasons}{\code{HTTPErrorFactory$unavailable_for_legal_reasons()}}
\item \href{#method-HTTPError-internal_server_error}{\code{HTTPErrorFactory$internal_server_error()}}
\item \href{#method-HTTPError-not_implemented}{\code{HTTPErrorFactory$not_implemented()}}
\item \href{#method-HTTPError-bad_gateway}{\code{HTTPErrorFactory$bad_gateway()}}
\item \href{#method-HTTPError-service_unavailable}{\code{HTTPErrorFactory$service_unavailable()}}
\item \href{#method-HTTPError-gateway_timeout}{\code{HTTPErrorFactory$gateway_timeout()}}
\item \href{#method-HTTPError-version_not_supported}{\code{HTTPErrorFactory$version_not_supported()}}
\item \href{#method-HTTPError-insufficient_storage}{\code{HTTPErrorFactory$insufficient_storage()}}
\item \href{#method-HTTPError-loop_detected}{\code{HTTPErrorFactory$loop_detected()}}
\item \href{#method-HTTPError-network_authentication_required}{\code{HTTPErrorFactory$network_authentication_required()}}
\item \href{#method-HTTPError-clone}{\code{HTTPErrorFactory$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-new"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-new}{}}}
\subsection{Method \code{new()}}{
Creates HTTPError object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$new(content_type = "text/plain", encode = as.character)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content_type}}{Type of the error response.}

\item{\code{encode}}{Function to encode response body.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-set_content_type"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-set_content_type}{}}}
\subsection{Method \code{set_content_type()}}{
Set content type of response.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$set_content_type(content_type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content_type}}{Type of the error response.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Modifying \link{HTTPError} will have global impact on RestRserve functionality.

By default \code{HTTPError} is used by \link{Application} in order to produce http
errors (404, 500, etc). Hence changing \code{HTTPError} with
\code{HTTPErrorFactory$set_content_type()} will impact not only user code, but
also the errors format produced by RestRserve. Same holds for
\code{HTTPErrorFactory$set_encode()} method below.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-set_encode"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-set_encode}{}}}
\subsection{Method \code{set_encode()}}{
Set encode for the given content type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$set_encode(encode)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{encode}}{Function to encode response body.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-reset"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-reset}{}}}
\subsection{Method \code{reset()}}{
Resets \code{HTTPError} to the default RestRserve state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-error"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-error}{}}}
\subsection{Method \code{error()}}{
Generate HTTP error response with a given status code and body.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$error(status_code, body = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status_code}}{HTTP status code.}

\item{\code{body}}{Response body.}

\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.
\code{headers} may be particularly useful.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-bad_request"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-bad_request}{}}}
\subsection{Method \code{bad_request()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$bad_request(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-unauthorized"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-unauthorized}{}}}
\subsection{Method \code{unauthorized()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$unauthorized(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-forbidden"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-forbidden}{}}}
\subsection{Method \code{forbidden()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$forbidden(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-not_found"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-not_found}{}}}
\subsection{Method \code{not_found()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$not_found(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-method_not_allowed"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-method_not_allowed}{}}}
\subsection{Method \code{method_not_allowed()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$method_not_allowed(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-not_acceptable"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-not_acceptable}{}}}
\subsection{Method \code{not_acceptable()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$not_acceptable(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-conflict"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-conflict}{}}}
\subsection{Method \code{conflict()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$conflict(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-gone"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-gone}{}}}
\subsection{Method \code{gone()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$gone(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-length_required"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-length_required}{}}}
\subsection{Method \code{length_required()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$length_required(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-precondition_failed"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-precondition_failed}{}}}
\subsection{Method \code{precondition_failed()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$precondition_failed(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-payload_too_large"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-payload_too_large}{}}}
\subsection{Method \code{payload_too_large()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$payload_too_large(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-uri_too_long"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-uri_too_long}{}}}
\subsection{Method \code{uri_too_long()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$uri_too_long(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-unsupported_media_type"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-unsupported_media_type}{}}}
\subsection{Method \code{unsupported_media_type()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$unsupported_media_type(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-range_not_satisfiable"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-range_not_satisfiable}{}}}
\subsection{Method \code{range_not_satisfiable()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$range_not_satisfiable(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-unprocessable_entity"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-unprocessable_entity}{}}}
\subsection{Method \code{unprocessable_entity()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$unprocessable_entity(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-locked"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-locked}{}}}
\subsection{Method \code{locked()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$locked(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-failed_dependency"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-failed_dependency}{}}}
\subsection{Method \code{failed_dependency()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$failed_dependency(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-precondition_required"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-precondition_required}{}}}
\subsection{Method \code{precondition_required()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$precondition_required(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-too_many_requests"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-too_many_requests}{}}}
\subsection{Method \code{too_many_requests()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$too_many_requests(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-request_header_fields_too_large"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-request_header_fields_too_large}{}}}
\subsection{Method \code{request_header_fields_too_large()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$request_header_fields_too_large(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-unavailable_for_legal_reasons"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-unavailable_for_legal_reasons}{}}}
\subsection{Method \code{unavailable_for_legal_reasons()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$unavailable_for_legal_reasons(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-internal_server_error"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-internal_server_error}{}}}
\subsection{Method \code{internal_server_error()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$internal_server_error(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-not_implemented"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-not_implemented}{}}}
\subsection{Method \code{not_implemented()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$not_implemented(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-bad_gateway"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-bad_gateway}{}}}
\subsection{Method \code{bad_gateway()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$bad_gateway(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-service_unavailable"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-service_unavailable}{}}}
\subsection{Method \code{service_unavailable()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$service_unavailable(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-gateway_timeout"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-gateway_timeout}{}}}
\subsection{Method \code{gateway_timeout()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$gateway_timeout(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-version_not_supported"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-version_not_supported}{}}}
\subsection{Method \code{version_not_supported()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$version_not_supported(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-insufficient_storage"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-insufficient_storage}{}}}
\subsection{Method \code{insufficient_storage()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$insufficient_storage(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-loop_detected"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-loop_detected}{}}}
\subsection{Method \code{loop_detected()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$loop_detected(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-network_authentication_required"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-network_authentication_required}{}}}
\subsection{Method \code{network_authentication_required()}}{
Generates corresponding http error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$network_authentication_required(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional named arguments which will be passed to \code{Response$new()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link{Response} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HTTPError-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HTTPError-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HTTPErrorFactory$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
