% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Middleware.R
\name{Middleware}
\alias{Middleware}
\title{Creates middleware object}
\description{
Creates Middleware object.

Middleware is a very useful concept which allows to perform
preprocessing of requests and post-processing of responses. Middleware has
an access to both \code{request} and  \code{response} objects and can modify them.
This way each request can be checked/modified before passing handler and
response can be post processed (for example this way we developer can set up
custom error messages).
}
\seealso{
\link{Request} \link{Response} \link{Application}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{process_request}}{Function which takes 2 arguments - \code{request} and
\code{response} objects (class  \link{Request} and \link{Response} correspondingly) and
modify \code{request} and \code{response} or throw exception using \link{HTTPError} helper.\cr
Function is called before request is routed to handler.\cr
Usually \code{process_request} is used to perform logging, check authorization, etc.}

\item{\code{process_response}}{Function which takes 2 arguments - \code{request} and
\code{response} objects (class \link{Request} and \link{Response} correspondingly) and
modify \code{request} and \code{response} or throw exception using \link{HTTPError} helper.\cr
Function is called after request is processed by handler.
Usually \code{process_response} is used to perform logging, custom error handling, etc.}

\item{\code{id}}{Middleware id.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Middleware-new}{\code{Middleware$new()}}
\item \href{#method-Middleware-clone}{\code{Middleware$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Middleware-new"></a>}}
\if{latex}{\out{\hypertarget{method-Middleware-new}{}}}
\subsection{Method \code{new()}}{
Creates middleware object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Middleware$new(
  process_request = function(request, response) TRUE,
  process_response = function(request, response) TRUE,
  id = "Middleware"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{process_request}}{Modify \code{request} or \code{response} objects or  throw
exception using \verb{[HTTPError]} helper. This function evaluate before
router handler called.}

\item{\code{process_response}}{Modify \code{request} or \code{response} objects or  throw
exception using \verb{[HTTPError]} helper. This function evaluate after
router handler called.}

\item{\code{id}}{Middleware id.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Middleware-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Middleware-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Middleware$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
