% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{bessel_k}
\alias{bessel_k}
\title{The BesselK Function}
\usage{
bessel_k(z, nu, expon_scaled = FALSE, verbose = 0)
}
\arguments{
\item{z}{A numeric or complex vector representing the input values at which to evaluate the Bessel function.}

\item{nu}{A double representing the order of the Bessel function.}

\item{expon_scaled}{A logical value indicating whether to use the exponentially scaled form of the Bessel function. Defaults to \code{FALSE}.}

\item{verbose}{An integer specifying the verbosity level for error messages. Defaults to \code{0}.}
}
\value{
A numeric or complex vector (depending on the input) containing the values of the \code{bessel_k} function evaluated at the points in \code{z}.
}
\description{
Computes the modified Bessel function of the second kind for real or complex inputs.
}
\references{
{
\insertRef{Maechler2024}{RcppBessel}\cr
\insertRef{Amos1995}{RcppBessel}
}
}
