% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce-functions.R
\name{sparseSummarizedExperiment}
\alias{sparseSummarizedExperiment}
\alias{compactSummarizedExperiment}
\alias{disjoinSummarizedExperiment}
\alias{qreduceSummarizedExperiment}
\alias{coerce-RaggedExperiment}
\alias{coerce,dgCMatrix,RaggedExperiment-method}
\title{Create SummarizedExperiment representations by transforming
    ragged assays to rectangular form.}
\usage{
sparseSummarizedExperiment(x, i = 1, withDimnames = TRUE, sparse = FALSE)

compactSummarizedExperiment(x, i = 1L, withDimnames = TRUE, sparse = FALSE)

disjoinSummarizedExperiment(x, simplifyDisjoin, i = 1L, withDimnames = TRUE)

qreduceSummarizedExperiment(
  x,
  query,
  simplifyReduce,
  i = 1L,
  withDimnames = TRUE
)
}
\arguments{
\item{x}{\code{RaggedExperiment}}

\item{i}{\code{integer(1)}, \code{character(1)}, or
\code{logical()} selecting the assay to be transformed.}

\item{withDimnames}{\code{logical(1)} default TRUE. propagate
dimnames to SummarizedExperiment.}

\item{sparse}{logical(1) whether to return a
\code{\link[Matrix]{sparseMatrix}} representation}

\item{simplifyDisjoin}{\code{function} of 1 argument, used to
transform assays. See \code{\link{assay-functions}}.}

\item{query}{\code{GRanges} provding regions over which reduction
is to occur.}

\item{simplifyReduce}{\code{function} of 3 arguments used to transform
assays. See \code{\link{assay-functions}}.}
}
\value{
All functions return \code{RangedSummarizedExperiment}.

\code{sparseSummarizedExperiment} has \code{rowRanges()}
    identical to the row ranges of \code{x}, and \code{assay()}
    data as \code{sparseAssay()}. This is very space-inefficient
    representation of ragged data. Use 'sparse=TRUE' to obtain
    a \code{\link[Matrix]{sparseMatrix}} assay representation.

\code{compactSummarizedExperiment} has \code{rowRanges()}
    identical to the row ranges of \code{x}, and \code{assay()}
    data as \code{compactAssay()}. This is space-inefficient
    representation of ragged data when samples are primarily
    composed of different ranges. Use 'sparse=TRUE' to obtain
    a \code{\link[Matrix]{sparseMatrix}} assay representation.

\code{disjoinSummarizedExperiment} has \code{rowRanges()}
    identical to the disjoint row ranges of \code{x},
    \code{disjoint(rowRanges(x))}, and \code{assay()} data as
    \code{disjoinAssay()}.

\code{qreduceSummarizedExperiment} has \code{rowRanges()}
    identical to \code{query}, and \code{assay()} data as
    \code{qreduceAssay()}.
}
\description{
These methods transform \code{RaggedExperiment}
    objects to similar \code{SummarizedExperiment} objects. They do
    so by transforming assay data to more rectangular
    representations, following the rules outlined for similarly
    names transformations \code{sparseAssay()},
    \code{compactAssay()}, \code{disjoinAssay()}, and
    \code{qreduceAssay()}. Because of the complexity of the
    transformation, ti usually only makes sense transform
    \code{RaggedExperiment} objects with a single assay; this is
    currently enforced at time of coercion.
}
\section{sparseMatrix}{

Convert a \code{dgCMatrix} to a \code{RaggedExperiment} given that the rownames
are coercible to \code{GRanges}.

In the following example, \code{x} is a \code{dgCMatrix} from the \code{Matrix} package.
\preformatted{
    `as(x, "RaggedExperiment")`
}
}

\examples{
x <- RaggedExperiment(GRangesList(
    GRanges(c("A:1-5", "A:4-6", "A:10-15"), score=1:3),
    GRanges(c("A:1-5", "B:1-3"), score=4:5)
))

## sparseSummarizedExperiment

sse <- sparseSummarizedExperiment(x)
assay(sse)
rowRanges(sse)

## compactSummarizedExperiment

cse <- compactSummarizedExperiment(x)
assay(cse)
rowRanges(cse)

## disjoinSummarizedExperiment

disjoinAssay(x, lengths)
dse <- disjoinSummarizedExperiment(x, lengths)
assay(dse)
rowRanges(dse)

## qreduceSummarizedExperiment

x <- RaggedExperiment(GRangesList(
    GRanges(c("A:1-3", "A:4-5", "A:10-15"), score=1:3),
    GRanges(c("A:4-5", "B:1-3"), score=4:5)
))
query <- GRanges(c("A:1-2", "A:4-5", "B:1-5"))

weightedmean <- function(scores, ranges, qranges)
{
    ## weighted average score per query range
    ## the weight corresponds to the size of the overlap of each
    ## overlapping subject range with the corresponding query range
    isects <- pintersect(ranges, qranges)
    sum(scores * width(isects)) / sum(width(isects))
}

qreduceAssay(x, query, weightedmean)
qse <- qreduceSummarizedExperiment(x, query, weightedmean)
assay(qse)
rowRanges(qse)

sm <- Matrix::sparseMatrix(
    i = c(2, 3, 4, 3, 4, 3, 4),
    j = c(1, 1, 1, 3, 3, 4, 4),
    x = c(2L, 4L, 2L, 2L, 2L, 4L, 2L),
    dims = c(4, 4),
    dimnames = list(
        c("chr2:1-10", "chr2:2-10", "chr2:3-10", "chr2:4-10"),
        LETTERS[1:4]
    )
)

as(sm, "RaggedExperiment")

}
