% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaggedExperiment-class.R,
%   R/RaggedExperiment-subset-methods.R
\name{RaggedExperiment-class}
\alias{RaggedExperiment-class}
\alias{RaggedExperiment}
\alias{coerce,RaggedExperiment,GRangesList-method}
\alias{coerce,GRangesList,RaggedExperiment-method}
\alias{class:RaggedExperiment}
\alias{seqinfo,RaggedExperiment-method}
\alias{seqinfo<-,RaggedExperiment-method}
\alias{rowRanges,RaggedExperiment-method}
\alias{rowRanges<-,RaggedExperiment,GRanges-method}
\alias{mcols,RaggedExperiment-method}
\alias{mcols<-,RaggedExperiment-method}
\alias{rowData,RaggedExperiment-method}
\alias{rowData<-,RaggedExperiment-method}
\alias{dim,RaggedExperiment-method}
\alias{dimnames,RaggedExperiment-method}
\alias{dimnames<-,RaggedExperiment,list-method}
\alias{length,RaggedExperiment-method}
\alias{colData,RaggedExperiment-method}
\alias{colData<-,RaggedExperiment,DataFrame-method}
\alias{assay,RaggedExperiment,missing-method}
\alias{assay,RaggedExperiment,ANY-method}
\alias{assays,RaggedExperiment-method}
\alias{assayNames,RaggedExperiment-method}
\alias{show,RaggedExperiment-method}
\alias{as.list,RaggedExperiment-method}
\alias{as.data.frame,RaggedExperiment-method}
\alias{$,RaggedExperiment-method}
\alias{[,RaggedExperiment,ANY,ANY,ANY-method}
\alias{overlapsAny,RaggedExperiment,Vector-method}
\alias{subsetByOverlaps,RaggedExperiment,Vector-method}
\alias{subset,RaggedExperiment-method}
\title{RaggedExperiment objects}
\usage{
RaggedExperiment(..., colData = DataFrame())

\S4method{seqinfo}{RaggedExperiment}(x)

\S4method{seqinfo}{RaggedExperiment}(x, new2old = NULL, pruning.mode = c("error", "coarse", "fine", "tidy")) <- value

\S4method{rowRanges}{RaggedExperiment}(x, ...)

\S4method{rowRanges}{RaggedExperiment,GRanges}(x, ...) <- value

\S4method{mcols}{RaggedExperiment}(x, use.names = FALSE, ...)

\S4method{mcols}{RaggedExperiment}(x, ...) <- value

\S4method{rowData}{RaggedExperiment}(x, use.names = TRUE, ...)

\S4method{rowData}{RaggedExperiment}(x, ...) <- value

\S4method{dim}{RaggedExperiment}(x)

\S4method{dimnames}{RaggedExperiment}(x)

\S4method{dimnames}{RaggedExperiment,list}(x) <- value

\S4method{length}{RaggedExperiment}(x)

\S4method{colData}{RaggedExperiment}(x, ...)

\S4method{colData}{RaggedExperiment,DataFrame}(x) <- value

\S4method{assay}{RaggedExperiment,missing}(x, i, withDimnames = TRUE, ...)

\S4method{assay}{RaggedExperiment,ANY}(x, i, withDimnames = TRUE, ...)

\S4method{assays}{RaggedExperiment}(x, withDimnames = TRUE, ...)

\S4method{assayNames}{RaggedExperiment}(x, ...)

\S4method{show}{RaggedExperiment}(object)

\S4method{as.list}{RaggedExperiment}(x, ...)

\S4method{as.data.frame}{RaggedExperiment}(x, row.names = NULL, optional = FALSE, ...)

\S4method{$}{RaggedExperiment}(x, name)

\S4method{[}{RaggedExperiment,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{overlapsAny}{RaggedExperiment,Vector}(
  query,
  subject,
  maxgap = 0L,
  minoverlap = 1L,
  type = c("any", "start", "end", "within", "equal"),
  ...
)

\S4method{subsetByOverlaps}{RaggedExperiment,Vector}(
  x,
  ranges,
  maxgap = -1L,
  minoverlap = 0L,
  type = c("any", "start", "end", "within", "equal"),
  invert = FALSE,
  ...
)

\S4method{subset}{RaggedExperiment}(x, subset, select, ...)
}
\arguments{
\item{...}{Constructor: GRanges, list of GRanges, or GRangesList OR
assay: Additional arguments for assay. See details for more information.}

\item{colData}{A \code{\link{DataFrame}} describing samples. Length of
rowRanges must equal the number of rows in colData}

\item{x}{A RaggedExperiment object.}

\item{new2old}{
    The \code{new2old} argument allows the user to rename, drop, add and/or
    reorder the "sequence levels" in \code{x}.

    \code{new2old} can be \code{NULL} or an integer vector with one element
    per entry in \link[GenomeInfoDb]{Seqinfo} object \code{value} (i.e. \code{new2old} and
    \code{value} must have the same length) describing how the "new" sequence
    levels should be mapped to the "old" sequence levels, that is, how the
    entries in \code{value} should be mapped to the entries in
    \code{seqinfo(x)}.
    The values in \code{new2old} must be >= 1 and <= \code{length(seqinfo(x))}.
    \code{NA}s are allowed and indicate sequence levels that are being added.
    Old sequence levels that are not represented in \code{new2old} will be
    dropped, but this will fail if those levels are in use (e.g. if \code{x}
    is a \link[GenomicRanges]{GRanges} object with ranges defined on those
    sequence levels) unless a pruning mode is specified via the
    \code{pruning.mode} argument (see below).

    If \code{new2old=NULL}, then sequence levels can only be added to the
    existing ones, that is, \code{value} must have at least as many entries
    as \code{seqinfo(x)} (i.e. \code{length(values) >= length(seqinfo(x))})
    and also \code{seqlevels(values)[seq_len(length(seqlevels(x)))]} must be
    identical to \code{seqlevels(x)}.

    Note that most of the times it's easier to proceed in 2 steps:
    \enumerate{
      \item First align the seqlevels on the left (\code{seqlevels(x)})
            with the seqlevels on the right.
      \item Then call \code{seqinfo(x) <- value}. Because
            \code{seqlevels(x)} and \code{seqlevels(value)} now are
            identical, there's no need to specify \code{new2old}.
    }
    This 2-step approach will typically look like this:
    \preformatted{    seqlevels(x) <- seqlevels(value)  # align seqlevels
    seqinfo(x) <- seqinfo(value)  # guaranteed to work
    }
    Or, if \code{x} has seqlevels not in \code{value}, it will look
    like this:
    \preformatted{    seqlevels(x, pruning.mode="coarse") <- seqlevels(value)
    seqinfo(x) <- seqinfo(value)  # guaranteed to work
    }
    The \code{pruning.mode} argument will control what happens to \code{x}
    when some of its seqlevels get droppped. See below for more information.
  }

\item{pruning.mode}{
    When some of the seqlevels to drop from \code{x} are in use (i.e. have
    ranges on them), the ranges on these sequences need to be removed before
    the seqlevels can be dropped. We call this \emph{pruning}. The
    \code{pruning.mode} argument controls how to \emph{prune} \code{x}.
    Four pruning modes are currently defined: \code{"error"}, \code{"coarse"},
    \code{"fine"}, and \code{"tidy"}. \code{"error"} is the default. In this
    mode, no pruning is done and an error is raised. The other pruning modes
    do the following:
    \itemize{
      \item \code{"coarse"}: Remove the elements in \code{x} where the
            seqlevels to drop are in use. Typically reduces the length of
            \code{x}. Note that if \code{x} is a list-like object (e.g.
            \link[GenomicRanges]{GRangesList},
            \link[GenomicAlignments]{GAlignmentPairs}, or
            \link[GenomicAlignments]{GAlignmentsList}), then any list
            element in \code{x} where at least one of the sequence levels
            to drop is in use is \emph{fully} removed. In other words,
            when \code{pruning.mode="coarse"}, the \code{seqlevels} setter
            will keep or remove \emph{full list elements} and not try to
            change their content. This guarantees that the exact ranges
            (and their order) inside the individual list elements are
            preserved. This can be a desirable property when the list
            elements represent compound features like exons grouped by
            transcript (stored in a \link[GenomicRanges]{GRangesList}
            object as returned by
            \code{\link[GenomicFeatures]{exonsBy}( , by="tx")}),
            or paired-end or fusion reads, etc...

      \item \code{"fine"}: Supported on list-like objects only. Removes
            the ranges that are on the sequences to drop. This removal is
            done within each list element of the original object \code{x}
            and doesn't affect its length or the order of its list elements.
            In other words, the pruned object is guaranteed to be
            \emph{parallel} to the original object.

      \item \code{"tidy"}: Like the \code{"fine"} pruning above but also
            removes the list elements that become empty as the result of
            the pruning. Note that this pruning mode is particularly well
            suited on a \link[GenomicRanges]{GRangesList} object that
            contains transcripts grouped by gene, as returned by
            \code{\link[GenomicFeatures]{transcriptsBy}( , by="gene")}.
            Finally note that, as a convenience, this pruning mode is
            supported on non list-like objects (e.g.
            \link[GenomicRanges]{GRanges} or
            \link[GenomicAlignments]{GAlignments} objects) and, in this
            case, is equivalent to the \code{"coarse"} mode.
    }
    See the "B. DROP SEQLEVELS FROM A LIST-LIKE OBJECT" section in the examples
    below for an extensive illustration of these pruning modes.
  }

\item{value}{\itemize{
\item{dimnames}: A \code{list} of dimension names
\item{mcols}: A \code{\link[S4Vectors]{DataFrame}} representing the
assays
}}

\item{use.names}{(logical default FALSE) whether to propagate rownames from
the object to rownames of metadata \code{DataFrame}}

\item{i}{logical(1), integer(1), or character(1) indicating the
assay to be reported. For \code{[}, \code{i} can be any
supported \code{Vector} object, e.g., \code{GRanges}.}

\item{withDimnames}{logical (default TRUE) whether to use dimension names
in the resulting object}

\item{object}{A RaggedExperiment object.}

\item{row.names}{\code{NULL} or a character vector giving the row
    names for the data frame.  Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and
    converting column names (to syntactic names: see
    \code{\link[base]{make.names}}) is optional.  Note that all of \R's
    \pkg{base} package \code{as.data.frame()} methods use
    \code{optional} only for column names treatment, basically with the
    meaning of \code{\link[base]{data.frame}(*, check.names = !optional)}.
    See also the \code{make.names} argument of the \code{matrix} method.}

\item{name}{
    A literal character string or a \link[base]{name} (possibly \link[base]{backtick}
    quoted).  For extraction, this is normally (see under
    \sQuote{Environments}) partially matched to the \code{\link[base]{names}}
    of the object.
  }

\item{j}{integer(), character(), or logical() index selecting
columns from RaggedExperiment}

\item{drop}{logical (default TRUE) whether to drop empty samples}

\item{query}{A RaggedExperiment instance.}

\item{subject, ranges}{Each of them can be an \link[IRanges]{IntegerRanges} (e.g.
   \link[IRanges]{IRanges}, \link[IRanges]{Views}) or
   \link[IRanges]{IntegerRangesList} (e.g. \link[IRanges]{IRangesList},
   \link[IRanges]{ViewsList}) derivative.
   In addition, if \code{subject} or \code{ranges} is an
   \link[IRanges]{IntegerRanges} object, \code{query} or \code{x} can be
   an integer vector to be converted to length-one ranges.

   If \code{query} (or \code{x}) is an \link[IRanges]{IntegerRangesList}
   object, then \code{subject} (or \code{ranges}) must also be an
   \link[IRanges]{IntegerRangesList} object.

   If both arguments are list-like objects with names, each list element
   from the 2nd argument is paired with the list element from the 1st
   argument with the matching name, if any. Otherwise, list elements are
   paired by position. The overlap is then computed between the pairs as
   described below.

   If \code{subject} is omitted, \code{query} is queried against
   itself. In this case, and only this case, the \code{drop.self}
   and \code{drop.redundant} arguments are allowed. By default,
   the result will contain hits for each range against itself, and if
   there is a hit from A to B, there is also a hit for B to A. If
   \code{drop.self} is \code{TRUE}, all self matches are dropped. If
   \code{drop.redundant} is \code{TRUE}, only one of A->B and B->A
   is returned.}

\item{maxgap}{
    A single integer >= -1.

    If \code{type} is set to \code{"any"}, \code{maxgap} is interpreted as
    the maximum \emph{gap} that is allowed between 2 ranges for the ranges
    to be considered as overlapping. The \emph{gap} between 2 ranges
    is the number of positions that separate them. The \emph{gap} between
    2 adjacent ranges is 0. By convention when one range has its start or
    end strictly inside the other (i.e. non-disjoint ranges), the \emph{gap}
    is considered to be -1.

    If \code{type} is set to anything else, \code{maxgap} has a special
    meaning that depends on the particular \code{type}. See \code{type}
    below for more information.
  }

\item{minoverlap}{
    A single non-negative integer.

    Only ranges with a minimum of \code{minoverlap} overlapping positions
    are considered to be overlapping.

    When \code{type} is \code{"any"}, at least one of \code{maxgap} and
    \code{minoverlap} must be set to its default value.
  }

\item{type}{
    By default, any overlap is accepted. By specifying the \code{type}
    parameter, one can select for specific types of overlap. The types
    correspond to operations in Allen's Interval Algebra (see
    references). If \code{type} is \code{start} or \code{end}, the
    intervals are required to have matching starts or ends,
    respectively. Specifying \code{equal} as the type returns the
    intersection of the \code{start} and \code{end} matches. If
    \code{type} is \code{within}, the query interval must be wholly
    contained within the subject interval. Note that all matches must
    additionally satisfy the \code{minoverlap} constraint described above.

    The \code{maxgap} parameter has special meaning with the special
    overlap types. For \code{start}, \code{end}, and \code{equal},
    it specifies the maximum difference in the starts, ends or both,
    respectively. For \code{within}, it is the maximum amount by which
    the subject may be wider than the query. If \code{maxgap} is set to -1
    (the default), it's replaced internally by 0.
  }

\item{invert}{
    If \code{TRUE}, keep only the ranges in \code{x} that do \emph{not}
    overlap \code{ranges}.
  }

\item{subset}{logical expression indicating elements or rows to keep:
    missing values are taken as false.}

\item{select}{
    If \code{query} is an \link[IRanges]{IntegerRanges} derivative:
    When \code{select} is \code{"all"} (the default), the results are
    returned as a \link[S4Vectors]{Hits} object.
    Otherwise the returned value is an integer vector \emph{parallel} to
    \code{query} (i.e. same length) containing the first, last,
    or arbitrary overlapping interval in \code{subject}, with \code{NA}
    indicating intervals that did not overlap any intervals in \code{subject}.

    If \code{query} is an \link[IRanges]{IntegerRangesList} derivative:
    When \code{select} is \code{"all"} (the default), the results are
    returned as a \link[S4Vectors]{HitsList} object.
    Otherwise the returned value depends on the \code{drop} argument.
    When \code{select != "all" && !drop}, an \link[IRanges]{IntegerList} is returned,
    where each element of the result corresponds to a space in \code{query}.
    When \code{select != "all" && drop}, an integer vector is returned
    containing indices that are offset to align with the unlisted \code{query}.
  }
}
\value{
constructor returns a \code{RaggedExperiment} object

'rowRanges' returns a \code{\link{GRanges}} object
    summarizing ranges corresponding to \code{assay()} rows.

'rowRanges<-' returns a \code{\link{RaggedExperiment}} object
    with replaced ranges

'mcols' returns a \code{\link{DataFrame}} object
    of the metadata columns

'assays' returns a \code{\link{SimpleList}}

'overlapsAny' returns a logical vector of length equal
    to the number of rows in the \code{query}; \code{TRUE} when the
    copy number region overlaps the \code{subject}.

'subsetByOverlaps' returns a RaggedExperiment containing
    only copy number regions overlapping \code{subject}.
}
\description{
The \code{RaggedExperiment} class is a container for
    storing range-based data, including but not limited to copy
    number data, and mutation data. It can store a collection of
    \code{GRanges} objects, as it is derived from the
    \code{GenomicRangesList}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{seqinfo(RaggedExperiment)}: seqinfo accessor

\item \code{seqinfo(RaggedExperiment) <- value}: Replace seqinfo metadata of the ranges

\item \code{rowRanges(RaggedExperiment)}: rowRanges accessor

\item \code{rowRanges(x = RaggedExperiment) <- value}: rowRanges replacement

\item \code{mcols(RaggedExperiment)}: get the metadata columns of the ranges,
rectangular representation of the 'assays'

\item \code{mcols(RaggedExperiment) <- value}: set the metadata columns of the ranges
corresponding to the assays

\item \code{rowData(RaggedExperiment)}: get the rowData or metadata for the ranges

\item \code{rowData(RaggedExperiment) <- value}: set the rowData or metadata for the ranges

\item \code{dim(RaggedExperiment)}: get dimensions (number of sample-specific row
ranges by number of samples)

\item \code{dimnames(RaggedExperiment)}: get row (sample-specific) range names
and sample names

\item \code{dimnames(x = RaggedExperiment) <- value}: set row (sample-specific) range names
and sample names

\item \code{length(RaggedExperiment)}: get the length of row vectors in the object,
similar to \linkS4class{SummarizedExperiment}

\item \code{colData(RaggedExperiment)}: get column data

\item \code{colData(x = RaggedExperiment) <- value}: change the colData

\item \code{assay(x = RaggedExperiment, i = missing)}: assay missing method uses first metadata column

\item \code{assay(x = RaggedExperiment, i = ANY)}: assay numeric method.

\item \code{assays(RaggedExperiment)}: assays

\item \code{assayNames(RaggedExperiment)}: names in each assay

\item \code{show(RaggedExperiment)}: show method

\item \code{as.list(RaggedExperiment)}: Allow extraction of metadata columns as a plain
\code{list}

\item \code{as.data.frame(RaggedExperiment)}: Allow conversion to plain \code{data.frame}

\item \code{$}: Easily access the \code{colData} columns with
the dollar sign operator

\item \code{x[i}: Subset a RaggedExperiment object

\item \code{overlapsAny(query = RaggedExperiment, subject = Vector)}: Determine whether copy number ranges
defined by \code{query} overlap ranges of \code{subject}.

\item \code{subsetByOverlaps(x = RaggedExperiment, ranges = Vector)}: Subset the RaggedExperiment to contain only
copy number ranges overlapping ranges of \code{subject}.

\item \code{subset(RaggedExperiment)}: subset helper function for dividing by rowData
and / or colData values

}}
\section{Constructors}{


\code{RaggedExperiment(..., colData=DataFrame())}: Creates a
RaggedExperiment object using multiple \code{GRanges} objects or a list
of \code{GRanges} objects.  Additional column data may be provided
as a \code{DataFrame} object.
}

\section{Accessors}{


In the following, 'x' represents a \code{RaggedExperiment} object:

    \code{rowRanges(x)}:

    Get the ranged data. Value is a \code{GenomicRanges} object.

    \code{assays(x)}:

    Get the assays. Value is a \code{\link[S4Vectors]{SimpleList}}.

    \code{assay(x, i)}:

    An alternative to \code{assays(x)[[i]]} to get the \emph{i}th
    (default first) assay element.

    \code{mcols(x), mcols(x) <- value}:

    Get or set the metadata columns. For \code{RaggedExperiment}, the
    columns correspond to the assay \emph{i}th elements.

    \code{rowData(x), rowData(x) <- value}:

    Get or set the row data. Value is a \code{\link[S4Vectors]{DataFrame}}
    object. Also corresponds to the \code{mcols} data.

    \strong{\emph{Note}} for advanced users and developers. Both
    \code{mcols} and \code{rowData} setters may reduce the size of the
    internal \code{RaggedExperiment} data representation. Particularly after
    subsetting, the internal row index is modified and such setter
    operations will use the index to subset the data and reduce the
    "rows" of the internal data representation.
}

\section{Subsetting}{


   \code{x[i, j]}:
   Get ranges or elements (\code{i} and \code{j}, respectively) with
   optional metadata columns where \code{i} or \code{j} can be missing,
   an NA-free logical, numeric, or character vector.
}

\section{Coercion}{


In the following, 'object' represents a \code{RaggedExperiment} object:

\code{as(object, "GRangesList")}:

Creates a \linkS4class{GRangesList} object from a \code{RaggedExperiment}.

\code{as(from, "RaggedExperiment")}:

Creates a \code{RaggedExperiment} object from a \linkS4class{GRangesList},
or \linkS4class{GRanges} object.
}

\examples{
## Create an empty RaggedExperiment instance
re0 <- RaggedExperiment()
re0

## Create a couple of GRanges objects with row ranges names
sample1 <- GRanges(
    c(a = "chr1:1-10:-", b = "chr1:11-18:+"),
    score = 1:2)
sample2 <- GRanges(
    c(c = "chr2:1-10:-", d = "chr2:11-18:+"),
    score = 3:4)

## Include column data
colDat <- DataFrame(id = 1:2)

## Create a RaggedExperiment object from a couple of GRanges
re1 <- RaggedExperiment(sample1=sample1, sample2=sample2, colData = colDat)
re1

## With list of GRanges
lgr <- list(sample1 = sample1, sample2 = sample2)

## Create a RaggedExperiment from a list of GRanges
re2 <- RaggedExperiment(lgr, colData = colDat)

grl <- GRangesList(sample1 = sample1, sample2 = sample2)

## Create a RaggedExperiment from a GRangesList
re3 <- RaggedExperiment(grl, colData = colDat)

## Subset a RaggedExperiment
assay(re3[c(1, 3),])
subsetByOverlaps(re3, GRanges("chr1:1-5"))  # by ranges
}
