% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpenFIGI_Func.R
\name{OpenFIGI_MappingCreator}
\alias{OpenFIGI_MappingCreator}
\title{Create mapping table out of OpenFIGI}
\usage{
OpenFIGI_MappingCreator(input, apikey = NULL,
  openfigiurl = "https://api.openfigi.com/v1/mapping",
  additioncols = c("ID_ISIN", "ID_BB_UNIQUE", "ID_SEDOL", "ID_COMMON",
  "ID_WERTPAPIER", "ID_CUSIP", "ID_BB", "ID_ITALY", "ID_EXCH_SYMBOL",
  "ID_FULL_EXCHANGE_SYMBOL", "COMPOSITE_ID_BB_GLOBAL",
  "ID_BB_GLOBAL_SHARE_CLASS_LEVEL", "ID_BB_SEC_NUM_DES", "ID_BB_GLOBAL",
  "TICKER", "ID_CUSIP_8_CHR", "OCC_SYMBOL", "UNIQUE_ID_FUT_OPT", "OPRA_SYMBOL",
  "TRADING_SYSTEM_IDENTIFIER"))
}
\arguments{
\item{input}{input data.frame or json, and others that can be feed into toJSON}

\item{apikey}{your API key}

\item{openfigiurl}{Bloomberg's OpenFIGI URL, please see https://openfigi.com/api}

\item{additioncols}{additional columns you would like to include in the data.frame}
}
\value{
a data.frame
}
\description{
Create mapping table out of OpenFIGI
}
\details{
assiging ISIN, CUSIP and other columns needed. Requires dplyr package to bind rows.
}
\examples{
\dontrun{
  setInternet2()
  figirst = OpenFIGI_MappingCreator(sampleOpenFIGIdf())
}
}

