% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.vimp.rfcca.R
\name{plot.vimp.rfcca}
\alias{plot.vimp.rfcca}
\alias{plot.vimp}
\title{Plot variable importance measures for rfcca objects}
\usage{
\method{plot.vimp}{rfcca}(x, sort = TRUE, ndisp = NULL, ...)
}
\arguments{
\item{x}{An object of class (rfcca,grow) or (rfcca,predict).}

\item{sort}{Should the z-variables be sorted according to their variable
importance measures in the plot? The default is \code{TRUE}.}

\item{ndisp}{Number of z-variables to display in the plot. If \code{sort}=
\code{TRUE}, the most important \code{ndisp} z-variables will be plotted.
Otherwise, the first \code{ndisp} z-variables in the original call will be
plotted. The default value is \code{NULL} which will plot all of the
z-variables.}

\item{...}{Optional arguments to be passed to other methods.}
}
\value{
Invisibly, the variable importance measures that were plotted.
}
\description{
Plots variable importance measures (VIMP) for subject-related z-variables for
training data.
}
\examples{
\donttest{
## load generated example data
data(data, package = "RFCCA")
set.seed(2345)

## train rfcca
rfcca.obj <- rfcca(X = data$X, Y = data$Y, Z = data$Z, ntree = 100,
  importance = TRUE)

## plot vimp
plot.vimp(rfcca.obj)
}
}
\seealso{
\code{\link{vimp.rfcca}}
}
