% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BPmix.R
\name{BPmix}
\alias{BPmix}
\title{Binomial mixtures with Poisson Trials via Kiefer Wolfowitz NPMLE}
\usage{
BPmix(x, m, v = 50, weights = NULL, ...)
}
\arguments{
\item{x}{Count of "successes" for binomial observations}

\item{m}{Number of trials for binomial observations}

\item{v}{Grid Values for the mixing distribution defaults to equal
spacing of length v on [eps, 1- eps], if v is scalar.}

\item{weights}{replicate weights for x obervations, should sum to 1}

\item{...}{Other arguments to be passed to KWDual to control optimization}
}
\value{
An object of class density with components: 
	\item{v}{grid points of evaluation of the success probabilities} 
	\item{u}{grid points of evaluation of the Poisson rate for number of trials} 
	\item{y}{function values of the mixing density at (v,u)} 
	\item{g}{estimates of the mixture density at the distinct data values} 
	\item{logLik}{Log Likelihood value at the estimate}
	\item{status}{exit code from the optimizer}
}
\description{
Interior point solution of Kiefer-Wolfowitz NPMLE for mixture of Poisson Binomials
}
\details{
The joint distribution of the probabilities of success and the number of trials
is estimated.  The grid specification for success probabilities is as for \code{Bmix}
whereas the grid for the Poisson rate parameters is currently the support of the 
observed trials.  There is no predict method as yet.  See \code{demo(BPmix1)}.
}
\references{
Kiefer, J. and J. Wolfowitz Consistency of the Maximum
Likelihood Estimator in the Presence of Infinitely Many Incidental
Parameters \emph{Ann. Math. Statist}. 27, (1956), 887-906.
}
\author{
R. Koenker
}
\keyword{nonparametric}
