% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_VarImp.R
\name{plot.VarImp}
\alias{plot.VarImp}
\title{Variable Importance Plot}
\usage{
\method{plot}{VarImp}(x, nvar = min(30, nrow(x$varImp)), digits = NULL, main = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{\link{VarImp}}.}

\item{nvar}{number of variables to show.}

\item{digits}{Integer indicating the number of decimal places (round) or significant digits (signif) to be used.}

\item{main}{plot title.}

\item{...}{Arguments to be passed to methods.}
}
\value{
The horizontal axis is the increased error of ODRF after replacing the variable, the larger the increased error the more important the variable is.
}
\description{
Dotchart of variable importance as measured by an Oblique Decision Random Forest.
}
\examples{
data(breast_cancer)
set.seed(221212)
train <- sample(1:569, 200)
train_data <- data.frame(breast_cancer[train, -1])
forest <- ODRF(train_data[, -1], train_data[, 1], split = "gini",
  parallel = FALSE)
varimp <- VarImp(forest, train_data[, -1], train_data[, 1])
plot(varimp)
}
\seealso{
\code{\link{ODRF}} \code{\link{VarImp}}
}
\keyword{forest}
\keyword{plot}
