# README

[![R-CMD-check](https://github.com/fawda123/NeuralNetTools/workflows/R-CMD-check/badge.svg)](https://github.com/fawda123/NeuralNetTools/actions)
[![pkgdown](https://github.com/fawda123/NeuralNetTools/workflows/pkgdown/badge.svg)](https://github.com/fawda123/NeuralNetTools/actions)
[![](http://cranlogs.r-pkg.org/badges/grand-total/NeuralNetTools)](https://cran.rstudio.com/web/packages/NeuralNetTools/index.html)

This is the development repository for the NeuralNetTools package.  Functions within this package can be used for the interpretation of neural network models created in R, including functions to plot a neural network interpretation diagram, evaluation of variable importance, and a sensitivity analysis of input variables. 

The development version of this package can be installed from Github:

```r
install.packages('devtools')
library(devtools)
install_github('fawda123/NeuralNetTools', ref = 'development')
```

The current release can be installed from CRAN:

```r
install.packages('NeuralNetTools')
```

See the [website](http://fawda123.github.io/NeuralNetTools) for additional information.

### Citation

Please cite this package as follows:

Beck MW (2018). "NeuralNetTools: Visualization and Analysis Tools for Neural Networks." _Journal of Statistical Software_, *85*(11), pp. 1-20. doi: 10.18637/jss.v085.i11 (URL: http://doi.org/10.18637/jss.v085.i11).

# Issues and suggestions

Please report any issues and suggestions on the [issues link](https://github.com/fawda123/NeuralNetTools/issues) for the repository.

A guide to posting issues can be found [here](.github/ISSUE_TEMPLATE.md).

# Contributing

Please view our [contributing](.github/CONTRIBUTING.md) guidelines for any changes or pull requests.

### License

This package is released in the public domain under the creative commons license [CC0](https://tldrlegal.com/license/creative-commons-cc0-1.0-universal). 
