% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rla.R
\name{rla}
\alias{rla}
\alias{rowRla}
\title{Calculate relative log abundances}
\usage{
rla(
  x,
  f = rep_len(1, length(x)),
  transform = c("log2", "log10", "identity"),
  na.rm = TRUE
)

rowRla(x, f = rep_len(1, ncol(x)), transform = c("log2", "log10", "identity"))
}
\arguments{
\item{x}{\code{numeric} (for \code{rla}) or \code{matrix} (for \code{rowRla}) with the
abundances (in natural scale) on which the RLA should be calculated.}

\item{f}{\code{factor}, \code{numeric} or \code{character} with the same length than \code{x}
(or, for \code{rowRla} equal to the number of columns of \code{x}) allowing to
define the grouping of values in \code{x}. If omitted all values are
considered to be from the same group.}

\item{transform}{\code{character(1)} defining the function to transform \code{x}.
Defaults to \code{transform = "log2"} which \code{log2} transforms \code{x} prior to
calculation. If \code{x} is already in log scale use \code{transform = "identity"}
to avoid transformation of the values.}

\item{na.rm}{\code{logical(1)} whether \code{NA} values should be removed prior to
calculation of the group-wise medians.}
}
\value{
\code{numeric} with the relative log abundances (in log2 scale) with the
same length than \code{x} (for \code{rla}) or \code{matrix} with the same dimensions
than \code{x} (for \code{rowRla}).
}
\description{
\code{rla} calculates the relative log abundances (RLA, see reference) on a
\code{numeric} vector. \code{rowRla} performs row-wise RLA calculations on a numeric
\code{matrix}.
}
\details{
The RLA is defined as the (log2) abundance of an analyte relative
to the median across all abundances of that analyte in samples of the
same group. The grouping of values can be defined with parameter \code{f}.
}
\examples{

x <- c(3, 4, 5, 1, 2, 3, 7, 8, 9)

grp <- c(1, 1, 1, 2, 2, 2, 3, 3, 3)

rla(x, grp)

x <- rbind(c(324, 4542, 3422, 3232, 5432, 6535, 3321, 1121),
     c(12, 3341, 3034, 6540, 34, 4532, 56, 1221))
grp <- c("a", "b", "b", "b", "a", "b", "a", "b")

## row-wise RLA values
rowRla(x, grp)
}
\references{
De Livera AM, Dias DA, De Souza D, Rupasinghe T, Pyke J, Tull D, Roessner U,
McConville M, Speed TP. Normalizing and integrating metabolomics data.
\emph{Anal Chem} 2012 Dec 18;84(24):10768-76.
}
\author{
Johannes Rainer
}
