% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noise.R
\name{noise}
\alias{noise}
\title{Noise Estimation}
\usage{
noise(x, y, method = c("MAD", "SuperSmoother"), ...)
}
\arguments{
\item{x}{\code{numeric}, x values for noise estimation (e.g. \emph{mz})}

\item{y}{\code{numeric}, y values for noise estimation (e.g. intensity)}

\item{method}{\code{character(1)} used method. Currently MAD (median absolute
deviation) and Friedman's SuperSmoother are supported.}

\item{...}{further arguments passed to \code{method}.}
}
\value{
A \code{numeric} of the same length as \code{x} with the estimated noise.
}
\description{
This functions estimate the noise in the data.
}
\examples{
x <- 1:20
y <- c(1:10, 10:1)
noise(x, y)
noise(x, y, method = "SuperSmoother", span = 1 / 3)
}
\seealso{
\code{\link[stats:mad]{stats::mad()}}, \code{\link[stats:supsmu]{stats::supsmu()}}

Other noise estimation and smoothing functions: 
\code{\link{smooth}()}
}
\author{
Sebastian Gibb
}
\concept{noise estimation and smoothing functions}
