% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxi.R
\name{maxi}
\alias{maxi}
\title{Maximum MS Intensity Value}
\usage{
maxi(x)
}
\arguments{
\item{x}{\code{numeric} with intensity values from which the maximum should be
reported. Will be coerced to \code{numeric}.}
}
\value{
\code{numeric(1)} representing the maximum of values in \code{x}. Returns
always a \code{numeric} (double) even if \code{x} is an integer.
}
\description{
\code{maxi} determines the maximum or mass spectrometry intensity values, e.g.
from a spectrum or chromatogram. In contrast to the base R \code{\link[=max]{max()}} function
this function returns \code{NA_real_} if all intensity values are \code{NA} or if
\code{length(x)} is 0 (the base R \code{max} function returns \code{-Inf} in these cases).
}
\examples{

x <- c(3.2, 34.4, 1.3, NA)
maxi(x)

## Compared to base R max:
max(x)
max(x, na.rm = TRUE)

max(numeric(), na.rm = TRUE)
maxi(numeric())

max(c(NA, NA), na.rm = TRUE)
maxi(c(NA, NA))
}
\seealso{
\code{\link[=sumi]{sumi()}}
}
\author{
Johannes Rainer, Sebastian Gibb
}
