% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_by_vector.R
\name{robustSummary}
\alias{robustSummary}
\title{Return the Robust Expression Summary of a matrix}
\usage{
robustSummary(x, ...)
}
\arguments{
\item{x}{A feature by sample \code{matrix} containing quantitative
data with mandatory \code{colnames} and \code{rownames}.}

\item{...}{Additional arguments passed to \code{\link[MASS:rlm]{MASS::rlm()}}.}
}
\value{
\code{numeric()} vector of length \code{ncol(x)} with robust
summarised values.
}
\description{
This function calculates the robust summarisation for each feature
(protein). Note that the function assumes that the intensities in
input \code{e} are already log-transformed.
}
\examples{
x <- matrix(rnorm(30), nrow = 3)
colnames(x) <- letters[1:10]
rownames(x) <- LETTERS[1:3]
robustSummary(x)
}
\seealso{
Other Quantitative feature aggregation: 
\code{\link{aggregate}()},
\code{\link{colCounts}()},
\code{\link{medianPolish}()}
}
\author{
Adriaan Sticker, Sebastian Gibb and Laurent Gatto
}
\concept{Quantitative feature aggregation}
