% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowMaxs.R
\name{rowMaxs}
\alias{rowMaxs}
\alias{rowMaxs,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowMaxs,ANY-method}
\alias{colMaxs}
\alias{colMaxs,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colMaxs,ANY-method}
\title{Calculates the maximum for each row (column) of a matrix-like object}
\usage{
rowMaxs(x, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)

\S4method{rowMaxs}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, na.rm = FALSE, dim. = dim(x), ..., useNames = TRUE)

\S4method{rowMaxs}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)

colMaxs(x, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)

\S4method{colMaxs}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, na.rm = FALSE, dim. = dim(x), ..., useNames = TRUE)

\S4method{colMaxs}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the maximum for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowMaxs}} /
\code{matrixStats::\link[matrixStats]{colMaxs}}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowMaxs(mat)
colMaxs(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:rowRanges]{rowMaxs}()} and
\code{matrixStats::\link[matrixStats:rowRanges]{colMaxs}()} which are used
when the input is a \code{matrix} or \code{numeric} vector.
\item For min estimates, see \code{\link{rowMins}()}.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
