% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRidgeList.R
\name{plotRidgeList}
\alias{plotRidgeList}
\title{Plot the ridge list}
\usage{
plotRidgeList(
  ridgeList,
  wCoefs = NULL,
  range = NULL,
  colorMap = "RYB",
  main = NULL,
  pch = ".",
  cex = 3,
  ...
)
}
\arguments{
\item{ridgeList}{returned by \code{\link[=getRidge]{getRidge()}}}

\item{wCoefs}{2-D CWT coefficients}

\item{range}{plot range of m/z index}

\item{colorMap}{colorMap to plot the points of local maximum}

\item{main}{parameter of \code{\link[=plot]{plot()}}}

\item{pch}{parameter of \code{\link[=plot]{plot()}}}

\item{cex}{parameter of \code{\link[=plot]{plot()}}}

\item{\dots}{other parameters of \code{\link[=points]{points()}}}
}
\value{
No value is returned; this function is called for its side effects
(plot).
}
\description{
Plot the ridge list returned by \code{\link[=getRidge]{getRidge()}}
}
\examples{

data(exampleMS)
scales <- seq(1, 64, 3)
wCoefs <- cwt(exampleMS[5000:11000], scales = scales, wavelet = "mexh")

localMax <- getLocalMaximumCWT(wCoefs)
ridgeList <- getRidge(localMax)
plotRidgeList(ridgeList)

}
\seealso{
\code{\link[=getRidge]{getRidge()}}
}
\author{
Pan Du
}
\keyword{hplot}
