% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPeak.R
\name{plotPeak}
\alias{plotPeak}
\title{Plot the identified peaks over the spectrum}
\usage{
plotPeak(
  ms,
  peakIndex = NULL,
  mz = 1:length(ms),
  range = c(min(mz), max(mz)),
  method = c("p", "l"),
  main = NULL,
  log = "",
  ...
)
}
\arguments{
\item{ms}{the MS spectrum}

\item{peakIndex}{m/z indexes of the identified peaks}

\item{mz}{m/z value correspond to m/z index}

\item{range}{the plot range of m/z value}

\item{method}{plot method of the identified peaks. method 'p' plot circles
on the peaks; method 'l' add vertical lines over the peaks.}

\item{main}{parameter of \code{\link[=plot]{plot()}}}

\item{log}{parameter of \code{\link[=plot]{plot()}}}

\item{\dots}{other parameters of \code{\link[=points]{points()}}}
}
\value{
No value is returned; this function is called for its side effects
(plot).
}
\description{
Plot the identified peaks over the spectrum. The identified peaks are
returned by \code{\link[=peakDetectionCWT]{peakDetectionCWT()}} or
\code{\link[=identifyMajorPeaks]{identifyMajorPeaks()}}
}
\examples{

data(exampleMS)
SNR.Th <- 3
peakInfo <- peakDetectionCWT(exampleMS, SNR.Th = SNR.Th)
majorPeakInfo <- peakInfo$majorPeakInfo
peakIndex <- majorPeakInfo$peakIndex
plotPeak(exampleMS, peakIndex, main = paste("Identified peaks with SNR >", SNR.Th))

}
\seealso{
\code{\link[=peakDetectionCWT]{peakDetectionCWT()}}, \code{\link[=identifyMajorPeaks]{identifyMajorPeaks()}}
}
\author{
Pan Du
}
\keyword{hplot}
