% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLocalMax.R
\name{plotLocalMax}
\alias{plotLocalMax}
\title{Plot the local maximum matrix}
\usage{
plotLocalMax(
  localMax,
  wCoefs = NULL,
  range = c(1, nrow(localMax)),
  colorMap = "RYB",
  main = NULL,
  cex = 3,
  pch = ".",
  ...
)
}
\arguments{
\item{localMax}{local maximum matrix of 2-D CWT coefficients returned by
\code{\link[=getLocalMaximumCWT]{getLocalMaximumCWT()}}}

\item{wCoefs}{2-D CWT coefficients}

\item{range}{plot range of m/z index}

\item{colorMap}{the colormap used in plotting the points}

\item{main}{parameter of \code{\link[=plot]{plot()}}}

\item{cex}{parameter of \code{\link[=plot]{plot()}}}

\item{pch}{parameter of \code{\link[=plot]{plot()}}}

\item{\dots}{other parameters of \code{\link[=points]{points()}}}
}
\value{
No value is returned; this function is called for its side effects
(plot).
}
\description{
Plot the local maximum matrix of 2-D CWT coefficients returned by
\code{\link[=getLocalMaximumCWT]{getLocalMaximumCWT()}}
}
\examples{

data(exampleMS)
scales <- seq(1, 64, 3)
wCoefs <- cwt(exampleMS[5000:11000], scales = scales, wavelet = "mexh")

localMax <- getLocalMaximumCWT(wCoefs)
plotLocalMax(localMax)

}
\seealso{
\code{\link[=getLocalMaximumCWT]{getLocalMaximumCWT()}}
}
\author{
Pan Du
}
\keyword{hplot}
