% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MHD.R, R/pkgname.R
\docType{package}
\name{MHD}
\alias{MHD}
\title{Calculate the Metric Halfspace Depth}
\usage{
MHD(
  mfd,
  data,
  anchors,
  XEval,
  theta0,
  depthOnly = FALSE,
  optGlo = list(),
  optLoc = list(),
  jiggle = 0,
  jiggleQuantile = 0.01
)
}
\arguments{
\item{mfd}{The manifold where the data is supported on. For example, the Euclidean space is generated using `manifold::createM('Euclidean')`, and the (hyper)sphere is `manifold::createM('Sphere')`. See `manifold` package for more details.}

\item{data}{A data frame giving the data points. Each row is an observation.}

\item{anchors}{A data frame for the anchor points for evaluating the halfspace probabilities. If missing, default to the data points together with possibly the jiggled points.}

\item{XEval}{A data frame for additional points at which the depth should be evaluated. Defaults to nothing.}

\item{theta0}{A vector for the initial value for searching for the deepest out-of-sample point.}

\item{depthOnly}{Calculate the depth values only if `TRUE`, or both the depth values and the out-of-sample deepest point if `FALSE` (default). The calculation of the deepest point can be time consuming.}

\item{optGlo, optLoc}{Lists of user specified option for the global and the local optimization steps, respectively. Follows the specification of nloptr::nloptr. For a list of options, use `nloptr.print.options()`, and for the list of algorithms see https://nlopt.readthedocs.io/en/latest/NLopt_Algorithms/  One should apply a derivative-free optimizers, and in particular one of `c('NLOPT_GN_DIRECT_NOSCAL', 'NLOPT_GN_DIRECT', 'NLOPT_GN_CRS2_LM', 'NLOPT_GN_MLSL_LDS')` in the global step and one of `c('NLOPT_LN_NELDERMEAD', 'NLOPT_LN_SBPLX')` for the local step.}

\item{jiggle}{An interger. The number of jiggled points per data point to add into the dataset. This is for making the approximated MHD depth more precise.}

\item{jiggleQuantile}{A numeric scalar. The amount of jiggling is determined by the `jiggleQuantile` quantile of the nonzero pairwise distances between the data and the anchor points.}
}
\value{
A list containing the following fields:
\item{sampDeepest}{The in-sample deepest point} 
\item{depthSamp}{The depth of the evaluation points}   
\item{depthDeepest}{The depth at the deepest out-of-sample point}
\item{xDeepest}{The deepest out-of-sample point}    
\item{theta0}{Initial value for the search of the deepest point}      
\item{optGlo}{Options used for the global search}      
\item{optLoc}{Options used for the local search}      
\item{nloptTime}{Time used by the optimization procedure}
}
\description{
Apply the metric halfspace depth algorithm (Dai and Lopez-Pintado (2022) <doi:10.1080/01621459.2021.2011298>) to calculate the metric halfspace depth at a set of evaluation points with respect to a data cloud. Also calculate the deepest points both in- and out-of-sample.
}
\examples{
mfd <- manifold::createM('Euclidean')

n <- 100
d <- 4
data <- matrix(rnorm(n * d), n, d)
anchors <- matrix(rnorm(n * d), 2 * n, d)

# The default
depthObj1 <- MHD(mfd, data)

# more precise, but slower
\donttest{
depthObj2 <- MHD(mfd, data, anchors) 
}

# Do not search for the deepest point. Faster
depthObj3 <- MHD(mfd, data, depthOnly=TRUE) 
}
