% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMNBLS.R
\name{FMNBLS}
\alias{FMNBLS}
\title{Fully Modified Narrow Band Least Squares (FMNBLS) estimation of the cointegrating
       vector.}
\usage{
FMNBLS(X, Y, m0, m1, m2, m3, method = c("local.W", "Hou.Perron", "ELW"))
}
\arguments{
\item{X}{data matrix.}

\item{Y}{data matrix.}

\item{m0}{bandwidth parameter.}

\item{m1}{bandwidth parameter.}

\item{m2}{bandwidth parameter.}

\item{m3}{bandwidth parameter.}

\item{method}{one from \code{method=c("local.W","Hou.Perron","ELW")}, to determine which
semiparametric long memory estimator is to be used.}
}
\description{
Semiparametric estimator for the cointegrating vector as suggested 
             by Nielsen and Frederiksen (2011). Refines the \code{FDLS}
             estimator by allowing for long run coherence between the regressors 
             and the errors.
}
\details{
add details here. Especially on the selection of 
         all these bandwidth parameters. carefull: it is not clear, whether HP an be used here.
}
\examples{
T<-500
d<-0.4
beta<-1

m0<-m3<-floor(T^0.4)                        
m1<-floor(T^0.6)                       
m2<-floor(T^0.8)

data<-FI.sim(T, q=2, rho=0.8, d=c(d,0))
xt<-data[,1]
et<-data[,2]
yt<-beta*xt+et
FDLS(xt,yt,m=m0)
FMNBLS(xt,yt,m0=m0, m1=m1, m2=m2, m3=m3)
}
\references{
Nielsen and Frederiksen (2011): Fully modified narrow-band least
            squares estimation of weak fractional cointegration. The Econometrics Journal,
            14, pp. 77-120.
}
\seealso{
\code{\link{FDLS}}, \code{\link{local.W}}, \code{\link{Hou.Perron}}, \code{\link{ELW}}
}
