% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MV04_LM.R
\name{FCI_MV04}
\alias{FCI_MV04}
\title{Test for fractional cointegration (Marmol, Velasco (2004))}
\usage{
FCI_MV04(X, type = c("none", "const", "trend"), N, m, alpha = 0.05)
}
\arguments{
\item{X}{data matrix.}

\item{type}{string that is either \code{"none"}, \code{"const"}, or \code{"trend"} and determines the form of linear regression.}

\item{N}{bandwidth parameter specifying the number of Fourier frequencies
used for the beta estimation, usually \code{floor(1+T^delta)}, where 0<delta<1.}

\item{m}{bandwith parameter specifying the number of Fourier frequencies
used for the memory parameter estimation, usually \code{floor(1+T^delta)}, where 0<delta<1.}

\item{alpha}{desired significance level. Default is \code{alpha=0.05}.}
}
\description{
\code{FCI_MV04} Semiparametric test for fractional cointegration by Marmol, Velasco (2004).
 Returns test statistic, critical value and testing decision. Null hypothesis: no fractional cointegration.
}
\examples{
T<-500
series<-FI.sim(T=T, q=2, rho=0.1, d=c(0.6,1), B=rbind(c(1,-1),c(0,1)))
FCI_MV04(series, type="const", N=floor(T^(0.75)), m=floor(T^(2/3)))
series<-FI.sim(T=T, q=2, rho=0.1, d=c(0.8,0.8))
FCI_MV04(series, type="const", N=floor(T^(0.75)), m=floor(T^(2/3)))
}
\references{
Marmol, F. and Velasco, C. (2004): Consistent testing of cointegrating relationships.
Econometrica, Vol. 72, No. 6, pp. 1809 - 1844.
}
\author{
Christian Leschinski, Michelle Voges
}
