% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st.R
\name{st}
\alias{st}
\title{The Stein estimator}
\usage{
st(X, y, H, h, d = NULL, is_error_normal = FALSE)
}
\arguments{
\item{X}{Matrix with input observations, of dimension \code{n} x \code{p};
each row is an observation vector.}

\item{y}{Vector with response observations of size \code{n}.}

\item{H}{A given \code{q} x \code{p} matrix.}

\item{h}{A given \code{q} x \code{1} vector.}

\item{d}{(Optional) If not provided (or set to \code{NULL}), it will be
set to be equal to \eqn{\frac{{(q - 2) \cdot (n - p)}}{{q \cdot (n - p + 2)}}.}}

\item{is_error_normal}{logical value indicating whether the errors follow a
normal distribution. If \code{is_error_normal} is \code{TRUE}, the distribution
of the test statistics for the null hypothesis is \code{\link[stats]{FDist}}.
 On the other hand, if the errors have a non-normal distribution, the
 asymptotic distribution of the test statistics is \code{\link[stats]{Chisquare}}.
 By default, \code{is_error_normal} is set to \code{FALSE}.}
}
\value{
An object of class \code{stein} is a list containing at least the following components:
  \describe{
    \item{\code{coef}}{A vector of coefficients.}
    \item{\code{residuals}}{The residuals, that is, the response values minus the fitted values.}
    \item{\code{s2}}{The estimated variance.}
    \item{\code{fitted.values}}{The fitted values.}
  }
}
\description{
This function can be used to calculate the Stein estimator using
\deqn{\hat{\beta}^{S}=\hat{\beta}^{U} - d \mathcal{L}^{-1} (\hat{\beta}^{U} - \hat{\beta}^{R})}
where
\itemize{
  \item \eqn{\hat{\beta}^{U}} is the unrestricted estimator; See \link[unrestricted]{unres}.
  \item \eqn{\hat{\beta}^{R}} is the restricted estimator; See \link[restricted]{res}.
  \item \eqn{\mathcal{L}} is the test statistic; See \link{ImpShrinkage}[teststat].
  \item \eqn{d} is the shrinkage factor.
}
}
\details{
The corresponding estimator of \eqn{\sigma^2} is
\deqn{s^2 = \frac{1}{n-p}(y-X\hat{\beta}^{S})^{\top}(y - X\hat{\beta}^{S}).}
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
p <- ncol(X)
# H beta = h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nrow = 3, ncol = p, byrow = TRUE)
h <- rep(0, nrow(H))
st(X, y, H, h)

# H beta != h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nrow = 3, ncol = p, byrow = TRUE)
h <- rep(1, nrow(H))
stein(X, y, H, h)

data(cement)
X <- as.matrix(cbind(1, cement[, 1:4]))
y <- cement$y
# Based on Kaciranlar et al. (1999)
H <- matrix(c(0, 1, -1, 1, 0), nrow = 1, ncol = 5, byrow = TRUE)
h <- rep(0, nrow(H))
st(X, y, H, h)
# Based on Kibria (2005)
H <- matrix(c(0, 1, -1, 1, 0, 0, 0, 1, -1, -1, 0, 1, -1, 0, -1), nrow = 3, ncol = 5, byrow = TRUE)
h <- rep(0, nrow(H))
st(X, y, H, h)

}
\references{
Saleh, A. K. Md. Ehsanes. (2006). \emph{Theory of Preliminary Test and
 Stein‐Type Estimation With Applications}, Wiley.

Kaciranlar, S., Akdeniz, S. S. F., Styan, G. P. & Werner, H. J. (1999). A new biased
estimators in linear regression and detailed
analysis of the widely-analysed dataset on
portland cement. \emph{Sankhya, Series B}, 61(3), 443-459.

Kibria, B. M. Golam (2005). Applications of Some Improved Estimators in Linear Regression,
\emph{Journal of Modern Applied Statistical Methods}, 5(2), 367- 380.
}
