% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipt.R
\name{coefficients.ipt}
\alias{coefficients.ipt}
\alias{coef.ipt}
\title{Extract Model Coefficients}
\usage{
\method{coefficients}{ipt}(object, ...)

\method{coef}{ipt}(object, ...)
}
\arguments{
\item{object}{An object of class \code{improvedpreliminaryTest}.}

\item{...}{Other arguments.}
}
\value{
A vector of coefficients.
}
\description{
Coefficients extracted from the model object \code{improvedpreliminaryTest}
}
\examples{
n_obs <- 100
p_vars <- 5
beta <- c(2, 1, 3, 0, 5)
simulated_data <- simdata(n = n_obs, p = p_vars, beta)
X <- simulated_data$X
y <- simulated_data$y
p <- ncol(X)
# H beta = h
H <- matrix(c(1, 1, -1, 0, 0, 1, 0, 1, 0, -1, 0, 0, 0, 1, 0), nrow = 3, ncol = p, byrow = TRUE)
h <- rep(0, nrow(H))
model <- ipt(X, y, H, h, alpha = 0.05)
coefficients(model)
coef(model)
}
\seealso{
\code{\link{coefficients.unres}},
\code{\link{coefficients.res}},
\code{\link{coefficients.pt}},
\code{\link{coefficients.st}},
\code{\link{coefficients.pst}},
\code{\link{coef.unres}},
\code{\link{coef.res}},
\code{\link{coef.pst}},
\code{\link{coef.st}},
\code{\link{coef.pst}}.
}
