% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxGrobs_distance.R
\name{distance}
\alias{distance}
\alias{print.Gmisc_unit}
\title{Get the distance between grid objects}
\usage{
distance(
  box1,
  box2,
  type = c("vertical", "horizontal", "euclidean"),
  half = FALSE,
  center = FALSE
)

\method{print}{Gmisc_unit}(x, ...)
}
\arguments{
\item{box1}{The first \code{\link{boxGrob}}. Can also be a \code{\link{coords}}
object, a \code{\link[grid]{unit}} or a numeric. The latter is evaluated to
a \code{unit} with \code{units="npc"}.}

\item{box2}{The second object to calculate the distance to. Same type as for \code{box1}.}

\item{type}{Whether we should retrieve the vertical, horizontal or euclidean distance}

\item{half}{If set to true it returns half the distance. This is convenient
when positioning boxes between each other.}

\item{center}{Calculate the distance from the center of each object}

\item{x}{A unit with from the \code{distance} function}

\item{...}{Passed on to print}
}
\value{
A \code{unit} in \code{"mm"} with an absolute value. The attribute
 \code{positive} indicates the direction of the value, i.e. if it is \code{TRUE} the
 distance was calculated from the first to the second, otherwise it is \code{FALSE}.
 For \code{euclidean} distance the \code{positive} attribute is \code{NA}. There is also the
 \code{from} and \code{to} attributes that has the coordinates that were used for the
 calculations, for \code{euclidean} distance this is \code{NA}.
}
\description{
Retrieves the distance between two boxes as absolute \code{"mm"} units. The function also
accepts \code{\link{coords}} objects as well as a \code{\link[grid]{unit}} or a numeric input.
}
\examples{
box1 <- boxGrob("A test box", y = .8)
box2 <- boxGrob("Another test box", y = .2)
distance(box1, box2, "v")
}
\seealso{
Other flowchart components: 
\code{\link{align}},
\code{\link{boxGrob}()},
\code{\link{boxPropGrob}()},
\code{\link{connectGrob}()},
\code{\link{coords}()},
\code{\link{moveBox}()},
\code{\link{spread}}
}
\concept{flowchart components}
