% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DWFuzzyGammaNaiveBayes.R
\name{DWFuzzyGammaNaiveBayes}
\alias{DWFuzzyGammaNaiveBayes}
\title{Double Weighted Fuzzy Gamma Naive Bayes}
\usage{
DWFuzzyGammaNaiveBayes(train, cl, cores = 2, fuzzy = TRUE, wdelta, weta)
}
\arguments{
\item{train}{matrix or data frame of training set cases.}

\item{cl}{factor of true classifications of training set}

\item{cores}{how many cores of the computer do you want to use to use for prediction (default = 2)}

\item{fuzzy}{boolean variable to use the membership function}

\item{wdelta}{vector weight each class}

\item{weta}{vector  weight each feature}
}
\value{
A vector of classifications
}
\description{
\code{DWFuzzyGammaNaiveBayes} Double Weighted Fuzzy Gamma Naive Bayes
}
\examples{

set.seed(1) # determining a seed
data(GamWeightData)

# Splitting into Training and Testing
split <- caTools::sample.split(t(GamWeightData[, 1]), SplitRatio = 0.7)
Train <- subset(GamWeightData, split == "TRUE")
Test <- subset(GamWeightData, split == "FALSE")
# ----------------
# matrix or data frame of test set cases.
# A vector will be interpreted as a row vector for a single case.
test <- Test[, -4]
fit_NBT <- DWFuzzyGammaNaiveBayes(
  train = Train[, -4],
  cl = Train[, 4], cores = 2,
  wdelta = c(2.002/6,1.998/6,2.000/6),
  weta = c(3/10,2/10, 5/10)
)

pred_NBT <- predict(fit_NBT, test)

head(pred_NBT)
head(Test[, 4])
}
\references{
\insertRef{marcos2020double}{FuzzyClass}
}
