% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MaxLikelihood.R
\name{MaxLikelihood}
\alias{MaxLikelihood}
\title{MaxLikelihood}
\usage{
MaxLikelihood(X, Z)
}
\arguments{
\item{X}{Coordinates}

\item{Z}{Observations}
}
\value{
Returns the estimate of the Hurst parameter (a real in [0,1))
 and a graph indicating the minimized maximum likelihood function with the Hurst parameter.
}
\description{
Maximum likelihood method for Hurst parameter estimation of multivariate data
}
\examples{
# Load FracKrigingR library
library(FracKrigingR)
# generate Coordinates
   p<-2; K<-20;
   X<-matrix(0,ncol=p, nrow=K)
   for(j in 1:p){
     for(i in 1:K){
       X[i,j] = rnorm(1, 0, 1)
     }
   }
   # generate fractional Brownian vector field
   H <- 0.8; m <- 3
   Z<-FracField(K,m,H,X)
  # Hurst parameter estimation
   MaxLikelihood(X,Z)

}
