% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information_gain.R
\name{.information_gain}
\alias{.information_gain}
\title{Direct Interface to Information Gain.}
\usage{
.information_gain(
  x,
  y,
  type = c("infogain", "gainratio", "symuncert"),
  equal = FALSE,
  discIntegers = TRUE,
  nbins = 5,
  threads = 1
)
}
\arguments{
\item{x}{A \link{data.frame}, sparse matrix or formula with attributes.}

\item{y}{A vector with response variable or data.frame if formula is used.}

\item{type}{Method name.}

\item{equal}{A logical. Whether to discretize dependent variable with the
\code{equal frequency binning discretization} or not.}

\item{discIntegers}{logical value.
If true (default), then integers are treated as numeric vectors and they are discretized.
If false  integers are treated as factors and they are left as is.}

\item{nbins}{Number of bins used for discretization. Only used if `equal = TRUE` and the response is numeric.}

\item{threads}{defunct. Number of threads for parallel backend - now turned off because of safety reasons.}
}
\description{
Direct Interface to Information Gain.
}
\details{
In principle using \code{\link{information_gain}} is safer.

data.frame with the following columns:
\itemize{
 \item attributes - variables names.
 \item importance - worth of the attributes.
}
}
