% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretize_transform.R
\name{discretize_transform}
\alias{discretize_transform}
\alias{extract_discretize_transformer}
\title{Transform a data.frame using split points returned by discretize function.}
\usage{
discretize_transform(disc, data, dropColumns = NA)

extract_discretize_transformer(disc)
}
\arguments{
\item{disc}{a result of the \code{\link{discretize}} function.}

\item{data}{a data.frame to transform using cutpoints from disc.}

\item{dropColumns}{determine}
}
\value{
A new data.frame with discretized columns using cutpoints
from the result of discretize function.
}
\description{
Transform a data.frame using split points returned by discretize function.
}
\examples{

set.seed(123)
idx <- sort(sample.int(150, 100))
iris1 <- iris[idx, ]
iris2 <- iris[-idx, ]
disc <- discretize(Species ~ ., iris)
head(discretize_transform(disc, iris2))

# Chain discretization:
ir1 <- discretize(Species ~ Sepal.Length, iris1)
ir2 <- discretize(Species ~ Sepal.Width, ir1, control = equalsizeControl(3))
ir3 <- discretize(Species ~ Petal.Length, ir2, control = equalsizeControl(5))

## note that Petal.Width is untouched:
head(discretize_transform(ir3, iris2))

## extract_discretize_transformer
discObj <- extract_discretize_transformer(ir3)
head(discretize_transform(discObj, iris2))

}
