% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_ExprNet.R
\name{analysis_ExprNet}
\alias{analysis_ExprNet}
\title{Computing and testing AT1 and AT2, and plotting sub-network}
\usage{
analysis_ExprNet(
  data_type1,
  data_type2,
  network,
  vertex_idx_selected = NULL,
  edge_pair_selected = NULL,
  alpha_t_test = 0.05,
  AT2_perm_test = TRUE,
  num_perm = 500,
  num_cores = parallel::detectCores(),
  type1_name = "Type1",
  type2_name = "Type2",
  subnet_label = "subnet",
  plot_subnet = TRUE,
  save_edge_res = FALSE,
  save_plot = FALSE,
  save_dir = here::here(),
  ...
)
}
\arguments{
\item{data_type1}{data.frame for phenotype 1. Each row corresponds to a vertex feature.
Each column corresponds to a sample. The first column are the numeric vertex indices.}

\item{data_type2}{data.frame for phenotype 2, in the same format as \emph{data_type1}.}

\item{network}{An \link[igraph]{igraph-package} graph object. It will be converted to an undirected graph by default.}

\item{vertex_idx_selected}{A numeric vector of vertex indices that you want to include in the sub-network. All edges on the network between these vertices will be included.}

\item{edge_pair_selected}{A character vector of edges that you want to include in the sub-network, each element in the form \emph{"vertex1-vertex2"} (e.g. "1-3").}

\item{alpha_t_test}{Significance level of the t test for each edge. It does not affect the computation of AT1 and AT2.}

\item{AT2_perm_test}{Logical. Whether to conduct permutation test for AT2. If \emph{FALSE}, then p-value of AT2 will be returned as NA.}

\item{num_perm}{Number of permutations in the permutation test.}

\item{num_cores}{Number of cores to register for parallel computing in permutation test. Should be no larger than the number of available cores on the computer.}

\item{type1_name}{The name for phenotype 1, used for naming files of the results.}

\item{type2_name}{The name for phenotype 2.}

\item{subnet_label}{A label for the sub-network, used for naming the files and setting the title in the plot.}

\item{plot_subnet}{Logical. Whether to plot the sub-network.}

\item{save_edge_res}{Logical. Whether the results should be saved. Set to TRUE if you plan to conduct analysis on the t statistics of the edges.}

\item{save_plot}{Logical. Whether to save the plot of the sub-network.}

\item{save_dir}{Directory to save the results. Results are saved in a subfolder \emph{result_ExprNet} will be created under the directory.}

\item{...}{Parameters for plots. For example, you may specify the size for the vertices and width for the edges.}
}
\value{
The same return as \code{\link[=compute_AT]{compute_AT()}}. A list of the following: \cr
subnet_label: label of the subnet; num_edges: number of edges in the sub-network; \cr
vertex_idx_selected, edge_pair_selected: the sub-network selection arguments provided by you; \cr
t_stat: t statistics of edges in the sub-network, t_stat_perc: percentiles of these t statistics among all edges in the original network;\cr
AT1: Value of AT1; pval_AT1: p-value of AT1; \cr
AT2: Value of AT2; pval_AT2: p-value of AT2)
}
\description{
Computing and testing AT1 and AT2, and plotting sub-network
}
\examples{
library(ExprNet)
network <- network_demo
data_type1 <- data_LGG_demo
data_type2 <- data_GBM_demo
edge_pair_selected <- c("1-8", "1-15", "2-16", "3-16", "5-10",
                        "5-16", "8-11", "8-13", "8-14", "8-15", "13-15")
# compute AT's
AT_res <- analysis_ExprNet(data_type1 = data_type1, data_type2 = data_type2, network = network,
                           edge_pair_selected = edge_pair_selected,
                           AT2_perm_test = TRUE, num_perm = 250, num_cores = 2,
                           type1_name = "LGG", type2_name = "GBM",
                           subnet_label = "Demo_GO0006306_DNA_methylation(LGG-GBM)",
                           vertex.label.cex = 1, vertex.size = 10, edge.width = 7)
}
