% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_statistics.R
\name{number_categories}
\alias{number_categories}
\title{Number of individuals having an attribute}
\usage{
number_categories(partition, attribute, stat, category)
}
\arguments{
\item{partition}{A partition (vector)}

\item{attribute}{A vector containing the values of the attribute}

\item{stat}{The statistic to compute : 'avg' for the sum of proportion per group and 'sum' for the total number}

\item{category}{The category to consider or category = 'all' if all categories have to be considered}
}
\value{
The statisic chosen in stat depending on the value of category. If category = 'all', returns a vector.
}
\description{
This function computes the total number of individuals being in a category of an attribute in a partition.
It also computes the sum of the proportion in each group of individuals being in
a category.
}
\examples{
p <- c(1,2,2,3,3,4,4,4,5)
at <- c(1,0,0,0,1,1,0,0,1)
number_categories(p,at,'avg','all')
}
