% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/displayWidget.R
\name{display-shiny}
\alias{display-shiny}
\alias{displayOutput}
\alias{renderDisplay}
\title{Shiny Bindings for display}
\usage{
displayOutput(outputId, width = "100\%", height = "500px")

renderDisplay(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates the image viewer (typicall through a call to \code{display})}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
Output and render functions for using the interactive image viewer within Shiny
applications and interactive R Markdown documents.
}

\seealso{
  \code{\link{display}}
}

\examples{
# Only run this example in interactive R sessions
if (interactive()) {
  options(device.ask.default = FALSE)

  require("shiny")
  
  ui <- fluidPage(
  
    # Application title
    titlePanel("Image display"),
  
    # Sidebar with a select input for the image
    sidebarLayout(
      sidebarPanel(
        selectInput("image", "Sample image:", list.files(system.file("images", package="EBImage")))
      ),
  
      # Show a plot of the generated distribution
      mainPanel(
        tabsetPanel(
          tabPanel("Static raster", plotOutput("raster")),
          tabPanel("Interactive browser", displayOutput("widget"))
        )
      )
    )
  
  )
  
  server <- function(input, output) {
  
    img <- reactive({
      f = system.file("images", input$image, package="EBImage")
      readImage(f)
    })
  
    output$widget <- renderDisplay({
      display(img())
    })
  
    output$raster <- renderPlot({
      plot(img(), all=TRUE)
    })
  
  }
  
  # Run the application
  shinyApp(ui = ui, server = server)
}
}
