% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rev_edge_dir_ws.R
\name{rev_edge_dir_ws}
\alias{rev_edge_dir_ws}
\title{Reverse the direction of selected edges in a graph using an edge selection}
\usage{
rev_edge_dir_ws(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Using a directed graph with a selection of edges as input, reverse the
direction of those selected edges in input graph.

This function makes use of an active selection of edges (and the function
ending with \verb{_ws} hints at this).

Selections of edges can be performed using the following selection
(\verb{select_*()}) functions: \code{\link[=select_edges]{select_edges()}}, \code{\link[=select_last_edges_created]{select_last_edges_created()}},
\code{\link[=select_edges_by_edge_id]{select_edges_by_edge_id()}}, or \code{\link[=select_edges_by_node_id]{select_edges_by_node_id()}}.

Selections of edges can also be performed using the following traversal
(\verb{trav_*()}) functions: \code{\link[=trav_out_edge]{trav_out_edge()}}, \code{\link[=trav_in_edge]{trav_in_edge()}},
\code{\link[=trav_both_edge]{trav_both_edge()}}, or \code{\link[=trav_reverse_edge]{trav_reverse_edge()}}.
}
\examples{
# Create a graph with a
# directed tree
graph <-
  create_graph() \%>\%
  add_balanced_tree(
    k = 2, h = 2)

# Inspect the graph's edges
graph \%>\% get_edges()

# Select all edges associated
# with nodes `1` and `2`
graph <-
  graph \%>\%
  select_edges_by_node_id(
    nodes = 1:2)

# Reverse the edge directions
# of the edges associated with
# nodes `1` and `2`
graph <-
  graph \%>\%
  rev_edge_dir_ws()

# Inspect the graph's edges
# after their reversal
graph \%>\% get_edges()

}
\seealso{
Other Edge creation and removal: 
\code{\link{add_edge_clone}()},
\code{\link{add_edge_df}()},
\code{\link{add_edges_from_table}()},
\code{\link{add_edges_w_string}()},
\code{\link{add_edge}()},
\code{\link{add_forward_edges_ws}()},
\code{\link{add_reverse_edges_ws}()},
\code{\link{copy_edge_attrs}()},
\code{\link{create_edge_df}()},
\code{\link{delete_edges_ws}()},
\code{\link{delete_edge}()},
\code{\link{delete_loop_edges_ws}()},
\code{\link{drop_edge_attrs}()},
\code{\link{edge_data}()},
\code{\link{join_edge_attrs}()},
\code{\link{mutate_edge_attrs_ws}()},
\code{\link{mutate_edge_attrs}()},
\code{\link{recode_edge_attrs}()},
\code{\link{rename_edge_attrs}()},
\code{\link{rescale_edge_attrs}()},
\code{\link{rev_edge_dir}()},
\code{\link{set_edge_attr_to_display}()},
\code{\link{set_edge_attrs_ws}()},
\code{\link{set_edge_attrs}()}
}
\concept{Edge creation and removal}
