% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colWeightedSds.R, R/colWeightedVars.R,
%   R/rowWeightedSds.R, R/rowWeightedVars.R
\name{colWeightedSds,DelayedMatrix-method}
\alias{colWeightedSds,DelayedMatrix-method}
\alias{colWeightedVars,DelayedMatrix-method}
\alias{rowWeightedSds,DelayedMatrix-method}
\alias{rowWeightedVars,DelayedMatrix-method}
\title{Calculates the weighted standard deviation for each row (column) of a
matrix-like object}
\usage{
\S4method{colWeightedSds}{DelayedMatrix}(
  x,
  w = NULL,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{colWeightedVars}{DelayedMatrix}(
  x,
  w = NULL,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{rowWeightedSds}{DelayedMatrix}(
  x,
  w = NULL,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{rowWeightedVars}{DelayedMatrix}(
  x,
  w = NULL,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{w}{A \code{\link{numeric}} vector of length K (N) that specifies by
how much each element is weighted.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set. \strong{Only \code{useNames = NA} is currently supported, other values are silently ignored.}}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the weighted standard deviation for each row (column) of a
matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowWeightedSds}} /
\code{matrixStats::\link[matrixStats]{colWeightedSds}}.
}
\examples{
# A DelayedMatrix with a 'SolidRleArraySeed' seed
dm_Rle <- RleArray(Rle(c(rep(1L, 5),
                         as.integer((0:4) ^ 2),
                         seq(-5L, -1L, 1L))),
                   dim = c(5, 3))

colWeightedSds(dm_Rle, w = 1 / rowMeans2(dm_Rle))

# Specifying weights inversely proportional to rowwise means
colWeightedVars(dm_Rle, w = 1 / rowMeans2(dm_Rle))

# Specifying weights inversely proportional to columnwise means
rowWeightedSds(dm_Rle, w = 1 / colMeans2(dm_Rle))

# Specifying weights inversely proportional to columnwise means
rowWeightedVars(dm_Rle, w = 1 / colMeans2(dm_Rle))
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:weightedVar]{rowWeightedSds}()} and
\code{matrixStats::\link[matrixStats:weightedVar]{colWeightedSds}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
\item See also \link[MatrixGenerics]{rowSds} for the corresponding unweighted function.
}
}
\author{
Peter Hickey
}
