% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_densities.R
\name{deboinr}
\alias{deboinr}
\title{Orders a data-set consisting of probability density functions on the same 
x-grid.  
Visualizes a boxplot of these functions based on the notion of
distance determined by the user.  
Reports outliers based on the distance chosen and k value.}
\usage{
deboinr(
  x_grid,
  densities_matrix,
  distance = c("hellinger", "nLQD", "fisher_rao", "TV_dist", "CLR", "wasserstein",
    "BD_fboxplot", "MBD_fboxplot", "user_defined"),
  median_type = c("cross", "geometric"),
  center_PDFs = FALSE,
  user_dist = NULL,
  k = 1.5,
  num_cores = 1
)
}
\arguments{
\item{x_grid}{Vector. X values of the PDF}

\item{densities_matrix}{Matrix. A n x p matrix where rows are individual PDFs and p matches the length of x_grid.}

\item{distance}{Character. The distance metric to use for the pairwise distances, or one of the two band depth options.}

\item{median_type}{Character. Whether the cross-median or the geometric median should be used.}

\item{center_PDFs}{Logical. Whether or not the modes of all the PDFs should be aligned prior to performing any calculations.}

\item{user_dist}{R Function. User-defined function that takes in two PDFs as vectors and returns a non-negative float corresponding to a distance between them.}

\item{k}{Float.  The factor by which to expand the IQR when calculating outliers.}

\item{num_cores}{Integer.  The number of cores to use if parallelizing the distance matrix calculations.}
}
\value{
An deboinr object containing the following:
\itemize{
  \item density_order. Vector of indices corresponding to rows of densities_matrix that sort from closest to furthest from the median PDF.
  \item outliers. Vector of indices corresponding to rows of densities_matrix that are determined to be outliers.
  \item box_plot. ggplot object of graphic output by calling this method.
}
}
\description{
Orders a data-set consisting of probability density functions on the same 
x-grid.  
Visualizes a boxplot of these functions based on the notion of
distance determined by the user.  
Reports outliers based on the distance chosen and k value.
}
\examples{

example_data = DeBoinR::pdf_data[1:100,]
xx = deboinr(DeBoinR::x_grid,
             as.matrix(example_data),
             distance = "hellinger",
             median_type = 'cross',
             center_PDFs = TRUE,
             num_cores = 1
)

print("about to print DeBoinR object...")
print(xx)
}
