# GAM problems
Florian Hartig  
10 Dec 2016  

This file demonstrates some problems with n/k binomials and gam from mgcv that were fixed by a hack for DHARMa > 0.1.3 

You must not have DHARMa loaded to see this problem


```r
library(mgcv)
```

```
## Loading required package: nlme
```

```
## This is mgcv 1.8-14. For overview type 'help("mgcv-package")'.
```

Test data is loaded here (hidden)





```r
# Fitting a glm and a gam

fittedModelGLM <- glm(cbind(observedResponse1,observedResponse0)  ~ Environment1 , family = "binomial", data = testData)

fittedModelGAM <- gam(cbind(observedResponse1,observedResponse0) ~ s(Environment1) ,family = "binomial", data = testData)
```

We can simulate from both models 


```r
out = simulate(fittedModelGLM, nsim = 10)
out2 = simulate(fittedModelGAM, nsim = 10)
```

however, although the class of both objects is df, they have different dimensions


```r
dim(out)
```

```
## [1] 200  10
```

```r
dim(out2)
```

```
## [1]  0 10
```

(seemingly), because the internal data is identical. 

I was tracking the problem back through the simulate function to the family function to the fitted function - the issue is that the fitted function for gam provides a unnamed vector


```r
fitted(fittedModelGLM)
```

```
##         1         2         3         4         5         6         7 
## 0.6798189 0.6899963 0.6741533 0.6550998 0.4767396 0.4423663 0.4618593 
##         8         9        10        11        12        13        14 
## 0.5531780 0.4833704 0.6149186 0.5706321 0.5872956 0.5397059 0.6354659 
##        15        16        17        18        19        20        21 
## 0.3448334 0.6783941 0.3353869 0.3008564 0.6048365 0.4854867 0.2885517 
##        22        23        24        25        26        27        28 
## 0.3340660 0.5424010 0.5286048 0.5045811 0.5076001 0.3390327 0.6382108 
##        29        30        31        32        33        34        35 
## 0.6327476 0.2916394 0.2944103 0.4932073 0.5354852 0.3531158 0.6530892 
##        36        37        38        39        40        41        42 
## 0.5179786 0.2954018 0.5194772 0.3825772 0.3000612 0.3519054 0.6017021 
##        43        44        45        46        47        48        49 
## 0.4474829 0.6249215 0.3629255 0.3187685 0.3776969 0.6457846 0.3474961 
##        50        51        52        53        54        55        56 
## 0.4029854 0.4628091 0.4060719 0.5374868 0.6457110 0.3012033 0.6657625 
##        57        58        59        60        61        62        63 
## 0.3897516 0.6326283 0.6289334 0.3935495 0.3688125 0.7095051 0.4473503 
##        64        65        66        67        68        69        70 
## 0.6443992 0.3734268 0.6599018 0.6073381 0.6466496 0.6049558 0.4568198 
##        71        72        73        74        75        76        77 
## 0.4582253 0.5667381 0.5436892 0.6011442 0.6085960 0.2991434 0.5922282 
##        78        79        80        81        82        83        84 
## 0.7057238 0.3518009 0.6930345 0.6972860 0.6014311 0.6741457 0.4409816 
##        85        86        87        88        89        90        91 
## 0.6231071 0.3908215 0.6410704 0.4962835 0.4120812 0.6363654 0.5084220 
##        92        93        94        95        96        97        98 
## 0.3518525 0.4188342 0.4262525 0.6834290 0.3920179 0.6357494 0.5051947 
##        99       100       101       102       103       104       105 
## 0.3559622 0.6077127 0.4747742 0.2974837 0.3604311 0.5918132 0.3112116 
##       106       107       108       109       110       111       112 
## 0.3003156 0.6708088 0.6739079 0.5831240 0.3454563 0.6143951 0.7046215 
##       113       114       115       116       117       118       119 
## 0.6282920 0.4745069 0.4151644 0.3048704 0.5986498 0.6209572 0.5256755 
##       120       121       122       123       124       125       126 
## 0.5726794 0.3202378 0.5044103 0.6035752 0.4931032 0.6702741 0.4787864 
##       127       128       129       130       131       132       133 
## 0.6828996 0.5387703 0.6245566 0.5996265 0.3512108 0.3433742 0.6487579 
##       134       135       136       137       138       139       140 
## 0.3535378 0.2906890 0.5310635 0.6046720 0.6613606 0.6027486 0.6147688 
##       141       142       143       144       145       146       147 
## 0.3701459 0.5646129 0.6575694 0.3071694 0.3780777 0.4086070 0.6696164 
##       148       149       150       151       152       153       154 
## 0.5241455 0.5711918 0.4444496 0.4735417 0.5670696 0.6273951 0.3287908 
##       155       156       157       158       159       160       161 
## 0.3201224 0.6399407 0.4659386 0.4288076 0.3969690 0.5275676 0.6898522 
##       162       163       164       165       166       167       168 
## 0.3277737 0.4673127 0.4803893 0.3779979 0.6809375 0.4942738 0.3478391 
##       169       170       171       172       173       174       175 
## 0.4037446 0.6751267 0.2880634 0.6264688 0.5425294 0.6004847 0.3770329 
##       176       177       178       179       180       181       182 
## 0.4809947 0.5594962 0.6005768 0.4974489 0.3219936 0.6992919 0.5992606 
##       183       184       185       186       187       188       189 
## 0.5784097 0.5949070 0.6924493 0.3058050 0.4200721 0.3852279 0.3067320 
##       190       191       192       193       194       195       196 
## 0.6322311 0.4085599 0.3181625 0.6654739 0.4899721 0.4402136 0.3518167 
##       197       198       199       200 
## 0.6582355 0.4234112 0.5755322 0.6039155
```

```r
fitted(fittedModelGAM)
```

```
##   [1] 0.6798178 0.6899950 0.6741523 0.6550992 0.4767406 0.4423672 0.4618602
##   [8] 0.5531788 0.4833714 0.6149188 0.5706327 0.5872961 0.5397068 0.6354657
##  [15] 0.3448330 0.6783931 0.3353864 0.3008552 0.6048368 0.4854877 0.2885503
##  [22] 0.3340654 0.5424018 0.5286057 0.5045821 0.5076011 0.3390322 0.6382105
##  [29] 0.6327474 0.2916381 0.2944091 0.4932083 0.5354861 0.3531156 0.6530886
##  [36] 0.5179796 0.2954005 0.5194782 0.3825774 0.3000601 0.3519051 0.6017024
##  [43] 0.4474838 0.6249215 0.3629253 0.3187676 0.3776970 0.6457842 0.3474957
##  [50] 0.4029858 0.4628100 0.4060724 0.5374877 0.6457106 0.3012021 0.6657617
##  [57] 0.3897519 0.6326281 0.6289333 0.3935498 0.3688125 0.7095035 0.4473511
##  [64] 0.6443988 0.3734269 0.6599012 0.6073383 0.6466492 0.6049560 0.4568207
##  [71] 0.4582262 0.5667388 0.5436901 0.6011445 0.6085962 0.2991422 0.5922287
##  [78] 0.7057222 0.3518006 0.6930331 0.6972846 0.6014314 0.6741448 0.4409824
##  [85] 0.6231071 0.3908218 0.6410700 0.4962845 0.4120818 0.6363652 0.5084230
##  [92] 0.3518522 0.4188348 0.4262532 0.6834279 0.3920182 0.6357492 0.5051957
##  [99] 0.3559620 0.6077129 0.4747752 0.2974825 0.3604310 0.5918136 0.3112106
## [106] 0.3003145 0.6708079 0.6739070 0.5831246 0.3454559 0.6143952 0.7046199
## [113] 0.6282919 0.4745078 0.4151649 0.3048693 0.5986502 0.6209572 0.5256765
## [120] 0.5726801 0.3202370 0.5044113 0.6035755 0.4931042 0.6702733 0.4787874
## [127] 0.6828984 0.5387712 0.6245565 0.5996268 0.3512105 0.3433738 0.6487575
## [134] 0.3535375 0.2906877 0.5310645 0.6046723 0.6613599 0.6027489 0.6147690
## [141] 0.3701458 0.5646136 0.6575687 0.3071684 0.3780778 0.4086075 0.6696155
## [148] 0.5241464 0.5711925 0.4444505 0.4735427 0.5670703 0.6273950 0.3287901
## [155] 0.3201216 0.6399404 0.4659396 0.4288083 0.3969693 0.5275685 0.6898509
## [162] 0.3277730 0.4673137 0.4803903 0.3779980 0.6809364 0.4942748 0.3478388
## [169] 0.4037450 0.6751257 0.2880621 0.6264688 0.5425303 0.6004850 0.3770330
## [176] 0.4809957 0.5594970 0.6005771 0.4974499 0.3219928 0.6992904 0.5992610
## [183] 0.5784103 0.5949074 0.6924480 0.3058039 0.4200727 0.3852281 0.3067309
## [190] 0.6322310 0.4085604 0.3181616 0.6654731 0.4899731 0.4402144 0.3518164
## [197] 0.6582348 0.4234119 0.5755328 0.6039158
```

Small difference, but that confuses the family$family$simulate() function, and that in turn provides the wrong data format for the simulate function 


