# From https://stats.stackexchange.com/questions/495823/residual-diagnostics-in-dharma-for-multilevel-logistic-regression



library(lme4)
library(DHARMa)

m1 <- glmer(error ~ 1 + year + categorisation + statistic + (1 | journalID),
            data = dat,
            family = binomial(link = "logit"))

simulationOutput <- simulateResiduals(fittedModel = m1)

# Main plot function from DHARMa, which gives 
# Left: a qq-plot to detect overall deviations from the expected distribution
# Right: a plot of the residuals against the rank-transformed model predictions
plot(simulationOutput)

# Plotting standardized residuals against predictors
plotResiduals(simulationOutput, dat$year, xlab = "Year", main=NULL)
plotResiduals(simulationOutput, dat$statistic, xlab = "Statistic Type", main=NULL)
plotResiduals(simulationOutput, dat$categorisation, xlab = "Category 1 or Category 2", main=NULL)
plotResiduals(simulationOutput, dat$journalID, xlab = "Journal ID", main=NULL)

# Plotting standardized residuals against the predicted value
plotResiduals(simulationOutput, main=NULL)
plotResiduals(simulationOutput, fitted(m1), xlab = "fitted(m1)")



dat = structure(list(error = c(FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, 
                         FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, 
                         TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, 
                         FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, TRUE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, TRUE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE, TRUE, 
                         TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, TRUE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, TRUE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, 
                         TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, TRUE, FALSE, FALSE, TRUE, TRUE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, TRUE, 
                         FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, TRUE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, TRUE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         TRUE, TRUE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, TRUE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, TRUE, 
                         FALSE, TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, TRUE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, FALSE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, TRUE, FALSE, FALSE, 
                         FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE
), year = c(7, 7, 7, 5, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
            9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 
            10, 11, 11, 10, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 10, 11, 
            11, 11, 11, 11, 11, 11, 11, 11, 11, 10, 12, 12, 11, 11, 12, 12, 
            10, 10, 12, 12, 12, 12, 12, 10, 11, 11, 11, 12, 12, 12, 12, 12, 
            12, 12, 12, 8, 12, 12, 12, 12, 12, 7, 12, 12, 12, 12, 12, 12, 
            12, 0, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 
            13, 13, 5, 13, 12, 13, 13, 13, 13, 11, 13, 13, 13, 13, 13, 13, 
            13, 13, 13, 13, 13, 13, 13, 13, 12, 13, 13, 13, 13, 13, 13, 13, 
            12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
            13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 
            13, 13, 13, 13, 13, 13, 13, 5, 13, 13, 13, 13, 13, 13, 14, 14, 
            14, 13, 14, 14, 14, 14, 14, 14, 13, 14, 14, 14, 13, 14, 14, 14, 
            14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
            14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
            14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
            14, 14, 14, 14, 12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
            14, 14, 14, 14, 14, 14, 14, 14, 15, 14, 14, 14, 14, 14, 14, 14, 
            14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
            14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
            14, 14, 14, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
            15, 15, 14, 14, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 
            15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
            15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 13, 15, 15, 15, 15, 
            15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
            15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
            15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
            15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
            15, 14, 15, 15, 15, 15, 15, 15, 15, 15, 14, 15, 15, 15, 15, 15, 
            15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
            15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
            15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
            15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 16, 16, 
            12, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
            16, 16, 16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
            16, 16, 16, 16, 13, 15, 15, 16, 16, 16, 15, 16, 16, 16, 16, 16, 
            16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
            16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
            16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
            16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
            16, 16, 16, 14, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
            16, 16, 16, 16, 16, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
            16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
            16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
            16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
            16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
            16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
            16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 15, 15, 15, 16, 16, 16, 
            16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 12, 14, 14, 16, 16, 16, 
            16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 
            17, 17, 17, 17, 17, 17, 6, 17, 17, 17, 16, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 16, 17, 17, 16, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 16, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 
            17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 17, 17, 17, 18, 18, 
            18, 18, 18, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
            18, 18, 17, 18, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
            18, 18, 18, 18, 18, 18, 18, 18, 18, 16, 18, 18, 18, 18, 18, 18, 
            18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 17, 18, 18, 18, 18, 
            17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 17, 18, 
            18, 18, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
            18, 18, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
            18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
            18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
            18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
            17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
            18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
            18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
            18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 17, 
            17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
            18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
            18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 
            18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 15, 19, 19, 19, 19, 
            19, 19, 19, 19, 19, 19, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 19, 19, 19, 19, 18, 19, 19, 19, 18, 18, 19, 14, 14, 14, 19, 
            19, 19, 19, 19, 19, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 19, 6, 19, 19, 19, 19, 19, 19, 19, 19, 18, 18, 6, 19, 19, 
            19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 7, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 19, 7, 19, 19, 19, 19, 19, 19, 19, 19, 19, 17, 18, 4, 4, 
            19, 19, 19, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 18, 19, 
            19, 19, 19, 19, 19, 17, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 
            19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 
            19, 20, 20, 20, 20, 16, 16, 17, 19, 19, 20, 20, 20, 20, 20, 19, 
            19, 19, 19, 20, 20, 20, 20, 20, 20, 20, 19, 20, 20, 19, 19, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 19, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 17, 18, 20, 18, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 19, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 19, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 4), categorisation = c(0, 1, 0, 0, 0, 1, 0, 0, 
                                                   0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 
                                                   0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 
                                                   1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 
                                                   0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
                                                   1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
                                                   1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
                                                   0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 
                                                   0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 
                                                   0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 
                                                   0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 
                                                   0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
                                                   0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
                                                   1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 
                                                   0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 
                                                   0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 
                                                   1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 
                                                   0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
                                                   0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 
                                                   0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 
                                                   0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
                                                   0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 
                                                   1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
                                                   0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
                                                   0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 
                                                   0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 
                                                   0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 
                                                   0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 
                                                   0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
                                                   0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
                                                   1, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 
                                                   1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
                                                   0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 
                                                   0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 
                                                   1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 
                                                   0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 
                                                   1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 
                                                   0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 
                                                   0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
                                                   1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 0, 
                                                   0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 
                                                   0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 
                                                   1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
                                                   0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
                                                   0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 
                                                   0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 
                                                   0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 
                                                   0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 
                                                   1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
                                                   1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
                                                   0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 
                                                   0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 
                                                   0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 
                                                   0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
                                                   0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 
                                                   0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 
                                                   1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 
                                                   0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 
                                                   1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 
                                                   0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 
                                                   0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 
                                                   0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 
                                                   0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
                                                   1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 
                                                   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 
                                                   1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 
                                                   0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 
                                                   0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 
                                                   0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 
                                                   0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 
                                                   0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 
                                                   0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 
                                                   0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 
                                                   0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 
                                                   0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 
                                                   1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 
                                                   0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 
                                                   0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 
                                                   1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 
                                                   0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
                                                   0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
                                                   0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 
                                                   0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
                                                   1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 
                                                   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 
                                                   1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
                                                   1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 
                                                   1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 
                                                   1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 
                                                   0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 
                                                   0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 
                                                   0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
                                                   0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 
                                                   1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 
                                                   0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 
                                                   1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 
                                                   1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 
                                                   1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 
                                                   1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 
                                                   0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1), 
statistic = c("F", "chi", "F", "F", "F", "F", "t", "F", "F", 
              "t", "t", "t", "t", "t", "chi", "t", "F", "F", "chi", "F", 
              "F", "t", "t", "F", "F", "t", "t", "F", "t", "F", "F", "F", 
              "F", "F", "F", "F", "F", "F", "F", "F", "t", "t", "t", "F", 
              "F", "chi", "F", "t", "F", "t", "F", "t", "t", "t", "F", 
              "F", "F", "F", "chi", "F", "F", "F", "t", "t", "F", "F", 
              "F", "F", "t", "F", "F", "F", "F", "F", "F", "F", "t", "F", 
              "F", "F", "F", "F", "F", "F", "t", "F", "F", "F", "F", "F", 
              "t", "F", "F", "F", "t", "F", "t", "F", "t", "F", "F", "F", 
              "F", "F", "F", "chi", "F", "F", "F", "t", "t", "F", "F", 
              "F", "F", "F", "t", "F", "F", "F", "F", "F", "F", "F", "F", 
              "F", "F", "F", "F", "t", "F", "F", "t", "F", "F", "F", "F", 
              "F", "F", "chi", "F", "F", "F", "F", "F", "F", "F", "t", 
              "t", "t", "t", "F", "F", "F", "F", "t", "F", "F", "F", "F", 
              "t", "t", "chi", "F", "F", "F", "F", "F", "F", "F", "F", 
              "F", "F", "F", "F", "F", "t", "t", "F", "F", "F", "F", "F", 
              "F", "F", "F", "chi", "t", "t", "F", "F", "F", "t", "t", 
              "t", "t", "t", "F", "F", "t", "chi", "F", "t", "F", "F", 
              "t", "F", "t", "F", "F", "F", "t", "F", "F", "F", "t", "t", 
              "F", "F", "F", "F", "F", "t", "F", "t", "F", "chi", "chi", 
              "F", "F", "F", "t", "F", "F", "F", "F", "F", "F", "F", "F", 
              "F", "F", "t", "F", "F", "F", "t", "F", "F", "F", "F", "F", 
              "F", "F", "F", "F", "F", "t", "t", "t", "t", "F", "F", "F", 
              "t", "t", "F", "chi", "t", "F", "chi", "t", "F", "F", "t", 
              "F", "F", "F", "F", "chi", "F", "F", "t", "t", "t", "F", 
              "F", "F", "F", "F", "F", "F", "F", "chi", "t", "F", "F", 
              "F", "t", "F", "t", "F", "t", "t", "F", "F", "t", "t", "t", 
              "t", "F", "F", "F", "t", "F", "t", "F", "F", "F", "F", "F", 
              "chi", "F", "F", "F", "F", "F", "F", "F", "F", "F", "t", 
              "F", "F", "F", "F", "F", "t", "F", "chi", "F", "t", "F", 
              "F", "F", "F", "F", "F", "F", "F", "chi", "F", "t", "t", 
              "r", "t", "F", "F", "t", "F", "F", "F", "r", "chi", "F", 
              "t", "F", "r", "r", "t", "F", "t", "chi", "F", "F", "F", 
              "F", "F", "t", "F", "t", "t", "F", "t", "F", "F", "F", "t", 
              "F", "t", "F", "t", "F", "t", "F", "F", "F", "F", "t", "t", 
              "t", "F", "t", "F", "F", "F", "F", "F", "F", "F", "t", "t", 
              "F", "F", "F", "F", "chi", "F", "t", "F", "F", "r", "F", 
              "F", "chi", "F", "F", "F", "F", "F", "F", "t", "F", "t", 
              "t", "F", "F", "F", "F", "F", "F", "F", "t", "F", "F", "chi", 
              "t", "F", "F", "F", "F", "F", "F", "t", "F", "F", "F", "F", 
              "t", "t", "F", "F", "F", "F", "F", "F", "F", "t", "F", "F", 
              "t", "F", "F", "t", "F", "r", "F", "F", "F", "F", "F", "r", 
              "F", "F", "t", "F", "F", "t", "F", "F", "F", "t", "r", "t", 
              "F", "F", "F", "chi", "t", "t", "F", "F", "F", "t", "t", 
              "F", "F", "F", "F", "F", "r", "F", "F", "F", "F", "F", "F", 
              "F", "F", "F", "F", "F", "F", "F", "F", "chi", "F", "F", 
              "F", "F", "F", "F", "F", "F", "t", "t", "F", "t", "F", "F", 
              "F", "F", "r", "t", "F", "F", "F", "t", "F", "F", "r", "F", 
              "F", "t", "F", "F", "F", "F", "F", "chi", "t", "F", "t", 
              "r", "F", "F", "t", "t", "F", "F", "F", "F", "t", "F", "F", 
              "F", "F", "chi", "F", "F", "F", "F", "t", "F", "F", "t", 
              "F", "F", "chi", "F", "F", "F", "F", "F", "F", "t", "t", 
              "F", "F", "F", "F", "F", "F", "F", "t", "t", "t", "F", "F", 
              "F", "F", "t", "t", "t", "F", "F", "F", "t", "F", "r", "F", 
              "F", "chi", "F", "F", "t", "F", "t", "F", "F", "F", "F", 
              "t", "F", "F", "F", "F", "F", "t", "F", "F", "F", "F", "chi", 
              "F", "F", "F", "F", "t", "F", "F", "r", "t", "r", "t", "F", 
              "F", "F", "F", "F", "F", "F", "t", "t", "t", "F", "t", "F", 
              "F", "F", "F", "F", "chi", "t", "F", "F", "F", "F", "t", 
              "F", "r", "F", "F", "chi", "F", "F", "F", "t", "F", "F", 
              "F", "F", "F", "F", "F", "t", "F", "t", "F", "t", "t", "t", 
              "F", "F", "F", "t", "t", "F", "F", "t", "t", "t", "t", "F", 
              "chi", "chi", "t", "F", "t", "F", "F", "F", "F", "t", "F", 
              "F", "F", "F", "t", "F", "F", "t", "F", "chi", "t", "t", 
              "F", "F", "t", "F", "F", "t", "F", "t", "t", "t", "F", "F", 
              "F", "F", "F", "F", "F", "F", "t", "F", "F", "F", "t", "t", 
              "F", "F", "chi", "F", "t", "t", "F", "t", "F", "F", "t", 
              "t", "t", "F", "F", "chi", "t", "F", "t", "F", "F", "F", 
              "F", "t", "F", "F", "F", "F", "F", "F", "F", "F", "F", "t", 
              "t", "F", "t", "t", "t", "t", "r", "F", "F", "F", "t", "t", 
              "F", "t", "F", "t", "t", "F", "F", "F", "F", "F", "F", "t", 
              "t", "F", "F", "chi", "chi", "F", "F", "F", "F", "t", "F", 
              "F", "F", "F", "F", "t", "F", "F", "F", "F", "F", "F", "F", 
              "t", "F", "F", "F", "F", "F", "F", "F", "F", "F", "t", "F", 
              "t", "F", "F", "F", "F", "F", "F", "F", "t", "t", "F", "t", 
              "t", "F", "r", "t", "t", "t", "t", "F", "F", "t", "F", "t", 
              "F", "F", "F", "F", "F", "F", "t", "t", "F", "F", "F", "F", 
              "F", "F", "F", "r", "F", "F", "t", "F", "t", "t", "t", "F", 
              "F", "chi", "t", "F", "F", "F", "F", "t", "F", "t", "t", 
              "t", "t", "t", "t", "r", "F", "F", "F", "F", "t", "F", "t", 
              "t", "t", "F", "F", "F", "t", "F", "F", "F", "F", "F", "t", 
              "F", "F", "F", "t", "F", "F", "F", "F", "F", "t", "F", "F", 
              "F", "F", "F", "F", "F", "F", "F", "chi", "F", "F", "F", 
              "t", "t", "F", "F", "t", "F", "F", "F", "t", "t", "F", "F", 
              "F", "F", "F", "t", "F", "t", "F", "F", "F", "F", "F", "F", 
              "t", "F", "t", "F", "F", "t", "t", "F", "F", "F", "t", "t", 
              "F", "F", "F", "F", "F", "r", "r", "t", "t", "t", "t", "r", 
              "F", "t", "F", "r", "t", "F", "t", "t", "F", "F", "F", "F", 
              "t", "chi", "t", "F", "F", "F", "t", "F", "t", "F", "chi", 
              "t", "F", "F", "F", "F", "F", "F", "F", "t", "F", "F", "F", 
              "F", "F", "F", "F", "t", "t", "t", "t", "F", "F", "F", "t", 
              "F", "t", "t", "r", "F", "F", "F", "F", "F", "chi", "t", 
              "chi", "chi", "F", "F", "F", "F", "t", "F", "F", "t", "F", 
              "t", "F", "t", "F", "F", "F", "F", "chi", "F", "F", "r", 
              "F", "t", "t", "F", "F", "F", "F", "F", "chi", "chi", "F", 
              "F", "F", "F", "F", "F", "F", "t", "chi", "F", "chi", "t", 
              "F", "F", "F", "F", "F", "F", "t", "F", "t", "t", "t", "F", 
              "F", "F", "t", "F", "F", "F", "F", "F", "F", "F", "F", "chi", 
              "F", "F", "F", "t", "t", "F", "F", "F", "r", "r", "t", "F", 
              "F", "F", "F", "F", "F", "t", "F", "t", "t", "F", "F", "F", 
              "F", "F", "F", "chi", "F", "t", "F", "F", "t", "t", "t", 
              "F", "F", "F", "t", "F", "F", "F", "F", "F", "F", "F", "F", 
              "t", "t", "F", "F", "t", "F", "r", "t", "chi", "F", "F", 
              "F", "t", "t", "t", "t", "F", "F", "F", "F", "F", "r", "F", 
              "t", "F", "chi", "t", "F", "F", "F", "t", "F", "chi", "chi", 
              "t", "F", "t", "chi", "F", "F", "chi", "F", "F", "F", "F", 
              "F", "t", "chi", "F", "F", "t", "F", "t", "F", "F", "F", 
              "F", "F", "t", "F", "F", "F", "F", "F", "F", "F", "F", "F", 
              "t", "t", "F", "chi", "F", "F", "t", "t", "t", "t", "F", 
              "F", "F", "t", "t", "t", "F", "F", "F", "t", "chi", "F", 
              "t", "F", "F", "F", "t", "t", "F", "F", "t", "F", "F", "t", 
              "F", "t", "F", "F", "F", "F", "F", "t", "F", "F", "F", "t", 
              "chi", "F", "chi", "chi", "F", "F", "F", "F", "t", "t", "F", 
              "F", "t", "F", "F", "F", "chi", "F", "F", "r", "t", "F", 
              "chi", "F", "t", "F", "t", "F", "t", "F", "F", "F", "F", 
              "F", "F", "F", "F", "F", "F", "F", "t", "t", "t", "F", "t", 
              "F", "t", "r", "F", "F", "F", "t", "t", "F", "t", "t", "F", 
              "F", "F", "F", "F", "F", "t", "t", "t", "F", "F", "F", "t", 
              "F", "F", "F", "F", "F", "F", "t", "F", "t", "t", "F", "F", 
              "chi", "F", "t", "t", "F", "F", "t", "F", "F", "F", "t", 
              "F", "F", "chi", "r", "F", "F", "t", "t", "F", "t", "F", 
              "F", "F", "F", "t", "F", "F", "F", "F", "F", "F", "F", "F", 
              "F", "F", "F", "F", "t", "F", "t", "t", "F", "r", "t", "t", 
              "F", "F", "F", "F", "F", "F", "F", "F", "t", "F", "t", "F", 
              "F", "F", "t", "t", "F", "t", "chi", "F", "t", "t", "F", 
              "t", "t", "F", "F", "chi", "F", "F", "F", "F", "F", "F", 
              "t", "t", "F", "F", "F", "F", "t", "F", "r", "F", "F", "F", 
              "F", "t", "t", "F", "F", "F", "r", "F", "F", "F", "chi", 
              "t", "r", "r", "F", "F", "F", "F", "F", "chi", "t", "F", 
              "F", "chi", "t", "F", "F", "F", "t", "F", "F", "t", "F", 
              "t", "t", "t", "t", "F", "F", "F", "F", "F", "F", "F", "t", 
              "F", "t", "F", "t", "F", "F", "F", "F", "F", "t", "F", "F", 
              "t", "F", "t", "F", "F", "chi", "F", "F", "F", "F", "chi", 
              "F", "F", "F", "F", "chi", "t", "t", "t", "t", "F", "r", 
              "F", "t", "F", "F", "F", "F", "F", "F", "F", "t", "t", "F", 
              "F", "F", "F", "t", "F", "F", "F", "F", "t", "F", "F", "F", 
              "F", "F", "t", "t", "F", "F", "F", "chi", "F", "t", "F", 
              "F", "F", "F", "F", "F", "F", "F", "t", "F", "F", "F", "F", 
              "F", "F", "F", "F", "F", "t", "F", "F", "F", "F", "F", "F", 
              "t", "t", "F", "F", "chi", "t", "F", "t", "F", "t", "t", 
              "F", "t", "F", "F", "F", "F", "F", "t", "F", "t", "F", "F", 
              "chi", "chi", "F", "F", "F", "F", "t", "t", "F", "F", "t", 
              "t", "t", "F", "F", "F", "F", "F", "F", "F", "F", "F", "F", 
              "t", "F", "F", "F", "F", "F", "t", "t", "F", "t", "F", "F", 
              "F", "F", "F", "F", "F", "F", "F", "t", "chi", "t", "F", 
              "chi", "F", "t", "F", "F", "F", "F", "F", "F", "F", "F", 
              "F", "t", "F", "t", "F", "F", "F", "F", "F", "F", "chi", 
              "F", "F", "F", "t", "t", "t", "t", "F", "t", "t", "r", "t", 
              "F", "F", "t", "F", "chi", "F", "t", "chi", "F", "r", "F", 
              "F", "F", "r", "F", "F", "t", "F", "t", "F", "F", "F", "chi", 
              "chi", "F", "F", "F", "chi", "F", "chi", "chi", "chi", "F", 
              "F", "t", "F", "F", "chi", "F", "t", "t", "t", "t", "t", 
              "r", "F", "F", "F", "F", "F", "t", "t", "F", "F", "F", "F", 
              "t", "F", "chi", "t", "F", "r", "t", "F", "t", "F", "F", 
              "F", "t", "chi", "t", "F", "t", "chi", "t", "F", "F", "F", 
              "F", "F", "F", "t", "F", "F", "F", "F", "F", "t", "F", "F", 
              "t", "t", "F", "F", "t", "F", "chi", "F", "F", "F", "F", 
              "t", "F", "F", "chi", "t", "chi", "F", "t", "F", "F", "t", 
              "t", "t", "F", "F", "F", "chi", "t", "F", "F", "t", "F", 
              "F", "t", "F", "F", "chi", "F", "r", "F", "F", "F", "t", 
              "F", "F", "r", "t", "chi", "t", "t", "t", "F", "F", "F", 
              "F", "t", "t", "chi", "F", "t", "t", "t", "chi", "F", "F", 
              "F", "F", "F", "t", "t", "F", "t", "r", "F", "F", "t", "F", 
              "F", "F", "F", "t", "F", "F", "F", "F", "t", "t", "t", "F", 
              "F", "F", "F", "t", "F", "F", "t", "F", "F", "F", "F", "t", 
              "F", "F", "F", "chi", "F", "F", "F", "t", "F", "F", "F", 
              "chi", "F", "F", "F", "F", "F", "r", "t", "t", "F", "F", 
              "F", "F", "F", "t", "F", "F", "F", "chi", "F", "t", "F", 
              "F", "F", "F", "F", "F", "F", "t", "t", "t", "F", "t", "t", 
              "t", "t", "F", "F", "F", "t", "F", "F", "F", "F", "t", "F", 
              "F", "F", "F", "chi", "t", "chi", "t", "F", "F", "F", "F", 
              "chi", "F", "t", "t", "t", "t", "F", "t", "F", "F", "t", 
              "t", "t", "F", "t", "F", "F", "t", "F", "t", "chi", "F", 
              "F", "t", "t", "F", "F", "F", "F", "t", "F", "F", "F", "F", 
              "t", "F", "F", "F", "t", "F", "r", "t", "F", "F", "F", "t", 
              "F", "F", "F", "t", "F", "F", "chi", "F", "F", "chi", "F", 
              "t", "F", "F", "t", "t", "F", "F", "F", "F", "t", "F", "F", 
              "F", "F", "t", "F", "F", "F", "F", "F", "F", "t", "F", "F", 
              "chi", "F", "F", "F", "t", "F", "F", "F", "F", "F", "F", 
              "F", "F", "F", "t", "F", "F", "F", "F", "F", "t", "t", "F", 
              "t", "r", "F", "t", "F", "F", "r", "F", "F", "t", "r", "F", 
              "t", "t"), journalID = c("BMC Neuroscience", "Health and Quality of Life Outcomes", 
                                       "BMC Neuroscience", "Annals of General Hospital Psychiatry", 
                                       "Behavioral and Brain Functions", "Behavioral and Brain Functions", 
                                       "Behavioral and Brain Functions", "Behavioral and Brain Functions", 
                                       "BMC Neuroscience", "BMC Neuroscience", "BMC Neuroscience", 
                                       "Substance Abuse Treatment, Prevention, and Policy", "Substance Abuse Treatment, Prevention, and Policy", 
                                       "BMC Neuroscience", "BMC Psychiatry", "BMC Psychiatry", "BMC Psychiatry", 
                                       "Behavioral and Brain Functions", "International Journal of Mental Health Systems", 
                                       "BMC Neuroscience", "BMC Neuroscience", "BMC Neuroscience", 
                                       "BMC Psychiatry", "Brain", "Behavioral and Brain Functions", 
                                       "BMC Neuroscience", "BMC Psychiatry", "Journal of Neurophysiology", 
                                       "The International Journal of Behavioral Nutrition and Physical Activity", 
                                       "BMC Neuroscience", "Behavioral and Brain Functions", "Behavioral and Brain Functions", 
                                       "The International Journal of Behavioral Nutrition and Physical Activity", 
                                       "Neuropsychopharmacology", "Neuropsychopharmacology", "BMC Neuroscience", 
                                       "Neuropsychopharmacology", "BMC Psychiatry", "BMC Psychiatry", 
                                       "Neuropsychopharmacology", "BMC Neuroscience", "BMC Neuroscience", 
                                       "BMC Neuroscience", "Behavioral and Brain Functions", "BMC Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Indian Journal of Psychiatry", "BMC Neuroscience", "Behavioral and Brain Functions", 
                                       "BMC Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Behavioral and Brain Functions", 
                                       "Behavioral and Brain Functions", "Neuropsychopharmacology", 
                                       "Frontiers in Integrative Neuroscience", "BMC Neuroscience", 
                                       "Psychiatry Investigation", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Behavioural Neurology", "BMC Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "Schizophrenia Bulletin", "Schizophrenia Bulletin", "Behavioral and Brain Functions", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "BMC Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Advances in Cognitive Psychology", "Advances in Cognitive Psychology", 
                                       "Advances in Cognitive Psychology", "Advances in Cognitive Psychology", 
                                       "Journal of Neurophysiology", "Child and Adolescent Psychiatry And Mental Health", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Integrative Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Behavioral and Brain Functions", 
                                       "Indian Journal of Psychiatry", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Integrative Neuroscience", 
                                       "Behavioral and Brain Functions", "BMC Neuroscience", "Indian Journal of Psychiatry", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Advances in Cognitive Psychology", "Advances in Cognitive Psychology", 
                                       "BMC Neuroscience", "Frontiers in Human Neuroscience", "BMC Neuroscience", 
                                       "Indian Journal of Psychiatry", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Substance Abuse Treatment, Prevention, and Policy", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "BMC Psychiatry", "Frontiers in Human Neuroscience", "Frontiers in Integrative Neuroscience", 
                                       "BMC Neuroscience", "The International Journal of Behavioral Nutrition and Physical Activity", 
                                       "Health and Quality of Life Outcomes", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychiatry", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "The International Journal of Behavioral Nutrition and Physical Activity", 
                                       "Frontiers in Behavioral Neuroscience", "Schizophrenia Bulletin", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychiatry", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "BMC Neuroscience", "The International Journal of Behavioral Nutrition and Physical Activity", 
                                       "Frontiers in Behavioral Neuroscience", "Journal of Pediatric Psychology", 
                                       "Current Neuropharmacology", "Depression Research and Treatment", 
                                       "Frontiers in Psychology", "Health and Quality of Life Outcomes", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Behavioral and Brain Functions", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychiatry", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Advances in Cognitive Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Integrative Neuroscience", 
                                       "Frontiers in Psychology", "Neuropsychopharmacology", "Frontiers in Psychology", 
                                       "Journal of Neurophysiology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "BMC Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "BMC Psychiatry", "BMC Psychiatry", 
                                       "Frontiers in Behavioral Neuroscience", "Depression Research and Treatment", 
                                       "Frontiers in Psychology", "Brain", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Depression Research and Treatment", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychiatry", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Psychiatry Investigation", "Frontiers in Psychology", "BMC Neuroscience", 
                                       "Translational Psychiatry", "Translational Psychiatry", "Frontiers in Psychology", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "BMC Psychiatry", "BMC Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychiatry", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychiatry", "Behavioral and Brain Functions", 
                                       "Behavioral and Brain Functions", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Integrative Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychiatry", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychiatry", "Frontiers in Psychology", "Behavioral and Brain Functions", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Journal of Neurophysiology", "BMC Neuroscience", "Translational Psychiatry", 
                                       "Translational Psychiatry", "Translational Psychiatry", "Substance Abuse: Research and Treatment", 
                                       "Frontiers in Psychology", "Health and Quality of Life Outcomes", 
                                       "BMC Medical Education", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Integrative Neuroscience", "Substance Abuse: Research and Treatment", 
                                       "Frontiers in Psychology", "Advances in Cognitive Psychology", 
                                       "Advances in Cognitive Psychology", "Frontiers in Integrative Neuroscience", 
                                       "Frontiers in Psychiatry", "Frontiers in Psychology", "Neuropsychopharmacology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Integrative Neuroscience", 
                                       "Behavioural Neurology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Journal of Visualized Experiments", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Integrative Neuroscience", "Neuropsychopharmacology", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Brain and Behavior", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "BMC Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Behavioral and Brain Functions", "Behavioral and Brain Functions", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Depression Research and Treatment", 
                                       "BMC Psychiatry", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "BMC Neuroscience", "BMC Neuroscience", 
                                       "BMC Psychiatry", "Behavioral and Brain Functions", "Behavioral and Brain Functions", 
                                       "Frontiers in Psychology", "BMC Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Substance Abuse Treatment, Prevention, and Policy", 
                                       "Translational Psychiatry", "Translational Psychiatry", "Behavioral and Brain Functions", 
                                       "Behavioral and Brain Functions", "Frontiers in Psychology", 
                                       "Translational Psychiatry", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Translational Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Journal of Undergraduate Neuroscience Education", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "BMC Psychiatry", "BMC Psychiatry", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "BMC Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Translational Psychiatry", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Journal of Neurophysiology", "Neuropsychopharmacology", 
                                       "Neuropsychopharmacology", "Frontiers in Psychiatry", "Frontiers in Aging Neuroscience", 
                                       "Child and Adolescent Psychiatry And Mental Health", "ISRN Psychiatry", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychiatry", "Behavioral and Brain Functions", 
                                       "Behavioral and Brain Functions", "Frontiers in Human Neuroscience", 
                                       "Neuropsychopharmacology", "Social Cognitive and Affective Neuroscience", 
                                       "Frontiers in Psychiatry", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Translational Psychiatry", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Advances in Cognitive Psychology", "Advances in Cognitive Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "BMC Neuroscience", "BMC Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychiatry", "Frontiers in Psychiatry", 
                                       "Frontiers in Human Neuroscience", "Translational Psychiatry", 
                                       "BMC Psychiatry", "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "BMC Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Translational Psychiatry", "Frontiers in Human Neuroscience", 
                                       "Neuroimage : Clinical", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychiatry", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Neuroimage : Clinical", "Neuroimage : Clinical", "Frontiers in Integrative Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Advances in Cognitive Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Schizophrenia Bulletin", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Behavioral and Brain Functions", "Frontiers in Integrative Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychiatry", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "BMC Psychiatry", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "BMC Neuroscience", "Frontiers in Integrative Neuroscience", 
                                       "Frontiers in Psychology", "BMC Psychiatry", "Frontiers in Psychology", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Integrative Neuroscience", 
                                       "Neuroimage : Clinical", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Behavioral and Brain Functions", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Integrative Neuroscience", "BMC Neuroscience", 
                                       "BMC Psychiatry", "Behavioral and Brain Functions", "Behavioral and Brain Functions", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "BMC Psychiatry", "Advances in Cognitive Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Addiction & Health", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Depression Research and Treatment", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Behavioral and Brain Functions", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "BMC Neuroscience", "Frontiers in Psychiatry", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Behavioral and Brain Functions", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Socioaffective Neuroscience & Psychology", "Socioaffective Neuroscience & Psychology", 
                                       "Socioaffective Neuroscience & Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Translational Psychiatry", 
                                       "Brain and Behavior", "Brain and Behavior", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "BMC Psychiatry", "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Behavioral and Brain Functions", 
                                       "BMC Psychiatry", "Neuropsychopharmacology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Advances in Cognitive Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Behavioural Neurology", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Translational Psychiatry", "Translational Psychiatry", "BMC Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "BMC Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Integrative Neuroscience", 
                                       "BMC Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "BMC Neuroscience", "Frontiers in Psychology", "Neuroimage : Clinical", 
                                       "Neuroimage : Clinical", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Health and Quality of Life Outcomes", "Frontiers in Psychology", 
                                       "Brain Sciences", "Brain Sciences", "Brain Sciences", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Translational Psychiatry", "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Journal of Eating Disorders", "Journal of Eating Disorders", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "BMC Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Brain and Behavior", "Brain and Behavior", 
                                       "Brain and Behavior", "Brain", "Brain", "Frontiers in Human Neuroscience", 
                                       "Neuroimage : Clinical", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Advances in Cognitive Psychology", 
                                       "Advances in Cognitive Psychology", "Advances in Cognitive Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Child and Adolescent Psychiatry And Mental Health", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Psychology Research and Behavior Management", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "BMC Psychiatry", "Frontiers in Psychiatry", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Schizophrenia Bulletin", "Brain Sciences", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychiatry", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Translational Psychiatry", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "BMC Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "International Journal of Medical Education", "Behavioral Sciences", 
                                       "Behavioral Sciences", "BMC Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Psychological Science", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychiatry", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Social Cognitive and Affective Neuroscience", 
                                       "Mental Illness", "Mental Illness", "Mental Illness", "Frontiers in Human Neuroscience", 
                                       "Journal of Neurophysiology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "BMC Neuroscience", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Translational Psychiatry", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Brain Sciences", 
                                       "Brain Sciences", "International Journal of Medical Education", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "BMC Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Behavioral Sciences", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Neuroimage : Clinical", "Frontiers in Integrative Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "BMC Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "The International Journal of Behavioral Nutrition and Physical Activity", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Integrative Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Translational Psychiatry", 
                                       "Translational Psychiatry", "Frontiers in Psychology", "Frontiers in Psychiatry", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "BMC Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Translational Psychiatry", "Translational Psychiatry", "Translational Psychiatry", 
                                       "Translational Psychiatry", "Frontiers in Psychology", "Annals of General Psychiatry", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Substance Abuse Treatment, Prevention, and Policy", "BMC Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychiatry", "Journal of Eating Disorders", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Neuroscience Journal", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Translational Psychiatry", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "International Journal of Bipolar Disorders", 
                                       "International Journal of Bipolar Disorders", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Health and Quality of Life Outcomes", 
                                       "Translational Psychiatry", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Neuroimage : Clinical", "Neuroimage : Clinical", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychiatry", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Neuropsychopharmacology", "The International Journal of Behavioral Nutrition and Physical Activity", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychiatry", 
                                       "Translational Psychiatry", "Translational Psychiatry", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Brain Sciences", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "BMC Medical Education", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Psychological Science", "Psychological Science", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Psychologica Belgica", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "BMC Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Journal of Eating Disorders", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Translational Psychiatry", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Borderline Personality Disorder and Emotion Dysregulation", 
                                       "Borderline Personality Disorder and Emotion Dysregulation", 
                                       "Borderline Personality Disorder and Emotion Dysregulation", 
                                       "Neuropsychopharmacology", "Child and Adolescent Psychiatry And Mental Health", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Social Cognitive and Affective Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "BMC Neuroscience", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Social Cognitive and Affective Neuroscience", 
                                       "Neuroimage : Clinical", "Frontiers in Psychology", "Socioaffective Neuroscience & Psychology", 
                                       "Substance Abuse Treatment, Prevention, and Policy", "Frontiers in Psychology", 
                                       "BMC Psychiatry", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Neuropsychopharmacology", 
                                       "Neuropsychopharmacology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychiatry", "Frontiers in Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Behavioral Sciences", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Neurobiology of Stress", 
                                       "Brain Sciences", "Brain Sciences", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "JMIR Mhealth and Uhealth", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Neurobiology of Stress", "Frontiers in Psychology", "Social Cognitive and Affective Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "The International Journal of Behavioral Nutrition and Physical Activity", 
                                       "BMC Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Health Psychology Research", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "BMC Medical Education", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Integrative Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "JMIR Human Factors", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Journal of Neurophysiology", 
                                       "Journal of Neurophysiology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Neuroimage : Clinical", "Neuroimage : Clinical", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Neuropsychopharmacology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Schizophrenia Bulletin", "Neuropsychopharmacology", "Frontiers in Psychology", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "The Journal of Neuroscience", "The Journal of Neuroscience", 
                                       "BMC Psychiatry", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Addictive Behaviors Reports", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Neuropsychopharmacology", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychiatry", "Frontiers in Human Neuroscience", 
                                       "Translational Psychiatry", "Translational Psychiatry", "Europe's Journal of Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Integrative Neuroscience", "Borderline Personality Disorder and Emotion Dysregulation", 
                                       "Frontiers in Behavioral Neuroscience", "Brain and Behavior", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Brain and Behavior", "Frontiers in Behavioral Neuroscience", 
                                       "JMIR Mental Health", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Health and Quality of Life Outcomes", 
                                       "Frontiers in Psychiatry", "Frontiers in Psychiatry", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Indian Journal of Psychiatry", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Journal of Neurophysiology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Behavioral Sciences", "Translational Psychiatry", 
                                       "Translational Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "BMC Psychiatry", "BMC Psychiatry", 
                                       "BMC Psychiatry", "JMIR Mhealth and Uhealth", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Brain", "BMC Psychiatry", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "JMIR Serious Games", 
                                       "JMIR Serious Games", "Frontiers in Human Neuroscience", 
                                       "BMC Psychiatry", "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Journal of Neurophysiology", "Brain and Behavior", "Frontiers in Psychology", 
                                       "Borderline Personality Disorder and Emotion Dysregulation", 
                                       "Frontiers in Psychology", "BMC Medical Education", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Health and Quality of Life Outcomes", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Psychology Research and Behavior Management", 
                                       "Frontiers in Aging Neuroscience", "Neuropsychopharmacology", 
                                       "Neuropsychopharmacology", "Neuropsychopharmacology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Neuroimage : Clinical", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Brain Sciences", "Social Cognitive and Affective Neuroscience", 
                                       "Psychology Research and Behavior Management", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "International Journal of Medical Education", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Translational Psychiatry", "Translational Psychiatry", "Translational Psychiatry", 
                                       "Translational Psychiatry", "Translational Psychiatry", "Translational Psychiatry", 
                                       "Translational Psychiatry", "JMIR Mhealth and Uhealth", "Frontiers in Behavioral Neuroscience", 
                                       "Translational Psychiatry", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "BMC Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Neuropsychopharmacology", "Brain and Behavior", 
                                       "Brain and Behavior", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Neuroimage : Clinical", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Neurobiology of Stress", "The Journal of Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "JMIR Serious Games", 
                                       "Frontiers in Behavioral Neuroscience", "Brain Sciences", 
                                       "Brain Sciences", "Behavioural Neurology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Neuroimage : Clinical", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Integrative Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychiatry", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Advances in Cognitive Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Translational Psychiatry", "Translational Psychiatry", "Frontiers in Human Neuroscience", 
                                       "Behavioural Neurology", "Behavioural Neurology", "Behavioural Neurology", 
                                       "Translational Psychiatry", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Substance Abuse Treatment, Prevention, and Policy", 
                                       "Journal of Eating Disorders", "Frontiers in Psychology", 
                                       "Translational Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Brain Sciences", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Neuroimage : Clinical", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Brain and Behavior", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Neuroimage : Clinical", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Health and Quality of Life Outcomes", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychiatry", "Indian Journal of Psychological Medicine", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Social Cognitive and Affective Neuroscience", 
                                       "Social Cognitive and Affective Neuroscience", "BMC Psychiatry", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Substance Abuse: Research and Treatment", 
                                       "Advances in Cognitive Psychology", "Advances in Cognitive Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Brain", "Advances in Cognitive Psychology", "Neurobiology of Stress", 
                                       "Neurobiology of Stress", "Neurobiology of Stress", "Neurobiology of Stress", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Translational Psychiatry", "Translational Psychiatry", "Translational Psychiatry", 
                                       "Translational Psychiatry", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "BMC Psychiatry", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Neuroimage : Clinical", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Health Psychology Open", 
                                       "Frontiers in Psychiatry", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "NPJ Schizophrenia", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "BMC Psychiatry", 
                                       "Frontiers in Psychology", "Social Cognitive and Affective Neuroscience", 
                                       "Social Cognitive and Affective Neuroscience", "Social Cognitive and Affective Neuroscience", 
                                       "Social Cognitive and Affective Neuroscience", "Social Cognitive and Affective Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychiatry", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Brain and Behavior", "Brain and Behavior", 
                                       "Brain and Behavior", "Behavioural Neurology", "Frontiers in Psychology", 
                                       "Neuroimage : Clinical", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Brain Sciences", "Addiction Science & Clinical Practice", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "The Journal of Neuroscience", 
                                       "The Journal of Neuroscience", "Neuroimage : Clinical", "BMC Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Borderline Personality Disorder and Emotion Dysregulation", 
                                       "Frontiers in Psychology", "BMC Psychiatry", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Schizophrenia Research: Cognition", 
                                       "Neuropsychopharmacology", "Behavioural Neurology", "Behavioural Neurology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Schizophrenia Research: Cognition", "Social Cognitive and Affective Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Brain Sciences", "Frontiers in Psychiatry", 
                                       "Social Cognitive and Affective Neuroscience", "Translational Psychiatry", 
                                       "Journal of Neurophysiology", "Frontiers in Psychology", 
                                       "BMC Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Translational Psychiatry", "Frontiers in Integrative Neuroscience", 
                                       "The Journal of Neuroscience", "International Journal of Bipolar Disorders", 
                                       "Frontiers in Behavioral Neuroscience", "The Journal of Neuroscience", 
                                       "Psychology Research and Behavior Management", "International Journal of Medical Education", 
                                       "Frontiers in Psychology", "Europe's Journal of Psychology", 
                                       "Frontiers in Psychiatry", "BMC Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Brain and Behavior", 
                                       "Frontiers in Psychology", "Translational Psychiatry", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Behavioral Sciences", 
                                       "Schizophrenia Research: Cognition", "Frontiers in Psychology", 
                                       "Frontiers in Psychiatry", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Social Cognitive and Affective Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Advances in Cognitive Psychology", "Advances in Cognitive Psychology", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Social Cognitive and Affective Neuroscience", 
                                       "Social Cognitive and Affective Neuroscience", "Neuroimage : Clinical", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Brain : A Journal of Neurology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Journal of Neurophysiology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychiatry", "Brain and Behavior", "Brain and Behavior", 
                                       "Journal of Eating Disorders", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Neuroimage : Clinical", 
                                       "Neurobiology of Stress", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Social Cognitive and Affective Neuroscience", 
                                       "Social Cognitive and Affective Neuroscience", "Social Cognitive and Affective Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Journal of Eating Disorders", 
                                       "BMC Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "BMC Psychiatry", 
                                       "BMC Psychiatry", "Frontiers in Human Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Neuropsychopharmacology", "Frontiers in Psychology", "BMC Psychiatry", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychiatry", 
                                       "Schizophrenia Research: Cognition", "Schizophrenia Research: Cognition", 
                                       "Schizophrenia Research: Cognition", "Health Psychology Open", 
                                       "Health Psychology Open", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Neuroimage : Clinical", 
                                       "Neuroimage : Clinical", "Social Cognitive and Affective Neuroscience", 
                                       "Social Cognitive and Affective Neuroscience", "Indian Journal of Psychological Medicine", 
                                       "Indian Journal of Psychological Medicine", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Addictive Behaviors Reports", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Translational Psychiatry", "Translational Psychiatry", "Frontiers in Psychology", 
                                       "Frontiers in Psychiatry", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Health and Quality of Life Outcomes", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "NPJ Schizophrenia", "The Journal of Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "BMC Psychology", "Frontiers in Psychology", "International Journal of Medical Education", 
                                       "Frontiers in Behavioral Neuroscience", "Brain Sciences", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Brain", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Behavioral and Brain Functions", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Addictive Behaviors Reports", "Psychologica Belgica", "Frontiers in Psychology", 
                                       "Psychologica Belgica", "Frontiers in Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "BMC Medical Education", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Brain Connectivity", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "JMIR Serious Games", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Schizophrenia Bulletin", "Schizophrenia Bulletin", 
                                       "Schizophrenia Bulletin", "Schizophrenia Bulletin", "Frontiers in Psychology", 
                                       "Brain Informatics", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Psychiatry Investigation", 
                                       "Schizophrenia Bulletin", "The Journal of Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Brain", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychiatry", "Social Cognitive and Affective Neuroscience", 
                                       "Social Cognitive and Affective Neuroscience", "Frontiers in Psychiatry", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Human Neuroscience", "BMC Psychiatry", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Health and Quality of Life Outcomes", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Translational Psychiatry", "Translational Psychiatry", "The Journal of Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Brain", "Frontiers in Psychology", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Brain Sciences", "Frontiers in Psychology", 
                                       "Frontiers in Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Brain and Behavior", 
                                       "Brain and Behavior", "Translational Psychiatry", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Psychology", "BMC Neuroscience", "Frontiers in Integrative Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychiatry", "Neuroscience of Consciousness", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Psychology", 
                                       "Europe's Journal of Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychiatry", "Frontiers in Psychology", 
                                       "Brain", "Frontiers in Human Neuroscience", "Journal of Eating Disorders", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychiatry", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "BMC Neuroscience", "BJPsych Bulletin", "BMC Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "NPJ Schizophrenia", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Health and Quality of Life Outcomes", 
                                       "Behavioural Neurology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Brain Sciences", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Brain and Behavior", 
                                       "Brain and Behavior", "Brain and Behavior", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Ibro Reports", "Frontiers in Human Neuroscience", "Neuropsychopharmacology", 
                                       "Frontiers in Integrative Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Brain Sciences", "Social Cognitive and Affective Neuroscience", 
                                       "Social Cognitive and Affective Neuroscience", "Social Cognitive and Affective Neuroscience", 
                                       "Frontiers in Psychology", "The Journal of Neuroscience", 
                                       "The Journal of Neuroscience", "Journal of Visualized Experiments", 
                                       "Frontiers in Human Neuroscience", "International Journal of Medical Education", 
                                       "International Journal of Medical Education", "Frontiers in Psychiatry", 
                                       "Frontiers in Psychology", "Behavioural Neurology", "Frontiers in Psychiatry", 
                                       "Frontiers in Psychology", "Psychology Research and Behavior Management", 
                                       "Frontiers in Psychology", "Europe's Journal of Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Psychology", 
                                       "Translational Psychiatry", "Translational Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "BJPsych Open", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Translational Psychiatry", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "BMC Neuroscience", "Frontiers in Psychology", 
                                       "Psychologica Belgica", "Psychologica Belgica", "Frontiers in Psychology", 
                                       "Translational Psychiatry", "Frontiers in Psychiatry", "Social Cognitive and Affective Neuroscience", 
                                       "Social Cognitive and Affective Neuroscience", "Frontiers in Aging Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Behavioral and Brain Functions", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Social Cognitive and Affective Neuroscience", "Social Cognitive and Affective Neuroscience", 
                                       "JMIR Serious Games", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Human Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Behavioral Neuroscience", "Frontiers in Human Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Annals of General Psychiatry", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Europe's Journal of Psychology", 
                                       "Frontiers in Psychiatry", "Frontiers in Behavioral Neuroscience", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Social Cognitive and Affective Neuroscience", 
                                       "Frontiers in Psychiatry", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Aging Neuroscience", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Psychology", 
                                       "Frontiers in Psychology", "Frontiers in Psychology", "Frontiers in Human Neuroscience", 
                                       "BMC Psychiatry")), row.names = c(1L, 2L, 3L, 4L, 5L, 6L, 
                                                                         7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 
                                                                         20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L, 30L, 31L, 32L, 
                                                                         33L, 34L, 35L, 36L, 37L, 38L, 39L, 40L, 41L, 42L, 43L, 44L, 45L, 
                                                                         46L, 47L, 48L, 49L, 50L, 51L, 52L, 53L, 54L, 55L, 56L, 57L, 58L, 
                                                                         59L, 60L, 61L, 62L, 63L, 64L, 65L, 66L, 67L, 68L, 69L, 70L, 71L, 
                                                                         72L, 73L, 74L, 75L, 76L, 77L, 78L, 79L, 80L, 81L, 82L, 83L, 84L, 
                                                                         85L, 86L, 87L, 88L, 89L, 90L, 91L, 92L, 93L, 94L, 95L, 96L, 97L, 
                                                                         98L, 99L, 100L, 101L, 102L, 103L, 104L, 105L, 106L, 107L, 108L, 
                                                                         109L, 110L, 111L, 112L, 113L, 114L, 115L, 116L, 117L, 118L, 119L, 
                                                                         120L, 121L, 122L, 123L, 124L, 125L, 126L, 127L, 128L, 129L, 130L, 
                                                                         131L, 132L, 133L, 134L, 135L, 136L, 137L, 138L, 139L, 140L, 141L, 
                                                                         142L, 143L, 144L, 145L, 146L, 147L, 148L, 149L, 150L, 151L, 152L, 
                                                                         153L, 154L, 155L, 156L, 157L, 158L, 159L, 160L, 161L, 162L, 163L, 
                                                                         164L, 165L, 166L, 167L, 168L, 169L, 170L, 171L, 172L, 173L, 174L, 
                                                                         176L, 177L, 178L, 179L, 180L, 181L, 182L, 183L, 184L, 185L, 186L, 
                                                                         187L, 188L, 189L, 190L, 191L, 192L, 193L, 194L, 195L, 196L, 197L, 
                                                                         198L, 199L, 200L, 201L, 202L, 203L, 204L, 205L, 206L, 207L, 208L, 
                                                                         209L, 210L, 211L, 212L, 213L, 214L, 215L, 216L, 217L, 218L, 219L, 
                                                                         220L, 221L, 222L, 223L, 224L, 225L, 226L, 227L, 228L, 229L, 230L, 
                                                                         231L, 232L, 233L, 234L, 235L, 236L, 237L, 238L, 239L, 240L, 241L, 
                                                                         242L, 243L, 244L, 245L, 246L, 247L, 248L, 249L, 250L, 251L, 252L, 
                                                                         253L, 254L, 255L, 256L, 257L, 258L, 259L, 260L, 261L, 262L, 263L, 
                                                                         264L, 265L, 266L, 267L, 268L, 269L, 270L, 271L, 272L, 273L, 274L, 
                                                                         275L, 276L, 277L, 278L, 279L, 280L, 281L, 282L, 283L, 284L, 285L, 
                                                                         286L, 287L, 288L, 289L, 290L, 291L, 292L, 293L, 294L, 295L, 296L, 
                                                                         297L, 298L, 299L, 300L, 301L, 302L, 303L, 304L, 305L, 306L, 307L, 
                                                                         308L, 309L, 310L, 311L, 312L, 313L, 314L, 315L, 316L, 317L, 318L, 
                                                                         319L, 320L, 321L, 322L, 323L, 324L, 325L, 326L, 327L, 328L, 329L, 
                                                                         330L, 331L, 332L, 333L, 334L, 335L, 336L, 337L, 338L, 339L, 340L, 
                                                                         341L, 342L, 343L, 344L, 345L, 346L, 347L, 348L, 349L, 350L, 351L, 
                                                                         352L, 353L, 354L, 355L, 356L, 357L, 358L, 359L, 360L, 361L, 362L, 
                                                                         363L, 364L, 365L, 366L, 367L, 368L, 369L, 370L, 371L, 372L, 373L, 
                                                                         374L, 375L, 376L, 377L, 378L, 379L, 380L, 381L, 382L, 383L, 384L, 
                                                                         385L, 386L, 387L, 388L, 389L, 390L, 391L, 392L, 393L, 394L, 395L, 
                                                                         396L, 397L, 398L, 399L, 400L, 401L, 402L, 403L, 404L, 405L, 406L, 
                                                                         407L, 408L, 409L, 410L, 411L, 412L, 413L, 414L, 415L, 416L, 417L, 
                                                                         418L, 419L, 420L, 421L, 422L, 423L, 424L, 425L, 426L, 427L, 428L, 
                                                                         429L, 430L, 431L, 432L, 433L, 434L, 435L, 436L, 437L, 438L, 439L, 
                                                                         440L, 441L, 442L, 443L, 444L, 445L, 446L, 447L, 448L, 449L, 450L, 
                                                                         451L, 452L, 453L, 454L, 455L, 456L, 457L, 458L, 459L, 460L, 461L, 
                                                                         462L, 463L, 464L, 465L, 466L, 467L, 468L, 469L, 470L, 471L, 472L, 
                                                                         473L, 474L, 475L, 476L, 477L, 478L, 479L, 480L, 481L, 482L, 483L, 
                                                                         484L, 485L, 486L, 487L, 488L, 489L, 490L, 491L, 492L, 493L, 494L, 
                                                                         495L, 496L, 497L, 498L, 499L, 500L, 501L, 502L, 503L, 504L, 505L, 
                                                                         506L, 507L, 508L, 509L, 510L, 511L, 512L, 513L, 514L, 515L, 516L, 
                                                                         517L, 518L, 519L, 520L, 521L, 522L, 523L, 524L, 525L, 526L, 527L, 
                                                                         528L, 529L, 530L, 531L, 532L, 533L, 534L, 535L, 536L, 537L, 538L, 
                                                                         539L, 540L, 541L, 542L, 543L, 544L, 545L, 546L, 547L, 548L, 549L, 
                                                                         550L, 551L, 552L, 553L, 554L, 555L, 556L, 557L, 558L, 559L, 560L, 
                                                                         561L, 562L, 563L, 564L, 565L, 566L, 567L, 568L, 569L, 570L, 571L, 
                                                                         572L, 573L, 574L, 575L, 576L, 577L, 578L, 579L, 580L, 581L, 582L, 
                                                                         583L, 584L, 585L, 586L, 587L, 588L, 589L, 590L, 591L, 592L, 593L, 
                                                                         594L, 595L, 596L, 597L, 598L, 599L, 600L, 601L, 602L, 603L, 604L, 
                                                                         605L, 606L, 607L, 608L, 609L, 610L, 611L, 612L, 613L, 614L, 615L, 
                                                                         616L, 617L, 618L, 619L, 620L, 621L, 622L, 623L, 624L, 625L, 626L, 
                                                                         627L, 628L, 629L, 630L, 631L, 632L, 633L, 634L, 635L, 636L, 637L, 
                                                                         638L, 639L, 640L, 641L, 642L, 643L, 644L, 645L, 646L, 647L, 648L, 
                                                                         649L, 650L, 651L, 652L, 653L, 654L, 655L, 656L, 657L, 658L, 659L, 
                                                                         660L, 661L, 662L, 663L, 664L, 665L, 666L, 667L, 668L, 669L, 670L, 
                                                                         671L, 672L, 673L, 674L, 675L, 676L, 677L, 678L, 679L, 680L, 681L, 
                                                                         682L, 683L, 684L, 685L, 686L, 687L, 688L, 689L, 690L, 691L, 692L, 
                                                                         693L, 694L, 695L, 696L, 697L, 698L, 699L, 700L, 701L, 702L, 703L, 
                                                                         704L, 705L, 706L, 707L, 708L, 709L, 710L, 711L, 712L, 713L, 714L, 
                                                                         715L, 716L, 717L, 718L, 719L, 720L, 721L, 722L, 723L, 724L, 725L, 
                                                                         726L, 727L, 728L, 729L, 730L, 731L, 732L, 733L, 734L, 735L, 736L, 
                                                                         737L, 738L, 739L, 740L, 741L, 742L, 743L, 744L, 745L, 746L, 747L, 
                                                                         748L, 749L, 750L, 751L, 752L, 753L, 754L, 755L, 756L, 757L, 758L, 
                                                                         759L, 760L, 761L, 762L, 763L, 764L, 765L, 766L, 767L, 768L, 769L, 
                                                                         770L, 771L, 772L, 773L, 774L, 775L, 776L, 777L, 778L, 779L, 780L, 
                                                                         781L, 782L, 783L, 784L, 785L, 786L, 787L, 788L, 789L, 790L, 791L, 
                                                                         792L, 793L, 794L, 796L, 797L, 798L, 799L, 800L, 801L, 802L, 803L, 
                                                                         804L, 805L, 806L, 807L, 808L, 809L, 810L, 811L, 812L, 813L, 814L, 
                                                                         815L, 816L, 817L, 818L, 819L, 820L, 821L, 822L, 823L, 824L, 825L, 
                                                                         826L, 827L, 828L, 829L, 830L, 831L, 832L, 833L, 834L, 835L, 836L, 
                                                                         837L, 838L, 839L, 840L, 841L, 842L, 843L, 844L, 845L, 846L, 847L, 
                                                                         848L, 849L, 850L, 851L, 852L, 853L, 854L, 855L, 856L, 857L, 858L, 
                                                                         859L, 860L, 861L, 862L, 863L, 864L, 865L, 866L, 867L, 868L, 869L, 
                                                                         870L, 871L, 872L, 873L, 874L, 875L, 876L, 877L, 878L, 879L, 880L, 
                                                                         881L, 882L, 883L, 884L, 885L, 886L, 889L, 890L, 891L, 892L, 893L, 
                                                                         894L, 895L, 896L, 897L, 898L, 899L, 900L, 901L, 902L, 903L, 904L, 
                                                                         905L, 906L, 907L, 908L, 909L, 910L, 911L, 912L, 913L, 914L, 915L, 
                                                                         916L, 917L, 918L, 919L, 920L, 921L, 922L, 923L, 924L, 925L, 926L, 
                                                                         927L, 928L, 929L, 930L, 931L, 932L, 933L, 934L, 935L, 936L, 937L, 
                                                                         938L, 939L, 940L, 941L, 942L, 943L, 944L, 945L, 947L, 948L, 949L, 
                                                                         950L, 951L, 952L, 953L, 954L, 955L, 956L, 957L, 958L, 959L, 960L, 
                                                                         961L, 962L, 963L, 964L, 965L, 966L, 967L, 968L, 969L, 970L, 971L, 
                                                                         972L, 973L, 974L, 975L, 976L, 977L, 978L, 979L, 980L, 981L, 982L, 
                                                                         983L, 984L, 985L, 986L, 987L, 988L, 989L, 990L, 991L, 992L, 993L, 
                                                                         994L, 995L, 996L, 997L, 998L, 999L, 1000L, 1001L, 1002L, 1003L, 
                                                                         1004L, 1005L, 1007L, 1008L, 1009L, 1010L, 1011L, 1012L, 1013L, 
                                                                         1014L, 1015L, 1016L, 1017L, 1018L, 1019L, 1020L, 1021L, 1022L, 
                                                                         1023L, 1024L, 1025L, 1026L, 1027L, 1028L, 1029L, 1030L, 1031L, 
                                                                         1032L, 1033L, 1034L, 1035L, 1036L, 1037L, 1038L, 1039L, 1040L, 
                                                                         1041L, 1042L, 1043L, 1044L, 1045L, 1046L, 1047L, 1048L, 1049L, 
                                                                         1050L, 1051L, 1052L, 1053L, 1054L, 1055L, 1056L, 1057L, 1058L, 
                                                                         1059L, 1060L, 1061L, 1062L, 1063L, 1064L, 1065L, 1066L, 1067L, 
                                                                         1068L, 1069L, 1070L, 1071L, 1072L, 1073L, 1074L, 1075L, 1076L, 
                                                                         1077L, 1078L, 1079L, 1080L, 1081L, 1082L, 1083L, 1084L, 1085L, 
                                                                         1087L, 1088L, 1089L, 1090L, 1091L, 1092L, 1093L, 1094L, 1095L, 
                                                                         1096L, 1097L, 1098L, 1099L, 1100L, 1101L, 1102L, 1103L, 1104L, 
                                                                         1105L, 1106L, 1107L, 1108L, 1109L, 1110L, 1112L, 1113L, 1114L, 
                                                                         1115L, 1116L, 1117L, 1118L, 1119L, 1120L, 1121L, 1122L, 1123L, 
                                                                         1124L, 1125L, 1126L, 1127L, 1128L, 1129L, 1130L, 1131L, 1132L, 
                                                                         1133L, 1134L, 1135L, 1136L, 1137L, 1138L, 1139L, 1140L, 1141L, 
                                                                         1142L, 1143L, 1144L, 1145L, 1146L, 1147L, 1148L, 1149L, 1150L, 
                                                                         1151L, 1152L, 1153L, 1154L, 1155L, 1156L, 1157L, 1158L, 1159L, 
                                                                         1160L, 1161L, 1162L, 1163L, 1164L, 1165L, 1166L, 1167L, 1168L, 
                                                                         1169L, 1170L, 1171L, 1172L, 1173L, 1174L, 1175L, 1176L, 1177L, 
                                                                         1178L, 1179L, 1180L, 1181L, 1182L, 1183L, 1184L, 1185L, 1186L, 
                                                                         1187L, 1188L, 1189L, 1190L, 1191L, 1192L, 1193L, 1194L, 1195L, 
                                                                         1196L, 1197L, 1198L, 1199L, 1200L, 1201L, 1202L, 1203L, 1204L, 
                                                                         1205L, 1206L, 1207L, 1208L, 1209L, 1210L, 1211L, 1213L, 1214L, 
                                                                         1215L, 1216L, 1217L, 1218L, 1219L, 1220L, 1221L, 1222L, 1223L, 
                                                                         1224L, 1225L, 1226L, 1227L, 1228L, 1229L, 1230L, 1231L, 1232L, 
                                                                         1233L, 1234L, 1235L, 1236L, 1238L, 1239L, 1240L, 1241L, 1242L, 
                                                                         1243L, 1244L, 1245L, 1246L, 1247L, 1248L, 1249L, 1250L, 1251L, 
                                                                         1252L, 1254L, 1255L, 1256L, 1257L, 1258L, 1259L, 1260L, 1261L, 
                                                                         1262L, 1263L, 1264L, 1265L, 1266L, 1267L, 1268L, 1269L, 1270L, 
                                                                         1271L, 1272L, 1273L, 1274L, 1275L, 1276L, 1277L, 1278L, 1279L, 
                                                                         1280L, 1281L, 1282L, 1283L, 1284L, 1285L, 1286L, 1287L, 1288L, 
                                                                         1289L, 1291L, 1292L, 1293L, 1294L, 1295L, 1296L, 1297L, 1298L, 
                                                                         1299L, 1300L, 1301L, 1302L, 1303L, 1304L, 1305L, 1307L, 1308L, 
                                                                         1309L, 1310L, 1311L, 1312L, 1313L, 1314L, 1315L, 1316L, 1317L, 
                                                                         1318L, 1319L, 1320L, 1321L, 1322L, 1323L, 1324L, 1325L, 1326L, 
                                                                         1327L, 1328L, 1329L, 1330L, 1331L, 1332L, 1333L, 1334L, 1335L, 
                                                                         1336L, 1337L, 1338L, 1339L, 1340L, 1341L, 1342L, 1343L, 1344L, 
                                                                         1345L, 1346L, 1347L, 1348L, 1349L, 1350L, 1351L, 1352L, 1353L, 
                                                                         1354L, 1355L, 1356L, 1357L, 1358L, 1359L, 1360L, 1361L, 1362L, 
                                                                         1363L, 1364L, 1365L, 1366L, 1367L, 1368L, 1369L, 1370L, 1371L, 
                                                                         1372L, 1373L, 1374L, 1375L, 1376L, 1377L, 1378L, 1379L, 1380L, 
                                                                         1381L, 1382L, 1383L, 1384L, 1385L, 1386L, 1387L, 1388L, 1389L, 
                                                                         1390L, 1391L, 1392L, 1393L, 1394L, 1395L, 1396L, 1397L, 1398L, 
                                                                         1399L, 1400L, 1401L, 1402L, 1403L, 1404L, 1405L, 1406L, 1407L, 
                                                                         1408L, 1409L, 1410L, 1411L, 1412L, 1413L, 1414L, 1415L, 1416L, 
                                                                         1417L, 1418L, 1419L, 1420L, 1421L, 1422L, 1423L, 1424L, 1425L, 
                                                                         1426L, 1427L, 1429L, 1430L, 1431L, 1432L, 1433L, 1434L, 1435L, 
                                                                         1436L, 1437L, 1438L, 1439L, 1440L, 1441L, 1442L, 1443L, 1444L, 
                                                                         1445L, 1446L, 1447L, 1448L, 1449L, 1450L, 1451L, 1452L, 1453L, 
                                                                         1454L, 1455L, 1456L, 1457L, 1458L, 1459L, 1460L, 1461L, 1462L, 
                                                                         1463L, 1464L, 1465L, 1466L, 1467L, 1468L, 1469L, 1470L, 1471L, 
                                                                         1472L, 1473L, 1474L, 1475L, 1476L, 1477L, 1478L, 1479L, 1480L, 
                                                                         1481L, 1482L, 1483L, 1484L, 1485L, 1486L, 1487L, 1488L, 1489L, 
                                                                         1490L, 1491L, 1492L, 1493L, 1494L, 1495L, 1496L, 1497L, 1498L, 
                                                                         1499L, 1500L, 1501L, 1502L, 1503L, 1504L, 1505L, 1506L, 1507L, 
                                                                         1508L, 1509L, 1510L, 1511L, 1512L, 1513L, 1514L, 1515L, 1516L, 
                                                                         1517L, 1518L, 1519L, 1520L, 1521L, 1522L, 1523L, 1524L, 1525L, 
                                                                         1526L, 1527L, 1528L, 1529L, 1530L, 1531L, 1532L, 1533L, 1534L, 
                                                                         1535L, 1536L, 1537L, 1538L, 1539L, 1540L, 1541L, 1542L, 1543L, 
                                                                         1544L, 1545L, 1546L, 1547L, 1548L, 1549L, 1550L, 1551L, 1552L, 
                                                                         1553L, 1554L, 1555L, 1556L, 1557L, 1558L, 1559L, 1560L, 1561L, 
                                                                         1562L, 1563L, 1564L, 1565L, 1566L, 1567L, 1568L, 1569L, 1570L, 
                                                                         1571L, 1572L, 1573L, 1574L, 1575L, 1576L, 1577L, 1578L, 1579L, 
                                                                         1580L, 1581L, 1582L, 1583L, 1584L, 1585L, 1586L, 1587L, 1588L, 
                                                                         1589L, 1590L, 1591L, 1592L, 1593L, 1594L, 1595L, 1596L, 1597L, 
                                                                         1598L, 1599L, 1600L, 1601L, 1602L, 1603L, 1604L, 1605L, 1606L, 
                                                                         1607L, 1608L, 1609L, 1610L, 1611L, 1612L, 1613L, 1614L, 1615L, 
                                                                         1616L, 1617L, 1618L, 1619L, 1620L, 1621L, 1622L, 1623L, 1624L, 
                                                                         1625L, 1626L, 1627L, 1628L, 1629L, 1630L, 1631L, 1632L, 1633L, 
                                                                         1634L, 1635L, 1636L, 1637L, 1638L, 1639L, 1640L, 1641L, 1642L, 
                                                                         1643L, 1644L, 1645L, 1646L, 1647L, 1648L, 1649L, 1650L, 1651L, 
                                                                         1652L, 1653L, 1654L, 1655L, 1656L, 1657L, 1658L, 1659L, 1660L, 
                                                                         1661L, 1662L, 1663L, 1664L, 1665L, 1666L, 1667L, 1668L, 1669L, 
                                                                         1670L, 1671L, 1672L, 1673L, 1674L, 1675L, 1676L, 1677L, 1678L, 
                                                                         1679L, 1680L, 1681L, 1682L, 1683L, 1684L, 1685L, 1686L, 1687L, 
                                                                         1688L, 1689L, 1690L, 1691L, 1692L, 1693L, 1694L, 1695L, 1696L, 
                                                                         1697L, 1698L, 1699L, 1700L, 1701L, 1702L, 1703L, 1704L, 1705L, 
                                                                         1706L, 1707L, 1708L, 1709L, 1710L, 1711L, 1712L, 1713L, 1714L, 
                                                                         1715L, 1716L, 1717L, 1718L, 1719L, 1720L, 1721L, 1722L, 1723L, 
                                                                         1724L, 1725L, 1726L, 1727L, 1728L, 1729L, 1730L, 1731L, 1732L, 
                                                                         1733L, 1734L, 1735L, 1736L, 1737L, 1738L, 1739L, 1740L, 1741L, 
                                                                         1742L, 1743L, 1744L, 1745L, 1746L, 1747L, 1748L, 1749L, 1750L, 
                                                                         1751L, 1752L, 1753L, 1754L, 1755L, 1756L, 1757L, 1758L, 1759L, 
                                                                         1760L, 1761L, 1762L, 1763L, 1764L, 1765L, 1766L, 1767L, 1768L, 
                                                                         1769L, 1770L, 1771L, 1772L, 1773L, 1774L, 1775L, 1776L, 1777L, 
                                                                         1778L, 1779L, 1780L, 1781L, 1782L, 1783L, 1785L, 1786L, 1788L, 
                                                                         1789L, 1790L, 1791L, 1792L, 1793L, 1794L, 1795L, 1796L, 1797L, 
                                                                         1798L, 1799L, 1800L, 1801L, 1802L, 1803L, 1804L, 1805L, 1806L, 
                                                                         1807L, 1808L, 1809L, 1810L, 1811L, 1812L, 1813L, 1814L, 1815L, 
                                                                         1817L, 1818L, 1819L, 1820L, 1821L, 1822L, 1823L, 1824L, 1825L, 
                                                                         1826L, 1827L, 1828L, 1829L, 1830L, 1831L, 1832L, 1833L, 1834L, 
                                                                         1835L, 1836L, 1837L, 1838L, 1839L, 1840L, 1841L, 1842L, 1843L, 
                                                                         1844L, 1845L, 1846L, 1847L, 1848L, 1849L, 1850L, 1851L, 1852L, 
                                                                         1853L, 1854L, 1855L, 1856L, 1857L, 1858L, 1859L, 1860L, 1861L, 
                                                                         1862L, 1863L, 1865L, 1866L, 1867L, 1868L, 1869L, 1870L, 1871L, 
                                                                         1872L, 1873L, 1874L, 1875L, 1876L, 1877L, 1878L, 1879L, 1880L, 
                                                                         1881L, 1882L, 1883L, 1884L, 1885L, 1886L, 1887L, 1888L, 1889L, 
                                                                         1890L, 1891L, 1892L, 1893L, 1898L, 1899L, 1900L, 1901L, 1902L, 
                                                                         1904L, 1905L, 1906L, 1907L, 1908L, 1909L, 1910L, 1911L, 1912L, 
                                                                         1913L, 1915L, 1916L, 1917L, 1918L, 1919L, 1920L, 1921L, 1923L, 
                                                                         1925L, 1926L, 1927L, 1928L, 1929L, 1930L, 1932L, 1933L, 1934L, 
                                                                         1935L, 1937L, 1938L, 1939L, 1940L, 1943L, 1944L, 1945L, 1946L, 
                                                                         1947L, 1948L, 1949L, 1950L, 1951L, 1952L, 1953L, 1954L, 1955L, 
                                                                         1956L, 1957L, 1958L, 1959L, 1961L, 1962L, 1963L, 1966L, 1967L, 
                                                                         1968L, 1969L, 1970L, 1971L, 1972L, 1975L, 1976L, 1977L, 1978L, 
                                                                         1979L, 1980L, 1981L, 1982L, 1983L, 1984L, 1985L, 1986L, 1987L, 
                                                                         1988L, 1989L, 1990L, 1991L, 1992L, 1993L, 1994L, 1995L, 1996L, 
                                                                         1998L, 1999L, 2000L, 2001L, 2002L, 2003L, 2004L, 2005L, 2009L, 
                                                                         2010L, 2011L, 2012L, 2013L, 2014L, 2015L, 2016L, 2017L, 2018L, 
                                                                         2019L, 2020L, 2022L, 2023L, 2024L, 2025L, 2026L, 2027L, 2028L, 
                                                                         2029L, 2030L, 2031L, 2032L, 2033L, 2034L, 2036L, 2037L, 2038L, 
                                                                         2039L, 2040L, 2041L, 2042L, 2043L, 2044L, 2045L, 2046L, 2047L, 
                                                                         2048L, 2049L, 2050L, 2051L, 2053L, 2054L, 2056L, 2057L, 2058L, 
                                                                         2059L, 2060L, 2061L, 2062L, 2063L, 2064L, 2065L, 2066L, 2067L, 
                                                                         2068L, 2069L, 2070L, 2071L, 2072L, 2073L, 2074L, 2075L, 2077L, 
                                                                         2078L, 2079L, 2080L, 2081L, 2082L, 2083L, 2084L, 2085L, 2086L, 
                                                                         2087L, 2088L, 2089L, 2093L, 2094L, 2095L, 2096L, 2097L, 2098L, 
                                                                         2099L, 2100L, 2101L, 2102L, 2103L, 2104L, 2105L, 2106L, 2107L, 
                                                                         2108L, 2109L, 2110L, 2111L, 2112L, 2113L, 2114L, 2115L, 2116L, 
                                                                         2117L, 2118L, 2119L, 2120L, 2121L, 2122L, 2123L, 2124L, 2125L, 
                                                                         2126L, 2127L, 2128L, 2129L, 2130L, 2131L, 2132L, 2133L), class = "data.frame")
