\name{Taxa}
\alias{Taxa-class}% the class
\alias{[.Taxa}
\alias{c.Taxa}
\alias{print.Taxa}
\alias{plot.Taxa}
\title{
Taxa training and testing objects
}
\description{
Taxonomic classification is the process of assigning an organism a label that is part of a taxonomic hierarchy (e.g., Phylum, Class, Order, Family, Genus).  Here, labels are assigned based on an organism's DNA or RNA sequence at a rank level determined by the classification's confidence.  Class \code{Taxa} provides objects and functions for storing and viewing training and testing objects used in taxonomic classification.
}
\usage{
\method{plot}{Taxa}(x,
    y = NULL,
    showRanks = TRUE,
    n = NULL,
    \dots)

\method{print}{Taxa}(x,
     \dots)

\method{[}{Taxa}(x, i, j, threshold)
}
\arguments{
  \item{x}{
An object of class \code{Taxa} with subclass \code{Train} or \code{Test}.
}
  \item{y}{
An (optional) object of class \code{Taxa} with the opposite subclass as \code{x}.
}
  \item{showRanks}{
Logical specifying whether to show all rank levels when plotting an object of class \code{Taxa} and subclass \code{Test}.  If \code{TRUE} (the default), then ranks are shown as (colored) concentric rings with radial lines delimiting taxa boundaries.
}
  \item{n}{
Numeric vector giving the frequency of each classification if \code{x} or \code{y} is an object of subclass \code{Test}, or the default (\code{NULL}) to treat all classifications as occurring once.  Typically, specifying \code{n} is useful when the classifications represent varying numbers of observations, e.g., when only unique sequences were originally classified.
}
  \item{\dots}{
Other optional parameters.
}
  \item{i}{
Numeric or character vector of indices to extract from objects of class \code{Taxa} with subclass \code{Test}.
}
  \item{j}{
Numeric or character vector of rank levels to extract from objects of class \code{Taxa} with subclass \code{Test}.
}
  \item{threshold}{
Numeric specifying the confidence \code{threshold} at which to truncate the output taxonomic classifications. Note that \code{threshold} must be higher than the original for the classifications to change.
}
}
\details{
Objects of class \code{Taxa} are stored as lists, and can have either subclass \code{Train} or \code{Test}.  The function \code{LearnTaxa} returns an object of subclass \code{Train}, while the function \code{IdTaxa} can return an object of class \code{Test}.

\code{Train}ing objects are built from a set of reference sequences with known taxonomic classifications.  List elements contain information required by \code{IdTaxa} for assigning a classification to test sequences.

\code{Test}ing objects can be generated by \code{IdTaxa} from a \code{Train}ing object and a set of test sequences.  Each list element contains the taxon, confidence, and (optionally) rank name of the taxonomic assignment.

The information stored in \code{Taxa} can be visualized with the \code{plot} function or displayed with \code{print}.  Only objects of subclass \code{Train} can be subsetted without losing their class.
}
\author{
Erik Wright \email{eswright@pitt.edu}
}
\seealso{
\code{\link{LearnTaxa}}, \code{\link{IdTaxa}}
}
\examples{
data("TrainingSet_16S")
plot(TrainingSet_16S)

# import test sequences
fas <- system.file("extdata", "Bacteria_175seqs.fas", package="DECIPHER")
dna <- readDNAStringSet(fas)

# remove any gaps in the sequences
dna <- RemoveGaps(dna)

# classify the test sequences
ids <- IdTaxa(dna, TrainingSet_16S, strand="top")
ids

plot(ids) # plot all rank levels
plot(ids[, 1:4]) # plot the first rank levels
plot(ids[j=c("rootrank", "class", "genus")]) # plot specific rank levels
plot(ids[threshold=70]) # plot high confidence classifications
}
