\name{TrainingSet_16S}
\alias{TrainingSet_16S}
\docType{data}
\title{
Training Set for Classification of 16S rRNA Gene Sequences
}
\description{
A pre-trained classifier for 16S rRNA gene sequences generated by \code{\link{LearnTaxa}}.
}
\usage{data("TrainingSet_16S")}
\format{
  A training set of class 'Taxa'
   * K-mer size: 8
   * Number of rank levels: 10
   * Total number of sequences: 2472
   * Number of taxonomic groups: 2472
   * Number of problem groups: 5
   * Number of problem sequences: 8
}
\details{
The original training sequences were pruned to a maximum of one sequence per group, as described in the 'Classifying Sequences' vignette.
}
\source{
Derived from version 16 of the RDP Training Set (\url{http://rdp.cme.msu.edu}) based on Bergey's Manual.
}
\note{
This 16S rRNA training set is provided for illustrative purposes only.  It is highly recommended to use a more comprehensive training set when classifying real sequences.  Examples of comprehensive training sets can be found at \url{http://DECIPHER.codes/Download.html}.
}
\references{
Whitman, W.B., Goodfellow, M., Kampfer, P., Busse, H.-J., Trujillo, M.E., Ludwig, W. & Suzuki, K.-i. (eds., 2012). Bergey's Manual of Systematic Bacteriology, 2nd ed., Springer-Verlag, New York, NY.
}
\examples{
data(TrainingSet_16S)
TrainingSet_16S
plot(TrainingSet_16S)
}
\keyword{datasets}
